/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.sbe.ir;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import uk.co.real_logic.sbe.ir.GenerationUtil;
import uk.co.real_logic.sbe.ir.Token;

public class MessageComponents {
    public final Token messageToken;
    public final List<Token> fields;
    public final List<Token> groups;
    public final List<Token> varData;

    public MessageComponents(Token messageToken, List<Token> fields, List<Token> groups, List<Token> varData) {
        this.messageToken = messageToken;
        this.fields = Collections.unmodifiableList(fields);
        this.groups = Collections.unmodifiableList(groups);
        this.varData = Collections.unmodifiableList(varData);
    }

    public static MessageComponents collectMessageComponents(List<Token> tokens) {
        Token msgToken = tokens.get(0);
        List<Token> messageBody = GenerationUtil.getMessageBody(tokens);
        int i = 0;
        ArrayList<Token> fields = new ArrayList<Token>();
        i = GenerationUtil.collectFields(messageBody, i, fields);
        ArrayList<Token> groups = new ArrayList<Token>();
        i = GenerationUtil.collectGroups(messageBody, i, groups);
        ArrayList<Token> varData = new ArrayList<Token>();
        GenerationUtil.collectVarData(messageBody, i, varData);
        return new MessageComponents(msgToken, fields, groups, varData);
    }
}

