/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.sbe.generation.rust;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.agrona.Verify;
import org.agrona.generation.OutputManager;
import uk.co.real_logic.sbe.PrimitiveType;
import uk.co.real_logic.sbe.generation.CodeGenerator;
import uk.co.real_logic.sbe.generation.NamedToken;
import uk.co.real_logic.sbe.generation.rust.RustCodecType;
import uk.co.real_logic.sbe.generation.rust.RustUtil;
import uk.co.real_logic.sbe.generation.rust.SplitCompositeTokens;
import uk.co.real_logic.sbe.ir.Encoding;
import uk.co.real_logic.sbe.ir.GenerationUtil;
import uk.co.real_logic.sbe.ir.HeaderStructure;
import uk.co.real_logic.sbe.ir.Ir;
import uk.co.real_logic.sbe.ir.MessageComponents;
import uk.co.real_logic.sbe.ir.Signal;
import uk.co.real_logic.sbe.ir.Token;

public class RustGenerator
implements CodeGenerator {
    private final Ir ir;
    private final OutputManager outputManager;
    static final String SCRATCH_ENCODER_TYPE = "ScratchEncoderData";
    static final String SCRATCH_ENCODER_PROPERTY = "scratch";
    static final String SCRATCH_DECODER_PROPERTY = "scratch";
    static final String SCRATCH_DECODER_TYPE = "ScratchDecoderData";
    static final String DATA_LIFETIME = "'d";

    public RustGenerator(Ir ir, OutputManager outputManager) {
        Verify.notNull((Object)ir, (String)"ir");
        Verify.notNull((Object)outputManager, (String)"outputManager");
        this.ir = ir;
        this.outputManager = outputManager;
    }

    @Override
    public void generate() throws IOException {
        RustGenerator.generateSharedImports(this.ir, this.outputManager);
        RustGenerator.generateResultEnums(this.outputManager);
        RustGenerator.generateDecoderScratchStruct(this.outputManager);
        RustGenerator.generateEncoderScratchStruct(this.ir, this.outputManager);
        RustGenerator.generateEitherEnum(this.outputManager);
        RustGenerator.generateEnums(this.ir, this.outputManager);
        RustGenerator.generateComposites(this.ir, this.outputManager);
        RustGenerator.generateBitSets(this.ir, this.outputManager);
        int headerSize = RustGenerator.totalByteSize(this.ir.headerStructure());
        for (List<Token> tokens : this.ir.messages()) {
            MessageComponents components = MessageComponents.collectMessageComponents(tokens);
            String messageTypeName = RustUtil.formatTypeName(components.messageToken.name());
            Optional<FieldsRepresentationSummary> fieldsRepresentation = RustGenerator.generateFieldsRepresentation(messageTypeName, components, this.outputManager);
            this.generateMessageHeaderDefault(this.ir, this.outputManager, components.messageToken);
            List<GroupTreeNode> groupTree = RustGenerator.buildGroupTrees(messageTypeName, components.groups);
            this.generateGroupFieldRepresentations(this.outputManager, groupTree);
            RustGenerator.generateMessageDecoder(this.outputManager, components, groupTree, fieldsRepresentation, headerSize);
            RustGenerator.generateMessageEncoder(this.outputManager, components, groupTree, fieldsRepresentation, headerSize);
        }
    }

    private static int totalByteSize(HeaderStructure headerStructure) {
        return headerStructure.tokens().stream().filter(t -> t.signal() == Signal.ENCODING || t.signal() == Signal.BEGIN_ENUM || t.signal() == Signal.BEGIN_SET).mapToInt(Token::encodedLength).sum();
    }

    private void generateGroupFieldRepresentations(OutputManager outputManager, List<GroupTreeNode> groupTree) throws IOException {
        try (Writer writer = outputManager.createOutput("Group fixed-field member representations");){
            this.generateGroupFieldRepresentations(writer, groupTree);
        }
    }

    private void generateGroupFieldRepresentations(Appendable appendable, List<GroupTreeNode> groupTree) throws IOException {
        for (GroupTreeNode node : groupTree) {
            RustGenerator.appendStructHeader(appendable, node.contextualName + "Member", true);
            RustGenerator.appendStructFields(appendable, node.simpleNamedFields);
            appendable.append("}\n");
            RustGenerator.generateConstantAccessorImpl(appendable, node.contextualName + "Member", node.rawFields);
            this.generateGroupFieldRepresentations(appendable, node.groups);
        }
    }

    private static Optional<FieldsRepresentationSummary> generateFieldsRepresentation(String messageTypeName, MessageComponents components, OutputManager outputManager) throws IOException {
        Token fieldToken;
        List<NamedToken> namedFieldTokens = NamedToken.gatherNamedNonConstantFieldTokens(components.fields);
        String representationStruct = messageTypeName + "Fields";
        try (Writer writer = outputManager.createOutput(messageTypeName + " Fixed-size Fields");){
            RustGenerator.appendStructHeader(writer, representationStruct, true);
            RustGenerator.appendStructFields(writer, namedFieldTokens);
            writer.append("}\n");
            RustGenerator.generateConstantAccessorImpl(writer, representationStruct, components.fields);
        }
        int numBytes = 0;
        int size = components.fields.size();
        for (int i = 0; i < size; i += fieldToken.componentTokenCount()) {
            fieldToken = components.fields.get(i);
            if (fieldToken.signal() == Signal.BEGIN_FIELD) {
                int fieldEnd = i + fieldToken.componentTokenCount();
                if (fieldToken.isConstantEncoding()) continue;
                for (int j = i; j < fieldEnd; ++j) {
                    Token t = components.fields.get(j);
                    if (t.isConstantEncoding() || t.signal() != Signal.ENCODING && t.signal() != Signal.BEGIN_ENUM && t.signal() != Signal.BEGIN_SET) continue;
                    numBytes += t.encodedLength();
                }
                continue;
            }
            throw new IllegalStateException("field tokens must include bounding BEGIN_FIELD and END_FIELD tokens");
        }
        return Optional.of(new FieldsRepresentationSummary(representationStruct, numBytes));
    }

    private static void generateBitSets(Ir ir, OutputManager outputManager) throws IOException {
        for (List<Token> tokens : ir.types()) {
            if (tokens.isEmpty() || tokens.get(0).signal() != Signal.BEGIN_SET) continue;
            RustGenerator.generateSingleBitSet(tokens, outputManager);
        }
    }

    private static void generateSingleBitSet(List<Token> tokens, OutputManager outputManager) throws IOException {
        Token beginToken = tokens.get(0);
        String setType = RustUtil.formatTypeName(beginToken.applicableTypeName());
        try (Writer writer = outputManager.createOutput(setType + " bit set");){
            writer.append("#[derive(Debug,Default)]\n");
            writer.append("#[repr(C,packed)]\n");
            String rustPrimitiveType = RustUtil.rustTypeName(beginToken.encoding().primitiveType());
            writer.append(String.format("pub struct %s(pub %s);\n", setType, rustPrimitiveType));
            writer.append(String.format("impl %s {\n", setType));
            RustUtil.indent(writer, 1, "pub fn new() -> Self {\n", new Object[0]);
            RustUtil.indent(writer, 2, "%s(0)\n", setType);
            RustUtil.indent(writer, 1, "}\n", new Object[0]);
            RustUtil.indent(writer, 1, "pub fn clear(&mut self) -> &mut Self {\n", new Object[0]);
            RustUtil.indent(writer, 2, "self.0 = 0;\n", new Object[0]);
            RustUtil.indent(writer, 2, "self\n", new Object[0]);
            RustUtil.indent(writer, 1, "}\n", new Object[0]);
            for (Token token : tokens) {
                if (Signal.CHOICE != token.signal()) continue;
                String choiceName = RustUtil.formatMethodName(token.name());
                Encoding encoding = token.encoding();
                String choiceBitIndex = encoding.constValue().toString();
                RustUtil.indent(writer, 1, "pub fn get_%s(&self) -> bool {\n", choiceName);
                RustUtil.indent(writer, 2, "0 != self.0 & (1 << %s)\n", choiceBitIndex);
                RustUtil.indent(writer, 1, "}\n", new Object[0]);
                RustUtil.indent(writer, 1, "pub fn set_%s(&mut self, value: bool) -> &mut Self {\n", choiceName);
                RustUtil.indent(writer, 2, "self.0 = if value {\n", new Object[0]);
                RustUtil.indent(writer, 3, "self.0 | (1 << %s)\n", choiceBitIndex);
                RustUtil.indent(writer, 2, "} else {\n", new Object[0]);
                RustUtil.indent(writer, 3, "self.0 & !(1 << %s)\n", choiceBitIndex);
                RustUtil.indent(writer, 2, "};\n", new Object[0]);
                RustUtil.indent(writer, 2, "self\n", new Object[0]);
                RustUtil.indent(writer, 1, "}\n", new Object[0]);
            }
            writer.append("}\n");
        }
    }

    private static void generateMessageEncoder(OutputManager outputManager, MessageComponents components, List<GroupTreeNode> groupTree, Optional<FieldsRepresentationSummary> fieldsRepresentation, int headerSize) throws IOException {
        Token msgToken = components.messageToken;
        String messageTypeName = RustUtil.formatTypeName(msgToken.name());
        RustCodecType codecType = RustCodecType.Encoder;
        String topType = codecType.generateDoneCoderType(outputManager, messageTypeName);
        topType = RustGenerator.generateTopVarDataCoders(messageTypeName, components.varData, outputManager, topType, codecType);
        topType = RustGenerator.generateGroupsCoders(groupTree, outputManager, topType, codecType);
        topType = RustGenerator.generateFixedFieldCoder(messageTypeName, outputManager, topType, fieldsRepresentation, codecType);
        topType = codecType.generateMessageHeaderCoder(messageTypeName, outputManager, topType, headerSize);
        RustGenerator.generateEntryPoint(messageTypeName, outputManager, topType, codecType);
    }

    private static void generateMessageDecoder(OutputManager outputManager, MessageComponents components, List<GroupTreeNode> groupTree, Optional<FieldsRepresentationSummary> fieldsRepresentation, int headerSize) throws IOException {
        Token msgToken = components.messageToken;
        String messageTypeName = RustUtil.formatTypeName(msgToken.name());
        RustCodecType codecType = RustCodecType.Decoder;
        String topType = codecType.generateDoneCoderType(outputManager, messageTypeName);
        topType = RustGenerator.generateTopVarDataCoders(messageTypeName, components.varData, outputManager, topType, codecType);
        topType = RustGenerator.generateGroupsCoders(groupTree, outputManager, topType, codecType);
        topType = RustGenerator.generateFixedFieldCoder(messageTypeName, outputManager, topType, fieldsRepresentation, codecType);
        topType = codecType.generateMessageHeaderCoder(messageTypeName, outputManager, topType, headerSize);
        RustGenerator.generateEntryPoint(messageTypeName, outputManager, topType, codecType);
    }

    private static void generateEntryPoint(String messageTypeName, OutputManager outputManager, String topType, RustCodecType codecType) throws IOException {
        try (Writer writer = outputManager.createOutput(messageTypeName + String.format(" %s entry point", codecType.name()));){
            String gerund = codecType.gerund();
            writer.append(String.format("pub fn start_%s_%s<%s>(data: &%s%s [u8]) -> %s {\n", gerund, RustUtil.formatMethodName(messageTypeName), DATA_LIFETIME, DATA_LIFETIME, codecType == RustCodecType.Encoder ? " mut" : "", RustGenerator.withLifetime(topType)));
            RustUtil.indent(writer, 1, "%s::wrap(%s { data: data, pos: 0 })\n", topType, codecType.scratchType());
            writer.append("}\n");
        }
    }

    static String withLifetime(String typeName) {
        return String.format("%s<%s>", typeName, DATA_LIFETIME);
    }

    private static String generateFixedFieldCoder(String messageTypeName, OutputManager outputManager, String topType, Optional<FieldsRepresentationSummary> fieldsRepresentationOptional, RustCodecType codecType) throws IOException {
        if (!fieldsRepresentationOptional.isPresent()) {
            return topType;
        }
        FieldsRepresentationSummary fieldsRepresentation = fieldsRepresentationOptional.get();
        try (Writer writer = outputManager.createOutput(messageTypeName + " Fixed fields " + codecType.name());){
            String representationStruct = fieldsRepresentation.typeName;
            String decoderName = representationStruct + codecType.name();
            codecType.appendScratchWrappingStruct(writer, decoderName);
            RustGenerator.appendImplWithLifetimeHeader(writer, decoderName);
            codecType.appendWrapMethod(writer, decoderName);
            codecType.appendDirectCodeMethods(writer, RustUtil.formatMethodName(messageTypeName) + "_fields", representationStruct, topType, fieldsRepresentation.numBytes);
            writer.append("}\n");
            String string = decoderName;
            return string;
        }
    }

    private static String generateGroupsCoders(List<GroupTreeNode> groupTreeNodes, OutputManager outputManager, String initialNextCoderType, RustCodecType codecType) throws IOException {
        String nextCoderType = initialNextCoderType;
        for (int i = groupTreeNodes.size() - 1; i >= 0; --i) {
            if (codecType == RustCodecType.Decoder) {
                nextCoderType = RustGenerator.generateGroupNodeDecoders(outputManager, nextCoderType, groupTreeNodes.get(i), false);
                continue;
            }
            if (codecType == RustCodecType.Encoder) {
                nextCoderType = RustGenerator.generateGroupNodeEncoders(outputManager, nextCoderType, groupTreeNodes.get(i), false);
                continue;
            }
            throw new IllegalArgumentException(String.format("Unknown CodecType %s", new Object[]{codecType}));
        }
        return nextCoderType;
    }

    private static String generateGroupNodeEncoders(OutputManager outputManager, String afterGroupCoderType, GroupTreeNode node, boolean atEndOfParent) throws IOException {
        String memberCoderType;
        boolean hasParent = node.parent.isPresent();
        if (!hasParent && atEndOfParent) {
            throw new IllegalArgumentException("Group cannot both lack a parent and be at the end of a parent group");
        }
        boolean atEndOfCurrentLevel = true;
        RustCodecType codecType = RustCodecType.Encoder;
        String nextCoderType = memberCoderType = node.contextualName + "Member" + codecType.name();
        if (!node.varData.isEmpty()) {
            for (VarDataSummary varDataSummary : RustGenerator.reversedList(node.varData)) {
                nextCoderType = varDataSummary.generateVarDataEncoder(node.contextualName, memberCoderType, node.depth() + 1, atEndOfCurrentLevel, outputManager, nextCoderType);
                atEndOfCurrentLevel = false;
            }
        }
        for (GroupTreeNode childNode : RustGenerator.reversedList(node.groups)) {
            nextCoderType = RustGenerator.generateGroupNodeEncoders(outputManager, nextCoderType, childNode, atEndOfCurrentLevel);
            atEndOfCurrentLevel = false;
        }
        return RustGenerator.writeGroupEncoderTopTypes(outputManager, afterGroupCoderType, node, atEndOfParent, atEndOfCurrentLevel, memberCoderType, nextCoderType);
    }

    private static String generateGroupNodeDecoders(OutputManager outputManager, String initialNextDecoderType, GroupTreeNode node, boolean atEndOfParent) throws IOException {
        String groupLevelNextDecoderType;
        boolean hasParent = node.parent.isPresent();
        if (!hasParent && atEndOfParent) {
            throw new IllegalArgumentException("Group cannot both lack a parent and be at the end of a parent group");
        }
        boolean atEndOfCurrentLevel = true;
        String memberDecoderType = node.contextualName + "MemberDecoder";
        String headerDecoderType = node.contextualName + "HeaderDecoder";
        String nextDecoderType = groupLevelNextDecoderType = String.format("Either<%s, %s>", RustGenerator.withLifetime(memberDecoderType), initialNextDecoderType.startsWith("Either") ? initialNextDecoderType : RustGenerator.withLifetime(initialNextDecoderType));
        if (!node.varData.isEmpty()) {
            for (VarDataSummary varDataSummary : RustGenerator.reversedList(node.varData)) {
                nextDecoderType = varDataSummary.generateVarDataDecoder(node.contextualName, memberDecoderType, node.depth() + 1, atEndOfCurrentLevel, outputManager, nextDecoderType);
                atEndOfCurrentLevel = false;
            }
        }
        for (GroupTreeNode childNode : RustGenerator.reversedList(node.groups)) {
            nextDecoderType = RustGenerator.generateGroupNodeDecoders(outputManager, nextDecoderType, childNode, atEndOfCurrentLevel);
            atEndOfCurrentLevel = false;
        }
        RustGenerator.writeGroupDecoderTopTypes(outputManager, initialNextDecoderType, node, atEndOfParent, atEndOfCurrentLevel, memberDecoderType, headerDecoderType, groupLevelNextDecoderType, nextDecoderType);
        return headerDecoderType;
    }

    private static String writeGroupEncoderTopTypes(OutputManager outputManager, String afterGroupCoderType, GroupTreeNode node, boolean atEndOfParent, boolean atEndOfCurrentLevel, String memberCoderType, String nextCoderType) throws IOException {
        String headerCoderType = node.contextualName + "HeaderEncoder";
        try (Writer out = outputManager.createOutput(node.contextualName + " Encoder for fields and header");){
            String contentBearingType;
            String contentProperty;
            RustGenerator.appendStructHeader(out, RustGenerator.withLifetime(memberCoderType), false);
            String rustCountType = RustUtil.rustTypeName(node.numInGroupType);
            if (node.parent.isPresent()) {
                contentProperty = "parent";
                contentBearingType = RustGenerator.withLifetime(node.parent.get().contextualName + "MemberEncoder");
            } else {
                contentProperty = "scratch";
                contentBearingType = RustGenerator.withLifetime(SCRATCH_ENCODER_TYPE);
            }
            RustUtil.indent(out, 1, "%s: %s,\n", contentProperty, contentBearingType);
            RustUtil.indent(out).append("count_write_pos: usize,\n");
            RustUtil.indent(out, 1, "count: %s,\n", rustCountType);
            out.append("}\n\n");
            RustGenerator.appendImplWithLifetimeHeader(out, memberCoderType);
            RustUtil.indent(out).append("#[inline]\n");
            RustUtil.indent(out, 1, "fn new(%s: %s, count_write_pos: usize) -> Self {\n", contentProperty, contentBearingType);
            RustUtil.indent(out, 2).append(memberCoderType).append(" {\n");
            RustUtil.indent(out, 3, "%s: %s,\n", contentProperty, contentProperty);
            RustUtil.indent(out, 3).append("count_write_pos: count_write_pos,\n");
            RustUtil.indent(out, 3).append("count: 0,\n");
            RustUtil.indent(out, 2).append("}\n").append("  ").append("}\n\n");
            RustUtil.indent(out).append("#[inline]\n");
            String fieldsType = node.contextualName + "Member";
            RustUtil.indent(out, 1, "pub fn next_%s_member(mut self, fields: &%s)", RustUtil.formatMethodName(node.originalName), fieldsType);
            out.append(String.format(" -> CodecResult<%s> {\n", RustGenerator.withLifetime(nextCoderType)));
            String scratchChain = RustGenerator.toScratchChain(node);
            RustUtil.indent(out, 2, "%s.write_type::<%s>(fields, %s)?; // block length\n", scratchChain, fieldsType, node.blockLength);
            RustUtil.indent(out, 2).append("self.count += 1;\n");
            RustUtil.indent(out, 2, "Ok(%s)\n", atEndOfCurrentLevel ? "self" : String.format("%s::wrap(self)", nextCoderType));
            RustUtil.indent(out).append("}\n");
            RustUtil.indent(out).append("#[inline]\n");
            RustUtil.indent(out, 1, "pub fn done_with_%s(mut self) -> CodecResult<%s> {\n", RustUtil.formatMethodName(node.originalName), RustGenerator.withLifetime(afterGroupCoderType));
            RustUtil.indent(out, 2, "%s.write_at_position::<%s>(self.count_write_pos, &self.count, %s)?;\n", scratchChain, rustCountType, node.numInGroupType.size());
            RustUtil.indent(out, 2, "Ok(%s)\n", atEndOfParent ? "self.parent" : String.format("%s::wrap(self.%s)", afterGroupCoderType, contentProperty));
            RustUtil.indent(out).append("}\n").append("}\n");
            RustGenerator.appendStructHeader(out, RustGenerator.withLifetime(headerCoderType), false);
            RustUtil.indent(out, 1, "%s: %s,\n", contentProperty, contentBearingType);
            out.append("}\n");
            RustGenerator.appendImplWithLifetimeHeader(out, headerCoderType);
            RustUtil.indent(out).append("#[inline]\n");
            RustUtil.indent(out, 1, "fn wrap(%s: %s) -> Self {\n", contentProperty, contentBearingType);
            RustUtil.indent(out, 2, "%s { %s: %s }\n", headerCoderType, contentProperty, contentProperty).append("  ").append("}\n");
            RustUtil.indent(out).append("#[inline]\n");
            RustUtil.indent(out, 1, "pub fn %s_individually(mut self) -> CodecResult<%s> {\n", RustUtil.formatMethodName(node.originalName), RustGenerator.withLifetime(memberCoderType));
            RustUtil.indent(out, 2, "%s.write_type::<%s>(&%s, %s)?; // block length\n", scratchChain, RustUtil.rustTypeName(node.blockLengthType), RustUtil.generateRustLiteral(node.blockLengthType, Integer.toString(node.blockLength)), node.blockLengthType.size());
            RustUtil.indent(out, 2, "let count_pos = %s.pos;\n", scratchChain);
            RustUtil.indent(out, 2, "%s.write_type::<%s>(&0, %s)?; // preliminary group member count\n", scratchChain, rustCountType, node.numInGroupType.size());
            RustUtil.indent(out, 2, "Ok(%s::new(self.%s, count_pos))\n", memberCoderType, contentProperty);
            RustUtil.indent(out, 1).append("}\n");
            if (node.hasFixedSizeMembers()) {
                RustGenerator.appendFixedSizeMemberGroupEncoderMethods(afterGroupCoderType, node, atEndOfParent, out, rustCountType, contentProperty, fieldsType, scratchChain);
            }
            out.append("}\n");
        }
        return headerCoderType;
    }

    private static void appendFixedSizeMemberGroupEncoderMethods(String afterGroupCoderType, GroupTreeNode node, boolean atEndOfParent, Writer out, String rustCountType, String contentProperty, String fieldsType, String scratchChain) throws IOException {
        RustUtil.indent(out).append("#[inline]\n");
        RustUtil.indent(out, 1, "pub fn %s_as_slice(mut self, count: %s) -> CodecResult<(&%s mut [%s], %s)> {\n", RustUtil.formatMethodName(node.originalName), rustCountType, DATA_LIFETIME, fieldsType, RustGenerator.withLifetime(afterGroupCoderType));
        RustUtil.indent(out, 2, "%s.write_type::<%s>(&%s, %s)?; // block length\n", scratchChain, RustUtil.rustTypeName(node.blockLengthType), RustUtil.generateRustLiteral(node.blockLengthType, Integer.toString(node.blockLength)), node.blockLengthType.size());
        RustUtil.indent(out, 2, "%s.write_type::<%s>(&count, %s)?; // group count\n", scratchChain, rustCountType, node.numInGroupType.size());
        RustUtil.indent(out, 2, "let c = count as usize;\n", new Object[0]);
        RustUtil.indent(out, 2, "let group_slice = %s.writable_slice::<%s>(c, %s)?;\n", scratchChain, fieldsType, node.blockLength);
        RustUtil.indent(out, 2, "Ok((group_slice, %s))\n", atEndOfParent ? "self.parent" : String.format("%s::wrap(self.%s)", afterGroupCoderType, contentProperty));
        RustUtil.indent(out, 1).append("}\n");
        RustUtil.indent(out).append("#[inline]\n");
        RustUtil.indent(out, 1, "pub fn %s_from_slice(mut self, s: &[%s]) -> CodecResult<%s> {\n", RustUtil.formatMethodName(node.originalName), fieldsType, RustGenerator.withLifetime(afterGroupCoderType));
        RustUtil.indent(out, 2, "%s.write_type::<%s>(&%s, %s)?; // block length\n", scratchChain, RustUtil.rustTypeName(node.blockLengthType), RustUtil.generateRustLiteral(node.blockLengthType, Integer.toString(node.blockLength)), node.blockLengthType.size());
        RustUtil.indent(out, 2, "let count = s.len();\n", new Object[0]);
        RustUtil.indent(out, 2, "if count > %s {\n", node.numInGroupType.maxValue());
        RustUtil.indent(out, 3).append("return Err(CodecErr::SliceIsLongerThanAllowedBySchema)\n");
        RustUtil.indent(out, 2).append("}\n");
        RustUtil.indent(out, 2, "%s.write_type::<%s>(&(count as %s), %s)?; // group count\n", scratchChain, rustCountType, rustCountType, node.numInGroupType.size());
        RustUtil.indent(out, 2, "%s.write_slice_without_count::<%s>(s, %s)?;\n", scratchChain, fieldsType, node.blockLength);
        RustUtil.indent(out, 2, "Ok(%s)\n", atEndOfParent ? "self.parent" : String.format("%s::wrap(self.%s)", afterGroupCoderType, contentProperty));
        RustUtil.indent(out, 1).append("}\n");
    }

    private static void writeGroupDecoderTopTypes(OutputManager outputManager, String initialNextDecoderType, GroupTreeNode node, boolean atEndOfParent, boolean atEndOfCurrentLevel, String memberDecoderType, String headerDecoderType, String groupLevelNextDecoderType, String nextDecoderType) throws IOException {
        try (Writer out = outputManager.createOutput(node.contextualName + " Decoder for fields and header");){
            String contentBearingType;
            String contentProperty;
            RustGenerator.appendStructHeader(out, RustGenerator.withLifetime(memberDecoderType), false);
            String rustCountType = RustUtil.rustTypeName(node.numInGroupType);
            if (node.parent.isPresent()) {
                contentProperty = "parent";
                contentBearingType = RustGenerator.withLifetime(node.parent.get().contextualName + "MemberDecoder");
            } else {
                contentProperty = "scratch";
                contentBearingType = RustGenerator.withLifetime(SCRATCH_DECODER_TYPE);
            }
            RustUtil.indent(out, 1, "%s: %s,\n", contentProperty, contentBearingType);
            RustUtil.indent(out, 1, "max_index: %s,\n", rustCountType);
            RustUtil.indent(out, 1, "index: %s,\n", rustCountType);
            out.append("}\n\n");
            RustGenerator.appendImplWithLifetimeHeader(out, memberDecoderType);
            RustUtil.indent(out, 1, "fn new(%s: %s, count: %s) -> Self {\n", contentProperty, contentBearingType, rustCountType);
            RustUtil.indent(out, 2, "assert!(count > 0%s);\n", rustCountType);
            RustUtil.indent(out, 2).append(memberDecoderType).append(" {\n");
            RustUtil.indent(out, 3, "%s: %s,\n", contentProperty, contentProperty);
            RustUtil.indent(out, 3).append("max_index: count - 1,\n");
            RustUtil.indent(out, 3).append("index: 0,\n");
            RustUtil.indent(out, 2).append("}\n").append("  ").append("}\n\n");
            RustUtil.indent(out, 1, "pub fn next_%s_member(mut self)", RustUtil.formatMethodName(node.originalName));
            out.append(String.format(" -> CodecResult<(&%s %s, %s)> {\n", DATA_LIFETIME, node.contextualName + "Member", nextDecoderType.startsWith("Either") ? nextDecoderType : RustGenerator.withLifetime(nextDecoderType)));
            RustUtil.indent(out, 2, "let v = %s.read_type::<%s>(%s)?;\n", RustGenerator.toScratchChain(node), node.contextualName + "Member", node.blockLength);
            RustUtil.indent(out, 2).append("self.index += 1;\n");
            RustUtil.indent(out, 2, "Ok((v, %s))\n", atEndOfCurrentLevel ? "self.after_member()" : String.format("%s::wrap(self)", nextDecoderType));
            RustUtil.indent(out).append("}\n");
            RustUtil.indent(out).append("#[inline]\n");
            RustUtil.indent(out, 1, "fn after_member(mut self) -> %s {\n", groupLevelNextDecoderType);
            RustUtil.indent(out, 2).append("if self.index <= self.max_index {\n");
            RustUtil.indent(out, 3).append("Either::Left(self)\n");
            RustUtil.indent(out, 2).append("} else {\n").append("  ").append("  ").append("  ").append(String.format("Either::Right(%s)\n", atEndOfParent ? "self.parent.after_member()" : String.format("%s::wrap(self.%s)", initialNextDecoderType, contentProperty)));
            RustUtil.indent(out, 2).append("}\n").append("  ").append("}\n").append("}\n");
            RustGenerator.appendStructHeader(out, RustGenerator.withLifetime(headerDecoderType), false);
            RustUtil.indent(out, 1, "%s: %s,\n", contentProperty, contentBearingType).append("}\n");
            RustGenerator.appendImplWithLifetimeHeader(out, headerDecoderType);
            RustUtil.indent(out, 1, "fn wrap(%s: %s) -> Self {\n", contentProperty, contentBearingType);
            RustUtil.indent(out, 2, "%s { %s: %s }\n", headerDecoderType, contentProperty, contentProperty).append("  ").append("}\n");
            RustUtil.indent(out, 1, "pub fn %s_individually(mut self) -> CodecResult<%s> {\n", RustUtil.formatMethodName(node.originalName), groupLevelNextDecoderType);
            RustUtil.indent(out, 2, "%s.skip_bytes(%s)?; // Skip reading block length for now\n", RustGenerator.toScratchChain(node), node.blockLengthType.size());
            RustUtil.indent(out, 2, "let count = *%s.read_type::<%s>(%s)?;\n", RustGenerator.toScratchChain(node), RustUtil.rustTypeName(node.numInGroupType), node.numInGroupType.size());
            RustUtil.indent(out, 2).append("if count > 0 {\n");
            RustUtil.indent(out, 3, "Ok(Either::Left(%s::new(self.%s, count)))\n", memberDecoderType, contentProperty).append("  ").append("  ").append("} else {\n");
            if (atEndOfParent) {
                RustUtil.indent(out, 3).append("Ok(Either::Right(self.parent.after_member()))\n");
            } else {
                RustUtil.indent(out, 3, "Ok(Either::Right(%s::wrap(self.%s)))\n", initialNextDecoderType, contentProperty);
            }
            RustUtil.indent(out, 2).append("}\n");
            RustUtil.indent(out, 1, "}\n", new Object[0]);
            if (node.hasFixedSizeMembers()) {
                RustGenerator.appendFixedSizeMemberGroupDecoderMethods(initialNextDecoderType, node, atEndOfParent, out, contentProperty);
            }
            out.append("}\n");
        }
    }

    private static void appendFixedSizeMemberGroupDecoderMethods(String initialNextDecoderType, GroupTreeNode node, boolean atEndOfParent, Writer out, String contentProperty) throws IOException {
        RustUtil.indent(out, 1, "pub fn %s_as_slice(mut self) -> CodecResult<(&%s [%s], %s)> {\n", RustUtil.formatMethodName(node.originalName), DATA_LIFETIME, node.contextualName + "Member", initialNextDecoderType.startsWith("Either") ? initialNextDecoderType : RustGenerator.withLifetime(initialNextDecoderType));
        RustUtil.indent(out, 2, "%s.skip_bytes(%s)?; // Skip reading block length for now\n", RustGenerator.toScratchChain(node), node.blockLengthType.size());
        RustUtil.indent(out, 2, "let count = *%s.read_type::<%s>(%s)?;\n", RustGenerator.toScratchChain(node), RustUtil.rustTypeName(node.numInGroupType), node.numInGroupType.size());
        RustUtil.indent(out, 2, "let s = %s.read_slice::<%s>(count as usize, %s)?;\n", RustGenerator.toScratchChain(node), node.contextualName + "Member", node.blockLength);
        RustUtil.indent(out, 2, "Ok((s,%s))\n", atEndOfParent ? "self.parent.after_member()" : String.format("%s::wrap(self.%s)", initialNextDecoderType, contentProperty));
        RustUtil.indent(out, 1, "}\n", new Object[0]);
    }

    private static String toScratchChain(GroupTreeNode node) {
        StringBuilder builder = new StringBuilder("self");
        Optional<GroupTreeNode> currentParent = node.parent;
        while (currentParent.isPresent()) {
            builder.append(".parent");
            currentParent = currentParent.get().parent;
        }
        builder.append(".scratch");
        return builder.toString();
    }

    private static String toScratchChain(int depth) {
        StringBuilder builder = new StringBuilder("self");
        for (int i = 0; i < depth; ++i) {
            builder.append(".parent");
        }
        builder.append(String.format(".%s", "scratch"));
        return builder.toString();
    }

    private static <T> Iterable<T> reversedList(List<T> list) {
        return () -> {
            if (list.isEmpty()) {
                return list.stream().iterator();
            }
            int maxIndex = list.size() - 1;
            return IntStream.rangeClosed(0, maxIndex).mapToObj(i -> list.get(maxIndex - i)).iterator();
        };
    }

    private static List<GroupTreeNode> buildGroupTrees(String parentTypeName, List<Token> groupsTokens) {
        return RustGenerator.buildGroupTrees(parentTypeName, groupsTokens, Optional.empty());
    }

    private static List<GroupTreeNode> buildGroupTrees(String parentTypeName, List<Token> groupsTokens, Optional<GroupTreeNode> parent) {
        int size = groupsTokens.size();
        ArrayList<GroupTreeNode> groups = new ArrayList<GroupTreeNode>();
        for (int i = 0; i < size; ++i) {
            Token groupToken = groupsTokens.get(i);
            if (groupToken.signal() != Signal.BEGIN_GROUP) {
                throw new IllegalStateException("tokens must begin with BEGIN_GROUP: token=" + groupToken);
            }
            String originalName = groupToken.name();
            String contextualName = parentTypeName + RustUtil.formatTypeName(originalName);
            Token dimensionsToken = groupsTokens.get(++i);
            int groupHeaderTokenCount = dimensionsToken.componentTokenCount();
            List<Token> dimensionsTokens = groupsTokens.subList(i, i + groupHeaderTokenCount);
            PrimitiveType numInGroupType = RustGenerator.findPrimitiveByTokenName(dimensionsTokens, "numInGroup");
            Token blockLengthToken = RustGenerator.findPrimitiveTokenByTokenName(dimensionsTokens, "blockLength");
            int blockLength = groupToken.encodedLength();
            PrimitiveType blockLengthType = blockLengthToken.encoding().primitiveType();
            i += groupHeaderTokenCount;
            ArrayList<Token> fields = new ArrayList<Token>();
            i = GenerationUtil.collectFields(groupsTokens, i, fields);
            ArrayList<Token> childGroups = new ArrayList<Token>();
            i = GenerationUtil.collectGroups(groupsTokens, i, childGroups);
            ArrayList<Token> varData = new ArrayList<Token>();
            i = GenerationUtil.collectVarData(groupsTokens, i, varData);
            List<VarDataSummary> varDataSummaries = VarDataSummary.gatherVarDataSummaries(varData);
            GroupTreeNode node = new GroupTreeNode(parent, originalName, contextualName, numInGroupType, blockLengthType, blockLength, fields, varDataSummaries);
            groups.add(node);
            RustGenerator.buildGroupTrees(contextualName, childGroups, Optional.of(node));
        }
        return groups;
    }

    private static PrimitiveType findPrimitiveByTokenName(List<Token> tokens, String targetName) {
        return RustGenerator.findPrimitiveTokenByTokenName(tokens, targetName).encoding().primitiveType();
    }

    private static Token findPrimitiveTokenByTokenName(List<Token> tokens, String targetName) {
        for (Token token : tokens) {
            if (!targetName.equalsIgnoreCase(token.name()) || token.encoding() == null || token.encoding().primitiveType() == null) continue;
            return token;
        }
        throw new IllegalStateException(String.format("%s not specified for group", targetName));
    }

    static String generateTopVarDataCoders(String messageTypeName, List<Token> tokens, OutputManager outputManager, String initialNextType, RustCodecType codecType) throws IOException {
        List<VarDataSummary> summaries = VarDataSummary.gatherVarDataSummaries(tokens);
        String nextCoderType = initialNextType;
        for (VarDataSummary summary : RustGenerator.reversedList(summaries)) {
            if (codecType == RustCodecType.Decoder) {
                nextCoderType = summary.generateVarDataDecoder(messageTypeName, SCRATCH_DECODER_TYPE, 0, false, outputManager, nextCoderType);
                continue;
            }
            if (codecType == RustCodecType.Encoder) {
                nextCoderType = summary.generateVarDataEncoder(messageTypeName, SCRATCH_ENCODER_TYPE, 0, false, outputManager, nextCoderType);
                continue;
            }
            throw new IllegalArgumentException(String.format("Unknown RustCodecType %s", new Object[]{codecType}));
        }
        return nextCoderType;
    }

    static void appendImplWithLifetimeHeader(Appendable appendable, String typeName) throws IOException {
        appendable.append(String.format("impl<%s> %s<%s> {\n", DATA_LIFETIME, typeName, DATA_LIFETIME));
    }

    private static void generateEnums(Ir ir, OutputManager outputManager) throws IOException {
        HashSet<String> enumTypeNames = new HashSet<String>();
        for (List<Token> tokens : ir.types()) {
            String typeName;
            Token beginToken;
            if (tokens.isEmpty() || (beginToken = tokens.get(0)).signal() != Signal.BEGIN_ENUM || enumTypeNames.contains(typeName = beginToken.applicableTypeName())) continue;
            RustGenerator.generateEnum(tokens, outputManager);
            enumTypeNames.add(typeName);
        }
    }

    static void generateSharedImports(Ir ir, OutputManager outputManager) throws IOException {
        try (Writer writer = outputManager.createOutput("Imports core rather than std to broaden usable environments.");){
            writer.append("extern crate core;\n");
        }
    }

    static void generateResultEnums(OutputManager outputManager) throws IOException {
        try (Writer writer = outputManager.createOutput("Result types for error handling");){
            writer.append("\n/// Errors that may occur during the course of encoding or decoding.\n");
            writer.append("#[derive(Debug)]\n");
            writer.append("pub enum CodecErr {\n");
            RustUtil.indent(writer, 1, "/// Too few bytes in the byte-slice to read or write the data structure relevant\n", new Object[0]);
            RustUtil.indent(writer, 1, "/// to the current state of the codec\n", new Object[0]);
            RustUtil.indent(writer, 1, "NotEnoughBytes,\n\n", new Object[0]);
            RustUtil.indent(writer, 1, "/// Groups and vardata are constrained by the numeric type chosen to represent their\n", new Object[0]);
            RustUtil.indent(writer, 1, "/// length as well as optional maxima imposed by the schema\n", new Object[0]);
            RustUtil.indent(writer, 1, "SliceIsLongerThanAllowedBySchema,\n", new Object[0]);
            writer.append("}\n\n");
            writer.append("pub type CodecResult<T> = core::result::Result<T, CodecErr>;\n");
        }
    }

    static void generateEncoderScratchStruct(Ir ir, OutputManager outputManager) throws IOException {
        try (Writer writer = outputManager.createOutput("Scratch Encoder Data Wrapper - codec internal use only");){
            writer.append("#[derive(Debug)]\n");
            writer.append(String.format("struct %s<%s> {\n", SCRATCH_ENCODER_TYPE, DATA_LIFETIME));
            RustUtil.indent(writer, 1, "data: &%s mut [u8],\n", DATA_LIFETIME);
            RustUtil.indent(writer).append("pos: usize,\n");
            writer.append("}\n");
            writer.append(String.format("%nimpl<%s> %s<%s> {\n", DATA_LIFETIME, SCRATCH_ENCODER_TYPE, DATA_LIFETIME));
            RustUtil.indent(writer, 1, "/// Copy the bytes of a value into the data buffer\n", new Object[0]);
            RustUtil.indent(writer, 1, "/// Advances the `pos` index to after the newly-written bytes.\n", new Object[0]);
            RustUtil.indent(writer).append("#[inline]\n");
            RustUtil.indent(writer).append("fn write_type<T>(&mut self, t: & T, num_bytes: usize) -> CodecResult<()> {\n");
            RustUtil.indent(writer, 2).append("let end = self.pos + num_bytes;\n");
            RustUtil.indent(writer, 2).append("if end <= self.data.len() {\n");
            RustUtil.indent(writer, 3).append("let source_bytes: &[u8] = unsafe {\n");
            RustUtil.indent(writer, 4).append("core::slice::from_raw_parts(t as *const T as *const u8, num_bytes)\n");
            RustUtil.indent(writer, 3).append("};\n");
            RustUtil.indent(writer, 3).append("(&mut self.data[self.pos..end]).copy_from_slice(source_bytes);\n");
            RustUtil.indent(writer, 3).append("self.pos = end;\n");
            RustUtil.indent(writer, 3).append("Ok(())\n");
            RustUtil.indent(writer, 2).append("} else {\n");
            RustUtil.indent(writer, 3).append("Err(CodecErr::NotEnoughBytes)\n");
            RustUtil.indent(writer, 2).append("}\n");
            RustUtil.indent(writer).append("}\n\n");
            RustUtil.indent(writer, 1, "/// Create a struct reference overlaid atop the data buffer\n", new Object[0]);
            RustUtil.indent(writer, 1, "/// such that changes to the struct directly edit the buffer. \n", new Object[0]);
            RustUtil.indent(writer, 1, "/// Note that the initial content of the struct's fields may be garbage.\n", new Object[0]);
            RustUtil.indent(writer, 1, "/// Advances the `pos` index to after the newly-written bytes.\n", new Object[0]);
            RustUtil.indent(writer).append("#[inline]\n");
            RustUtil.indent(writer, 1, "fn writable_overlay<T>(&mut self, num_bytes: usize) -> CodecResult<&%s mut T> {\n", DATA_LIFETIME);
            RustUtil.indent(writer, 2).append("let end = self.pos + num_bytes;\n");
            RustUtil.indent(writer, 2).append("if end <= self.data.len() {\n");
            RustUtil.indent(writer, 3, "let v: &%s mut T = unsafe {\n", DATA_LIFETIME);
            RustUtil.indent(writer, 4).append("let s = self.data.as_ptr().offset(self.pos as isize) as *mut T;\n");
            RustUtil.indent(writer, 4).append("&mut *s\n");
            RustUtil.indent(writer, 3).append("};\n");
            RustUtil.indent(writer, 3).append("self.pos = end;\n");
            RustUtil.indent(writer, 3).append("Ok(v)\n");
            RustUtil.indent(writer, 2).append("} else {\n");
            RustUtil.indent(writer, 3).append("Err(CodecErr::NotEnoughBytes)\n");
            RustUtil.indent(writer, 2).append("}\n");
            RustUtil.indent(writer).append("}\n\n");
            RustUtil.indent(writer, 1, "/// Copy the bytes of a value into the data buffer at a specific position\n", new Object[0]);
            RustUtil.indent(writer, 1, "/// Does **not** alter the `pos` index.\n", new Object[0]);
            RustUtil.indent(writer).append("#[inline]\n");
            RustUtil.indent(writer).append("fn write_at_position<T>(&mut self, position: usize, t: & T, num_bytes: usize) -> CodecResult<()> {\n");
            RustUtil.indent(writer, 2).append("let end = position + num_bytes;\n");
            RustUtil.indent(writer, 2).append("if end <= self.data.len() {\n");
            RustUtil.indent(writer, 3).append("let source_bytes: &[u8] = unsafe {\n");
            RustUtil.indent(writer, 4).append("core::slice::from_raw_parts(t as *const T as *const u8, num_bytes)\n");
            RustUtil.indent(writer, 3).append("};\n");
            RustUtil.indent(writer, 3).append("(&mut self.data[position..end]).copy_from_slice(source_bytes);\n");
            RustUtil.indent(writer, 3).append("Ok(())\n");
            RustUtil.indent(writer, 2).append("} else {\n");
            RustUtil.indent(writer, 3).append("Err(CodecErr::NotEnoughBytes)\n");
            RustUtil.indent(writer, 2).append("}\n");
            RustUtil.indent(writer).append("}\n");
            RustGenerator.generateEncoderScratchSliceMethods(writer);
            writer.append("}\n");
        }
    }

    static void generateEncoderScratchSliceMethods(Appendable writer) throws IOException {
        RustUtil.indent(writer, 1, "/// Create a mutable slice overlaid atop the data buffer directly\n", new Object[0]);
        RustUtil.indent(writer, 1, "/// such that changes to the slice contents directly edit the buffer\n", new Object[0]);
        RustUtil.indent(writer, 1, "/// Note that the initial content of the slice's members' fields may be garbage.\n", new Object[0]);
        RustUtil.indent(writer, 1, "/// Advances the `pos` index to after the region representing the slice.\n", new Object[0]);
        RustUtil.indent(writer).append("#[inline]\n");
        RustUtil.indent(writer, 1, "fn writable_slice<T>(&mut self, count: usize, bytes_per_item: usize) -> CodecResult<&%s mut [T]> {\n", DATA_LIFETIME);
        RustUtil.indent(writer, 2).append("let end = self.pos + (count * bytes_per_item);\n");
        RustUtil.indent(writer, 2).append("if end <= self.data.len() {\n");
        RustUtil.indent(writer, 3, "let v: &%s mut [T] = unsafe {\n", DATA_LIFETIME);
        RustUtil.indent(writer, 4).append("core::slice::from_raw_parts_mut(self.data[self.pos..end].as_mut_ptr() as *mut T, count)\n");
        RustUtil.indent(writer, 3).append("};\n");
        RustUtil.indent(writer, 3).append("self.pos = end;\n");
        RustUtil.indent(writer, 3).append("Ok(v)\n");
        RustUtil.indent(writer, 2).append("} else {\n");
        RustUtil.indent(writer, 3).append("Err(CodecErr::NotEnoughBytes)\n");
        RustUtil.indent(writer, 2).append("}\n");
        RustUtil.indent(writer).append("}\n\n");
        RustUtil.indent(writer, 1, "/// Copy the raw bytes of a slice's contents into the data buffer\n", new Object[0]);
        RustUtil.indent(writer, 1, "/// Does **not** encode the length of the slice explicitly into the buffer.\n", new Object[0]);
        RustUtil.indent(writer, 1, "/// Advances the `pos` index to after the newly-written slice bytes.\n", new Object[0]);
        RustUtil.indent(writer).append("#[inline]\n");
        RustUtil.indent(writer).append("fn write_slice_without_count<T>(&mut self, t: &[T], bytes_per_item: usize) -> CodecResult<()> {\n");
        RustUtil.indent(writer, 2).append("let content_bytes_size = bytes_per_item * t.len();\n");
        RustUtil.indent(writer, 2).append("let end = self.pos + content_bytes_size;\n");
        RustUtil.indent(writer, 2).append("if end <= self.data.len() {\n");
        RustUtil.indent(writer, 3).append("let source_bytes: &[u8] = unsafe {\n");
        RustUtil.indent(writer, 4).append("core::slice::from_raw_parts(t.as_ptr() as *const u8, content_bytes_size)\n");
        RustUtil.indent(writer, 3).append("};\n");
        RustUtil.indent(writer, 3).append("(&mut self.data[self.pos..end]).copy_from_slice(source_bytes);\n");
        RustUtil.indent(writer, 3).append("self.pos = end;\n");
        RustUtil.indent(writer, 3).append("Ok(())\n");
        RustUtil.indent(writer, 2).append("} else {\n");
        RustUtil.indent(writer, 3).append("Err(CodecErr::NotEnoughBytes)\n");
        RustUtil.indent(writer, 2).append("}\n");
        RustUtil.indent(writer).append("}\n");
    }

    private static void generateDecoderScratchStruct(OutputManager outputManager) throws IOException {
        try (Writer writer = outputManager.createOutput("Scratch Decoder Data Wrapper - codec internal use only");){
            writer.append("#[derive(Debug)]\n");
            writer.append(String.format("struct %s<%s> {\n", SCRATCH_DECODER_TYPE, DATA_LIFETIME));
            RustUtil.indent(writer, 1, "data: &%s [u8],\n", DATA_LIFETIME);
            RustUtil.indent(writer).append("pos: usize,\n");
            writer.append("}\n");
            writer.append(String.format("%nimpl<%s> %s<%s> {\n", DATA_LIFETIME, SCRATCH_DECODER_TYPE, DATA_LIFETIME));
            RustUtil.indent(writer, 1, "/// Create a struct reference overlaid atop the data buffer\n", new Object[0]);
            RustUtil.indent(writer, 1, "/// such that the struct's contents directly reflect the buffer. \n", new Object[0]);
            RustUtil.indent(writer, 1, "/// Advances the `pos` index by the size of the struct in bytes.\n", new Object[0]);
            RustUtil.indent(writer).append("#[inline]\n");
            RustUtil.indent(writer, 1, "fn read_type<T>(&mut self, num_bytes: usize) -> CodecResult<&%s T> {\n", DATA_LIFETIME);
            RustUtil.indent(writer, 2).append("let end = self.pos + num_bytes;\n");
            RustUtil.indent(writer, 2).append("if end <= self.data.len() {\n");
            RustUtil.indent(writer, 3).append("let s = self.data[self.pos..end].as_ptr() as *mut T;\n");
            RustUtil.indent(writer, 3, "let v: &%s T = unsafe { &*s };\n", DATA_LIFETIME);
            RustUtil.indent(writer, 3).append("self.pos = end;\n");
            RustUtil.indent(writer, 3).append("Ok(v)\n");
            RustUtil.indent(writer, 2).append("} else {\n");
            RustUtil.indent(writer, 3).append("Err(CodecErr::NotEnoughBytes)\n");
            RustUtil.indent(writer, 2).append("}\n");
            RustUtil.indent(writer).append("}\n\n");
            RustUtil.indent(writer, 1, "/// Advances the `pos` index by a set number of bytes.\n", new Object[0]);
            RustUtil.indent(writer).append("#[inline]\n");
            RustUtil.indent(writer).append("fn skip_bytes(&mut self, num_bytes: usize) -> CodecResult<()> {\n");
            RustUtil.indent(writer, 2).append("let end = self.pos + num_bytes;\n");
            RustUtil.indent(writer, 2).append("if end <= self.data.len() {\n");
            RustUtil.indent(writer, 3).append("self.pos = end;\n");
            RustUtil.indent(writer, 3).append("Ok(())\n");
            RustUtil.indent(writer, 2).append("} else {\n");
            RustUtil.indent(writer, 3).append("Err(CodecErr::NotEnoughBytes)\n");
            RustUtil.indent(writer, 2).append("}\n");
            RustUtil.indent(writer).append("}\n\n");
            RustUtil.indent(writer, 1, "/// Create a slice reference overlaid atop the data buffer\n", new Object[0]);
            RustUtil.indent(writer, 1, "/// such that the slice's members' contents directly reflect the buffer.\n", new Object[0]);
            RustUtil.indent(writer, 1, "/// Advances the `pos` index by the size of the slice contents in bytes.\n", new Object[0]);
            RustUtil.indent(writer).append("#[inline]\n");
            RustUtil.indent(writer, 1, "fn read_slice<T>(&mut self, count: usize, bytes_per_item: usize) -> CodecResult<&%s [T]> {\n", DATA_LIFETIME);
            RustUtil.indent(writer, 2).append("let num_bytes = bytes_per_item * count;\n");
            RustUtil.indent(writer, 2).append("let end = self.pos + num_bytes;\n");
            RustUtil.indent(writer, 2).append("if end <= self.data.len() {\n");
            RustUtil.indent(writer, 3, "let v: &%s [T] = unsafe {\n", DATA_LIFETIME);
            RustUtil.indent(writer, 4).append("core::slice::from_raw_parts(self.data[self.pos..end].as_ptr() as *const T, count)\n");
            RustUtil.indent(writer, 3).append("};\n");
            RustUtil.indent(writer, 3).append("self.pos = end;\n");
            RustUtil.indent(writer, 3).append("Ok(v)\n");
            RustUtil.indent(writer, 2).append("} else {\n");
            RustUtil.indent(writer, 3).append("Err(CodecErr::NotEnoughBytes)\n");
            RustUtil.indent(writer, 2).append("}\n");
            RustUtil.indent(writer).append("}\n");
            writer.append("}\n");
        }
    }

    private static void generateEitherEnum(OutputManager outputManager) throws IOException {
        try (Writer writer = outputManager.createOutput("Convenience Either enum");){
            writer.append("#[derive(Copy, Clone, PartialEq, Eq, PartialOrd, Ord, Hash, Debug)]\n");
            writer.append("pub enum Either<L, R> {\n");
            RustUtil.indent(writer).append("Left(L),\n");
            RustUtil.indent(writer).append("Right(R)\n");
            writer.append("}\n");
        }
    }

    private static void generateEnum(List<Token> enumTokens, OutputManager outputManager) throws IOException {
        String originalEnumName = enumTokens.get(0).applicableTypeName();
        String enumRustName = RustUtil.formatTypeName(originalEnumName);
        try (Writer writer = outputManager.createOutput("Enum " + enumRustName);){
            List<Token> messageBody = GenerationUtil.getMessageBody(enumTokens);
            if (messageBody.isEmpty()) {
                throw new IllegalArgumentException("No valid values provided for enum " + originalEnumName);
            }
            writer.append("#[derive(Clone,Copy,Debug,PartialEq,Eq,PartialOrd,Ord,Hash)]").append("\n");
            String rustReprTypeName = RustUtil.rustTypeName(messageBody.get(0).encoding().primitiveType());
            writer.append(String.format("#[repr(%s)]", rustReprTypeName)).append("\n");
            writer.append("pub enum ").append(enumRustName).append(" {\n");
            for (Token token : messageBody) {
                Encoding encoding = token.encoding();
                String literal = RustUtil.generateRustLiteral(encoding.primitiveType(), encoding.constValue().toString());
                RustUtil.indent(writer, 1).append(token.name()).append(" = ").append(literal).append(",\n");
            }
            writer.append("}\n");
        }
    }

    private static void generateComposites(Ir ir, OutputManager outputManager) throws IOException {
        for (List<Token> tokens : ir.types()) {
            if (tokens.isEmpty() || tokens.get(0).signal() != Signal.BEGIN_COMPOSITE) continue;
            RustGenerator.generateSingleComposite(tokens, outputManager);
        }
    }

    private static void generateSingleComposite(List<Token> tokens, OutputManager outputManager) throws IOException {
        Token beginToken = tokens.get(0);
        String originalTypeName = beginToken.applicableTypeName();
        String formattedTypeName = RustUtil.formatTypeName(originalTypeName);
        SplitCompositeTokens splitTokens = SplitCompositeTokens.splitInnerTokens(tokens);
        try (Writer writer = outputManager.createOutput(formattedTypeName);){
            RustGenerator.appendStructHeader(writer, formattedTypeName, true);
            RustGenerator.appendStructFields(writer, splitTokens.nonConstantEncodingTokens());
            writer.append("}\n");
            RustGenerator.generateConstantAccessorImpl(writer, formattedTypeName, GenerationUtil.getMessageBody(tokens));
        }
    }

    private static void appendStructFields(Appendable appendable, List<NamedToken> namedTokens) throws IOException {
        for (NamedToken namedToken : namedTokens) {
            Token typeToken = namedToken.typeToken();
            if (typeToken.isConstantEncoding()) continue;
            String propertyName = RustUtil.formatMethodName(namedToken.name());
            RustUtil.indent(appendable).append("pub ").append(propertyName).append(":");
            switch (typeToken.signal()) {
                case ENCODING: {
                    String rustPrimitiveType = RustUtil.rustTypeName(typeToken.encoding().primitiveType());
                    String rustFieldType = RustGenerator.getRustTypeForPrimitivePossiblyArray(typeToken, rustPrimitiveType);
                    appendable.append(rustFieldType);
                    break;
                }
                case BEGIN_ENUM: 
                case BEGIN_SET: 
                case BEGIN_COMPOSITE: {
                    appendable.append(RustUtil.formatTypeName(typeToken.applicableTypeName()));
                    break;
                }
                default: {
                    throw new IllegalStateException(String.format("Unsupported struct property from %s", typeToken.toString()));
                }
            }
            appendable.append(",\n");
        }
    }

    private void generateMessageHeaderDefault(Ir ir, OutputManager outputManager, Token messageToken) throws IOException {
        HeaderStructure header = ir.headerStructure();
        String messageTypeName = RustUtil.formatTypeName(messageToken.name());
        String wrapperName = messageTypeName + "MessageHeader";
        try (Writer writer = outputManager.createOutput(messageTypeName + " specific Message Header ");){
            RustGenerator.appendStructHeader(writer, wrapperName, true);
            RustUtil.indent(writer, 1, "pub message_header: MessageHeader\n", new Object[0]);
            writer.append("}\n");
            RustUtil.indent(writer, 1, "impl Default for %s {\n", wrapperName);
            RustUtil.indent(writer, 1, "fn default() -> %s {\n", wrapperName);
            RustUtil.indent(writer, 2, "%s {\n", wrapperName);
            RustUtil.indent(writer, 3, "message_header: MessageHeader {\n", new Object[0]);
            RustUtil.indent(writer, 4, "%s: %s,\n", RustUtil.formatMethodName("blockLength"), RustUtil.generateRustLiteral(header.blockLengthType(), Integer.toString(messageToken.encodedLength())));
            RustUtil.indent(writer, 4, "%s: %s,\n", RustUtil.formatMethodName("templateId"), RustUtil.generateRustLiteral(header.templateIdType(), Integer.toString(messageToken.id())));
            RustUtil.indent(writer, 4, "%s: %s,\n", RustUtil.formatMethodName("schemaId"), RustUtil.generateRustLiteral(header.schemaIdType(), Integer.toString(ir.id())));
            RustUtil.indent(writer, 4, "%s: %s,\n", RustUtil.formatMethodName("version"), RustUtil.generateRustLiteral(header.schemaVersionType(), Integer.toString(ir.version())));
            HashSet<String> reserved = new HashSet<String>(Arrays.asList("blockLength", "templateId", "schemaId", "version"));
            List nonReservedNamedTokens = SplitCompositeTokens.splitInnerTokens(header.tokens()).nonConstantEncodingTokens().stream().filter(namedToken -> !reserved.contains(namedToken.name())).collect(Collectors.toList());
            for (NamedToken namedToken2 : nonReservedNamedTokens) {
                RustUtil.indent(writer, 4, "%s: Default::default(),\n", RustUtil.formatMethodName(namedToken2.name()));
            }
            RustUtil.indent(writer, 3, "}\n", new Object[0]);
            RustUtil.indent(writer, 2, "}\n", new Object[0]);
            RustUtil.indent(writer, 1, "}\n", new Object[0]);
            writer.append("}\n");
        }
    }

    private static void appendStructHeader(Appendable appendable, String structName, boolean packedCRepresentation) throws IOException {
        if (packedCRepresentation) {
            appendable.append("#[repr(C,packed)]\n");
        }
        appendable.append(String.format("pub struct %s {\n", structName));
    }

    private static String getRustTypeForPrimitivePossiblyArray(Token encodingToken, String rustPrimitiveType) {
        String rustType = encodingToken.arrayLength() > 1 ? String.format("[%s;%s]", rustPrimitiveType, encodingToken.arrayLength()) : rustPrimitiveType;
        return rustType;
    }

    private static void generateConstantAccessorImpl(Appendable writer, String formattedTypeName, List<Token> unfilteredFields) throws IOException {
        writer.append(String.format("%nimpl %s {\n", formattedTypeName));
        int i = 0;
        while (i < unfilteredFields.size()) {
            String constantRustExpression;
            String constantRustTypeName;
            Token signalToken;
            Token fieldToken = unfilteredFields.get(i);
            String name = fieldToken.name();
            int componentTokenCount = fieldToken.componentTokenCount();
            if (fieldToken.signal() == Signal.BEGIN_FIELD) {
                if (i > unfilteredFields.size() - 1) {
                    throw new ArrayIndexOutOfBoundsException("BEGIN_FIELD token should be followed by content tokens");
                }
                signalToken = unfilteredFields.get(i + 1);
            } else {
                signalToken = fieldToken;
            }
            if (!fieldToken.isConstantEncoding() && !signalToken.isConstantEncoding()) {
                i += componentTokenCount;
                continue;
            }
            switch (signalToken.signal()) {
                case ENCODING: {
                    String rawValue = signalToken.encoding().constValue().toString();
                    if (signalToken.encoding().primitiveType() == PrimitiveType.CHAR) {
                        constantRustTypeName = "&'static str";
                        constantRustExpression = "\"" + rawValue + "\"";
                        break;
                    }
                    String constantRustPrimitiveType = RustUtil.rustTypeName(signalToken.encoding().primitiveType());
                    constantRustTypeName = RustGenerator.getRustTypeForPrimitivePossiblyArray(signalToken, constantRustPrimitiveType);
                    constantRustExpression = RustUtil.generateRustLiteral(signalToken.encoding().primitiveType(), rawValue);
                    break;
                }
                case BEGIN_ENUM: {
                    String enumType = RustUtil.formatTypeName(signalToken.applicableTypeName());
                    String rawConstValueName = fieldToken.encoding().constValue().toString();
                    int indexOfDot = rawConstValueName.indexOf(46);
                    String constValueName = -1 == indexOfDot ? rawConstValueName : rawConstValueName.substring(indexOfDot + 1);
                    boolean foundMatchingValueName = false;
                    for (int j = i; j < unfilteredFields.size(); ++j) {
                        Token searchAhead = unfilteredFields.get(j);
                        if (searchAhead.signal() != Signal.VALID_VALUE || !searchAhead.name().equals(constValueName)) continue;
                        foundMatchingValueName = true;
                        break;
                    }
                    if (!foundMatchingValueName) {
                        throw new IllegalStateException(String.format("Found a constant enum field that requested value %s, which is not an available enum option.", rawConstValueName));
                    }
                    constantRustTypeName = enumType;
                    constantRustExpression = enumType + "::" + constValueName;
                    break;
                }
                default: {
                    throw new IllegalStateException("Unsupported constant presence property " + fieldToken);
                }
            }
            RustGenerator.appendConstAccessor(writer, name, constantRustTypeName, constantRustExpression);
            i += componentTokenCount;
        }
        writer.append("}\n");
    }

    private static void appendConstAccessor(Appendable writer, String name, String rustTypeName, String rustExpression) throws IOException {
        writer.append("\n").append("  ").append("#[inline]\n").append("  ");
        writer.append(String.format("pub fn %s() -> %s {\n", RustUtil.formatMethodName(name), rustTypeName));
        RustUtil.indent(writer, 2).append(rustExpression).append("\n");
        RustUtil.indent(writer).append("}\n");
    }

    static class VarDataSummary {
        final String name;
        final PrimitiveType lengthType;
        final PrimitiveType dataType;

        VarDataSummary(String name, PrimitiveType lengthType, PrimitiveType dataType) {
            this.name = name;
            this.lengthType = lengthType;
            this.dataType = dataType;
        }

        String generateVarDataEncoder(String parentContextualName, String contentType, int groupDepth, boolean atEndOfGroup, OutputManager outputManager, String nextCoderType) throws IOException {
            if (groupDepth <= 0 && atEndOfGroup) {
                throw new IllegalStateException("Cannot be both outside of any group and at the end of a group");
            }
            RustCodecType codecType = RustCodecType.Encoder;
            String decoderType = parentContextualName + RustUtil.formatTypeName(this.name) + codecType.name();
            try (Writer writer = outputManager.createOutput(this.name + " variable-length data");){
                RustGenerator.appendStructHeader(writer, RustGenerator.withLifetime(decoderType), false);
                String contentPropertyName = groupDepth > 0 ? "parent" : codecType.scratchProperty();
                RustUtil.indent(writer, 1, "%s: %s,\n", contentPropertyName, RustGenerator.withLifetime(contentType));
                writer.append("}\n");
                RustGenerator.appendImplWithLifetimeHeader(writer, decoderType);
                RustUtil.indent(writer, 1, "fn wrap(%s: %s) -> Self {\n", contentPropertyName, RustGenerator.withLifetime(contentType));
                RustUtil.indent(writer, 2, "%s { %s: %s }\n", decoderType, contentPropertyName, contentPropertyName).append("  ").append("}\n");
                RustUtil.indent(writer, 1, "pub fn %s(mut self, s: &%s [%s]) -> CodecResult<%s> {\n", RustUtil.formatMethodName(this.name), RustGenerator.DATA_LIFETIME, RustUtil.rustTypeName(this.dataType), atEndOfGroup ? nextCoderType : RustGenerator.withLifetime(nextCoderType));
                RustUtil.indent(writer, 2).append("let l = s.len();\n");
                RustUtil.indent(writer, 2, "if l > %s {\n", this.lengthType.maxValue());
                RustUtil.indent(writer, 3).append("return Err(CodecErr::SliceIsLongerThanAllowedBySchema)\n");
                RustUtil.indent(writer, 2).append("}\n");
                RustUtil.indent(writer, 2).append("// Write data length\n");
                RustUtil.indent(writer, 2, "%s.write_type::<%s>(&(l as %s), %s)?; // group length\n", RustGenerator.toScratchChain(groupDepth), RustUtil.rustTypeName(this.lengthType), RustUtil.rustTypeName(this.lengthType), this.lengthType.size());
                RustUtil.indent(writer, 2).append(String.format("%s.write_slice_without_count::<%s>(s, %s)?;\n", RustGenerator.toScratchChain(groupDepth), RustUtil.rustTypeName(this.dataType), this.dataType.size()));
                RustUtil.indent(writer, 2, "Ok(%s)\n", atEndOfGroup ? "self.parent" : String.format("%s::wrap(self.%s)", nextCoderType, contentPropertyName));
                RustUtil.indent(writer).append("}\n}\n");
            }
            return decoderType;
        }

        String generateVarDataDecoder(String parentContextualName, String contentType, int groupDepth, boolean atEndOfGroup, OutputManager outputManager, String nextDecoderType) throws IOException {
            if (groupDepth <= 0 && atEndOfGroup) {
                throw new IllegalStateException("Cannot be both outside of any group and at the end of a group");
            }
            String name = this.name;
            String decoderType = parentContextualName + RustUtil.formatTypeName(name) + "Decoder";
            try (Writer writer = outputManager.createOutput(name + " variable-length data");){
                RustGenerator.appendStructHeader(writer, RustGenerator.withLifetime(decoderType), false);
                String contentPropertyName = groupDepth > 0 ? "parent" : "scratch";
                RustUtil.indent(writer, 1, "%s: %s,\n", contentPropertyName, RustGenerator.withLifetime(contentType));
                writer.append("}\n");
                RustGenerator.appendImplWithLifetimeHeader(writer, decoderType);
                RustUtil.indent(writer, 1, "fn wrap(%s: %s) -> Self {\n", contentPropertyName, RustGenerator.withLifetime(contentType));
                RustUtil.indent(writer, 2, "%s { %s: %s }\n", decoderType, contentPropertyName, contentPropertyName).append("  ").append("}\n");
                RustUtil.indent(writer, 1, "pub fn %s(mut self) -> CodecResult<(&%s [%s], %s)> {\n", RustUtil.formatMethodName(name), RustGenerator.DATA_LIFETIME, RustUtil.rustTypeName(this.dataType), atEndOfGroup ? nextDecoderType : RustGenerator.withLifetime(nextDecoderType));
                RustUtil.indent(writer, 2, "let count = *%s.read_type::<%s>(%s)?;\n", RustGenerator.toScratchChain(groupDepth), RustUtil.rustTypeName(this.lengthType), this.lengthType.size());
                String goToNext = atEndOfGroup ? "self.parent.after_member()" : String.format("%s::wrap(self.%s)", nextDecoderType, contentPropertyName);
                RustUtil.indent(writer, 2, "Ok((%s.read_slice::<%s>(count as usize, %s)?, %s))\n", RustGenerator.toScratchChain(groupDepth), RustUtil.rustTypeName(this.dataType), this.dataType.size(), goToNext);
                RustUtil.indent(writer).append("}\n");
                writer.append("}\n");
            }
            return decoderType;
        }

        static List<VarDataSummary> gatherVarDataSummaries(List<Token> tokens) {
            ArrayList<VarDataSummary> summaries = new ArrayList<VarDataSummary>();
            for (int i = 0; i < tokens.size(); ++i) {
                Token beginToken = tokens.get(i);
                if (beginToken.signal() != Signal.BEGIN_VAR_DATA) {
                    throw new IllegalStateException("tokens must begin with BEGIN_VAR_DATA: token=" + beginToken);
                }
                Token dimensionsToken = tokens.get(++i);
                int headerTokenCount = dimensionsToken.componentTokenCount();
                List<Token> currentEncodingTokens = tokens.subList(i, i + headerTokenCount);
                PrimitiveType lengthType = RustGenerator.findPrimitiveByTokenName(currentEncodingTokens, "length");
                PrimitiveType dataType = RustGenerator.findPrimitiveByTokenName(currentEncodingTokens, "varData");
                summaries.add(new VarDataSummary(beginToken.name(), lengthType, dataType));
                i += headerTokenCount;
            }
            return summaries;
        }
    }

    static class GroupTreeNode {
        final Optional<GroupTreeNode> parent;
        final String originalName;
        final String contextualName;
        final PrimitiveType numInGroupType;
        final PrimitiveType blockLengthType;
        final int blockLength;
        final List<Token> rawFields;
        final List<NamedToken> simpleNamedFields;
        final List<GroupTreeNode> groups = new ArrayList<GroupTreeNode>();
        final List<VarDataSummary> varData;

        GroupTreeNode(Optional<GroupTreeNode> parent, String originalName, String contextualName, PrimitiveType numInGroupType, PrimitiveType blockLengthType, int blockLength, List<Token> fields, List<VarDataSummary> varData) {
            this.parent = parent;
            this.originalName = originalName;
            this.contextualName = contextualName;
            this.numInGroupType = numInGroupType;
            this.blockLengthType = blockLengthType;
            this.blockLength = blockLength;
            this.rawFields = fields;
            this.simpleNamedFields = NamedToken.gatherNamedNonConstantFieldTokens(fields);
            this.varData = varData;
            parent.ifPresent(p -> p.addChild(this));
        }

        void addChild(GroupTreeNode child) {
            this.groups.add(child);
        }

        int depth() {
            Optional<GroupTreeNode> currentParent = this.parent;
            int d = 0;
            while (currentParent.isPresent()) {
                ++d;
                currentParent = currentParent.get().parent;
            }
            return d;
        }

        boolean hasFixedSizeMembers() {
            return this.groups.isEmpty() && this.varData.isEmpty();
        }
    }

    private static final class FieldsRepresentationSummary {
        final String typeName;
        final int numBytes;

        private FieldsRepresentationSummary(String typeName, int numBytes) {
            this.typeName = typeName;
            this.numBytes = numBytes;
        }
    }
}

