/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.sbe.examples;

import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import org.agrona.DirectBuffer;
import uk.co.real_logic.sbe.PrimitiveValue;
import uk.co.real_logic.sbe.ir.Encoding;
import uk.co.real_logic.sbe.ir.Token;
import uk.co.real_logic.sbe.otf.TokenListener;
import uk.co.real_logic.sbe.otf.Types;

public class ExampleTokenListener
implements TokenListener {
    private int compositeLevel = 0;
    private final PrintWriter out;
    private final Deque<String> namedScope = new ArrayDeque<String>();
    private final byte[] tempBuffer = new byte[1024];

    public ExampleTokenListener(PrintWriter out) {
        this.out = out;
    }

    public void onBeginMessage(Token token) {
        this.namedScope.push(token.name() + ".");
    }

    public void onEndMessage(Token token) {
        this.namedScope.pop();
    }

    public void onEncoding(Token fieldToken, DirectBuffer buffer, int index, Token typeToken, int actingVersion) {
        CharSequence value = ExampleTokenListener.readEncodingAsString(buffer, index, typeToken, fieldToken.version(), actingVersion);
        this.printScope();
        this.out.append(this.compositeLevel > 0 ? typeToken.name() : fieldToken.name()).append('=').append(value).println();
    }

    public void onEnum(Token fieldToken, DirectBuffer buffer, int bufferIndex, List<Token> tokens, int beginIndex, int endIndex, int actingVersion) {
        Token typeToken = tokens.get(beginIndex + 1);
        long encodedValue = ExampleTokenListener.readEncodingAsLong(buffer, bufferIndex, typeToken, fieldToken.version(), actingVersion);
        String value = null;
        if (fieldToken.isConstantEncoding()) {
            String refValue = fieldToken.encoding().constValue().toString();
            int indexOfDot = refValue.indexOf(46);
            value = -1 == indexOfDot ? refValue : refValue.substring(indexOfDot + 1);
        } else {
            for (int i = beginIndex + 1; i < endIndex; ++i) {
                if (encodedValue != tokens.get(i).encoding().constValue().longValue()) continue;
                value = tokens.get(i).name();
                break;
            }
        }
        this.printScope();
        this.out.append(this.determineName(0, fieldToken, tokens, beginIndex)).append('=').append(value).println();
    }

    public void onBitSet(Token fieldToken, DirectBuffer buffer, int bufferIndex, List<Token> tokens, int beginIndex, int endIndex, int actingVersion) {
        Token typeToken = tokens.get(beginIndex + 1);
        long encodedValue = ExampleTokenListener.readEncodingAsLong(buffer, bufferIndex, typeToken, fieldToken.version(), actingVersion);
        this.printScope();
        this.out.append(this.determineName(0, fieldToken, tokens, beginIndex)).append(':');
        for (int i = beginIndex + 1; i < endIndex; ++i) {
            this.out.append(' ').append(tokens.get(i).name()).append('=');
            long bitPosition = tokens.get(i).encoding().constValue().longValue();
            boolean flag = (encodedValue & 1L << (int)bitPosition) != 0L;
            this.out.append(Boolean.toString(flag));
        }
        this.out.println();
    }

    public void onBeginComposite(Token fieldToken, List<Token> tokens, int fromIndex, int toIndex) {
        ++this.compositeLevel;
        this.namedScope.push(this.determineName(1, fieldToken, tokens, fromIndex) + ".");
    }

    public void onEndComposite(Token fieldToken, List<Token> tokens, int fromIndex, int toIndex) {
        --this.compositeLevel;
        this.namedScope.pop();
    }

    public void onGroupHeader(Token token, int numInGroup) {
        this.printScope();
        this.out.append(token.name()).append(" Group Header : numInGroup=").append(Integer.toString(numInGroup)).println();
    }

    public void onBeginGroup(Token token, int groupIndex, int numInGroup) {
        this.namedScope.push(token.name() + ".");
    }

    public void onEndGroup(Token token, int groupIndex, int numInGroup) {
        this.namedScope.pop();
    }

    public void onVarData(Token fieldToken, DirectBuffer buffer, int bufferIndex, int length, Token typeToken) {
        Object value;
        try {
            String characterEncoding = typeToken.encoding().characterEncoding();
            if (null == characterEncoding) {
                value = length + " bytes of raw data";
            } else {
                buffer.getBytes(bufferIndex, this.tempBuffer, 0, length);
                value = new String(this.tempBuffer, 0, length, characterEncoding);
            }
        }
        catch (UnsupportedEncodingException ex) {
            ex.printStackTrace();
            return;
        }
        this.printScope();
        this.out.append(fieldToken.name()).append('=').append((CharSequence)value).println();
    }

    private String determineName(int thresholdLevel, Token fieldToken, List<Token> tokens, int fromIndex) {
        if (this.compositeLevel > thresholdLevel) {
            return tokens.get(fromIndex).name();
        }
        return fieldToken.name();
    }

    private static CharSequence readEncodingAsString(DirectBuffer buffer, int index, Token typeToken, int fieldVersion, int actingVersion) {
        PrimitiveValue constOrNotPresentValue = ExampleTokenListener.constOrNotPresentValue(typeToken, fieldVersion, actingVersion);
        if (null != constOrNotPresentValue) {
            String characterEncoding = constOrNotPresentValue.characterEncoding();
            if (constOrNotPresentValue.size() == 1 && null != characterEncoding) {
                try {
                    byte[] bytes = new byte[]{(byte)constOrNotPresentValue.longValue()};
                    return new String(bytes, characterEncoding);
                }
                catch (UnsupportedEncodingException ex) {
                    throw new RuntimeException(ex);
                }
            }
            String value = constOrNotPresentValue.toString();
            int size = typeToken.arrayLength();
            if (size < 2) {
                return value;
            }
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < size; ++i) {
                sb.append(value).append(", ");
            }
            sb.setLength(sb.length() - 2);
            return sb;
        }
        StringBuilder sb = new StringBuilder();
        Encoding encoding = typeToken.encoding();
        int elementSize = encoding.primitiveType().size();
        int size = typeToken.arrayLength();
        for (int i = 0; i < size; ++i) {
            Types.appendAsString((StringBuilder)sb, (DirectBuffer)buffer, (int)(index + i * elementSize), (Encoding)encoding);
            sb.append(", ");
        }
        sb.setLength(sb.length() - 2);
        return sb;
    }

    private static long readEncodingAsLong(DirectBuffer buffer, int bufferIndex, Token typeToken, int fieldVersion, int actingVersion) {
        PrimitiveValue constOrNotPresentValue = ExampleTokenListener.constOrNotPresentValue(typeToken, fieldVersion, actingVersion);
        if (null != constOrNotPresentValue) {
            return constOrNotPresentValue.longValue();
        }
        return Types.getLong((DirectBuffer)buffer, (int)bufferIndex, (Encoding)typeToken.encoding());
    }

    private static PrimitiveValue constOrNotPresentValue(Token typeToken, int fieldVersion, int actingVersion) {
        if (typeToken.isConstantEncoding()) {
            return typeToken.encoding().constValue();
        }
        if (typeToken.isOptionalEncoding() && actingVersion < fieldVersion) {
            return typeToken.encoding().applicableNullValue();
        }
        return null;
    }

    private void printScope() {
        Iterator<String> i = this.namedScope.descendingIterator();
        while (i.hasNext()) {
            this.out.print(i.next());
        }
    }
}

