/*
 * Decompiled with CFR 0.152.
 */
package baseline;

import baseline.BooleanType;
import baseline.BoosterEncoder;
import baseline.EngineDecoder;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.agrona.sbe.CompositeEncoderFlyweight;

public final class EngineEncoder
implements CompositeEncoderFlyweight {
    public static final int SCHEMA_ID = 1;
    public static final int SCHEMA_VERSION = 0;
    public static final String SEMANTIC_VERSION = "5.2";
    public static final int ENCODED_LENGTH = 10;
    public static final ByteOrder BYTE_ORDER = ByteOrder.LITTLE_ENDIAN;
    private int offset;
    private MutableDirectBuffer buffer;
    private static final byte[] FUEL_VALUE = new byte[]{80, 101, 116, 114, 111, 108};
    private final BoosterEncoder booster = new BoosterEncoder();

    public EngineEncoder wrap(MutableDirectBuffer buffer, int offset) {
        if (buffer != this.buffer) {
            this.buffer = buffer;
        }
        this.offset = offset;
        return this;
    }

    public MutableDirectBuffer buffer() {
        return this.buffer;
    }

    public int offset() {
        return this.offset;
    }

    public int encodedLength() {
        return 10;
    }

    public int sbeSchemaId() {
        return 1;
    }

    public int sbeSchemaVersion() {
        return 0;
    }

    public static int capacityEncodingOffset() {
        return 0;
    }

    public static int capacityEncodingLength() {
        return 2;
    }

    public static int capacityNullValue() {
        return 65535;
    }

    public static int capacityMinValue() {
        return 0;
    }

    public static int capacityMaxValue() {
        return 65534;
    }

    public EngineEncoder capacity(int value) {
        this.buffer.putShort(this.offset + 0, (short)value, BYTE_ORDER);
        return this;
    }

    public static int numCylindersEncodingOffset() {
        return 2;
    }

    public static int numCylindersEncodingLength() {
        return 1;
    }

    public static short numCylindersNullValue() {
        return 255;
    }

    public static short numCylindersMinValue() {
        return 0;
    }

    public static short numCylindersMaxValue() {
        return 254;
    }

    public EngineEncoder numCylinders(short value) {
        this.buffer.putByte(this.offset + 2, (byte)value);
        return this;
    }

    public static int maxRpmEncodingOffset() {
        return 3;
    }

    public static int maxRpmEncodingLength() {
        return 0;
    }

    public static int maxRpmNullValue() {
        return 65535;
    }

    public static int maxRpmMinValue() {
        return 0;
    }

    public static int maxRpmMaxValue() {
        return 65534;
    }

    public int maxRpm() {
        return 9000;
    }

    public static int manufacturerCodeEncodingOffset() {
        return 3;
    }

    public static int manufacturerCodeEncodingLength() {
        return 3;
    }

    public static byte manufacturerCodeNullValue() {
        return 0;
    }

    public static byte manufacturerCodeMinValue() {
        return 32;
    }

    public static byte manufacturerCodeMaxValue() {
        return 126;
    }

    public static int manufacturerCodeLength() {
        return 3;
    }

    public EngineEncoder manufacturerCode(int index, byte value) {
        if (index < 0 || index >= 3) {
            throw new IndexOutOfBoundsException("index out of range: index=" + index);
        }
        int pos = this.offset + 3 + index * 1;
        this.buffer.putByte(pos, value);
        return this;
    }

    public EngineEncoder putManufacturerCode(byte value0, byte value1, byte value2) {
        this.buffer.putByte(this.offset + 3, value0);
        this.buffer.putByte(this.offset + 4, value1);
        this.buffer.putByte(this.offset + 5, value2);
        return this;
    }

    public static String manufacturerCodeCharacterEncoding() {
        return StandardCharsets.US_ASCII.name();
    }

    public EngineEncoder putManufacturerCode(byte[] src, int srcOffset) {
        int length = 3;
        if (srcOffset < 0 || srcOffset > src.length - 3) {
            throw new IndexOutOfBoundsException("Copy will go out of range: offset=" + srcOffset);
        }
        this.buffer.putBytes(this.offset + 3, src, srcOffset, 3);
        return this;
    }

    public EngineEncoder manufacturerCode(String src) {
        int srcLength;
        int length = 3;
        int n = srcLength = null == src ? 0 : src.length();
        if (srcLength > 3) {
            throw new IndexOutOfBoundsException("String too large for copy: byte length=" + srcLength);
        }
        this.buffer.putStringWithoutLengthAscii(this.offset + 3, src);
        for (int start = srcLength; start < 3; ++start) {
            this.buffer.putByte(this.offset + 3 + start, (byte)0);
        }
        return this;
    }

    public EngineEncoder manufacturerCode(CharSequence src) {
        int srcLength;
        int length = 3;
        int n = srcLength = null == src ? 0 : src.length();
        if (srcLength > 3) {
            throw new IndexOutOfBoundsException("CharSequence too large for copy: byte length=" + srcLength);
        }
        this.buffer.putStringWithoutLengthAscii(this.offset + 3, src);
        for (int start = srcLength; start < 3; ++start) {
            this.buffer.putByte(this.offset + 3 + start, (byte)0);
        }
        return this;
    }

    public static int fuelEncodingOffset() {
        return 6;
    }

    public static int fuelEncodingLength() {
        return 0;
    }

    public static byte fuelNullValue() {
        return 0;
    }

    public static byte fuelMinValue() {
        return 32;
    }

    public static byte fuelMaxValue() {
        return 126;
    }

    public static int fuelLength() {
        return 6;
    }

    public byte fuel(int index) {
        return FUEL_VALUE[index];
    }

    public int getFuel(byte[] dst, int offset, int length) {
        int bytesCopied = Math.min(length, 6);
        System.arraycopy(FUEL_VALUE, 0, dst, offset, bytesCopied);
        return bytesCopied;
    }

    public String fuel() {
        return "Petrol";
    }

    public static int efficiencyEncodingOffset() {
        return 6;
    }

    public static int efficiencyEncodingLength() {
        return 1;
    }

    public static byte efficiencyNullValue() {
        return -128;
    }

    public static byte efficiencyMinValue() {
        return 0;
    }

    public static byte efficiencyMaxValue() {
        return 100;
    }

    public EngineEncoder efficiency(byte value) {
        this.buffer.putByte(this.offset + 6, value);
        return this;
    }

    public static int boosterEnabledEncodingOffset() {
        return 7;
    }

    public static int boosterEnabledEncodingLength() {
        return 1;
    }

    public EngineEncoder boosterEnabled(BooleanType value) {
        this.buffer.putByte(this.offset + 7, (byte)value.value());
        return this;
    }

    public static int boosterEncodingOffset() {
        return 8;
    }

    public static int boosterEncodingLength() {
        return 2;
    }

    public BoosterEncoder booster() {
        this.booster.wrap(this.buffer, this.offset + 8);
        return this.booster;
    }

    public String toString() {
        if (null == this.buffer) {
            return "";
        }
        return this.appendTo(new StringBuilder()).toString();
    }

    public StringBuilder appendTo(StringBuilder builder) {
        if (null == this.buffer) {
            return builder;
        }
        EngineDecoder decoder = new EngineDecoder();
        decoder.wrap((DirectBuffer)this.buffer, this.offset);
        return decoder.appendTo(builder);
    }
}

