/*
 * Decompiled with CFR 0.152.
 */
package baseline;

import baseline.BooleanType;
import baseline.CarDecoder;
import baseline.EngineEncoder;
import baseline.MessageHeaderEncoder;
import baseline.MetaAttribute;
import baseline.Model;
import baseline.OptionalExtrasEncoder;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import java.util.NoSuchElementException;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.agrona.collections.ArrayUtil;
import org.agrona.sbe.MessageEncoderFlyweight;

public final class CarEncoder
implements MessageEncoderFlyweight {
    public static final int BLOCK_LENGTH = 45;
    public static final int TEMPLATE_ID = 1;
    public static final int SCHEMA_ID = 1;
    public static final int SCHEMA_VERSION = 0;
    public static final String SEMANTIC_VERSION = "5.2";
    public static final ByteOrder BYTE_ORDER = ByteOrder.LITTLE_ENDIAN;
    private final CarEncoder parentMessage = this;
    private MutableDirectBuffer buffer;
    private int initialOffset;
    private int offset;
    private int limit;
    private final OptionalExtrasEncoder extras = new OptionalExtrasEncoder();
    private final EngineEncoder engine = new EngineEncoder();
    private final FuelFiguresEncoder fuelFigures = new FuelFiguresEncoder(this);
    private final PerformanceFiguresEncoder performanceFigures = new PerformanceFiguresEncoder(this);

    public int sbeBlockLength() {
        return 45;
    }

    public int sbeTemplateId() {
        return 1;
    }

    public int sbeSchemaId() {
        return 1;
    }

    public int sbeSchemaVersion() {
        return 0;
    }

    public String sbeSemanticType() {
        return "";
    }

    public MutableDirectBuffer buffer() {
        return this.buffer;
    }

    public int initialOffset() {
        return this.initialOffset;
    }

    public int offset() {
        return this.offset;
    }

    public CarEncoder wrap(MutableDirectBuffer buffer, int offset) {
        if (buffer != this.buffer) {
            this.buffer = buffer;
        }
        this.initialOffset = offset;
        this.offset = offset;
        this.limit(offset + 45);
        return this;
    }

    public CarEncoder wrapAndApplyHeader(MutableDirectBuffer buffer, int offset, MessageHeaderEncoder headerEncoder) {
        headerEncoder.wrap(buffer, offset).blockLength(45).templateId(1).schemaId(1).version(0);
        return this.wrap(buffer, offset + 8);
    }

    public int encodedLength() {
        return this.limit - this.offset;
    }

    public int limit() {
        return this.limit;
    }

    public void limit(int limit) {
        this.limit = limit;
    }

    public static int serialNumberId() {
        return 1;
    }

    public static int serialNumberSinceVersion() {
        return 0;
    }

    public static int serialNumberEncodingOffset() {
        return 0;
    }

    public static int serialNumberEncodingLength() {
        return 8;
    }

    public static String serialNumberMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static long serialNumberNullValue() {
        return -1L;
    }

    public static long serialNumberMinValue() {
        return 0L;
    }

    public static long serialNumberMaxValue() {
        return -2L;
    }

    public CarEncoder serialNumber(long value) {
        this.buffer.putLong(this.offset + 0, value, ByteOrder.LITTLE_ENDIAN);
        return this;
    }

    public static int modelYearId() {
        return 2;
    }

    public static int modelYearSinceVersion() {
        return 0;
    }

    public static int modelYearEncodingOffset() {
        return 8;
    }

    public static int modelYearEncodingLength() {
        return 2;
    }

    public static String modelYearMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static int modelYearNullValue() {
        return 65535;
    }

    public static int modelYearMinValue() {
        return 0;
    }

    public static int modelYearMaxValue() {
        return 65534;
    }

    public CarEncoder modelYear(int value) {
        this.buffer.putShort(this.offset + 8, (short)value, ByteOrder.LITTLE_ENDIAN);
        return this;
    }

    public static int availableId() {
        return 3;
    }

    public static int availableSinceVersion() {
        return 0;
    }

    public static int availableEncodingOffset() {
        return 10;
    }

    public static int availableEncodingLength() {
        return 1;
    }

    public static String availableMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public CarEncoder available(BooleanType value) {
        this.buffer.putByte(this.offset + 10, (byte)value.value());
        return this;
    }

    public static int codeId() {
        return 4;
    }

    public static int codeSinceVersion() {
        return 0;
    }

    public static int codeEncodingOffset() {
        return 11;
    }

    public static int codeEncodingLength() {
        return 1;
    }

    public static String codeMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public CarEncoder code(Model value) {
        this.buffer.putByte(this.offset + 11, value.value());
        return this;
    }

    public static int someNumbersId() {
        return 5;
    }

    public static int someNumbersSinceVersion() {
        return 0;
    }

    public static int someNumbersEncodingOffset() {
        return 12;
    }

    public static int someNumbersEncodingLength() {
        return 16;
    }

    public static String someNumbersMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static long someNumbersNullValue() {
        return 0xFFFFFFFFL;
    }

    public static long someNumbersMinValue() {
        return 0L;
    }

    public static long someNumbersMaxValue() {
        return 0xFFFFFFFEL;
    }

    public static int someNumbersLength() {
        return 4;
    }

    public CarEncoder someNumbers(int index, long value) {
        if (index < 0 || index >= 4) {
            throw new IndexOutOfBoundsException("index out of range: index=" + index);
        }
        int pos = this.offset + 12 + index * 4;
        this.buffer.putInt(pos, (int)value, ByteOrder.LITTLE_ENDIAN);
        return this;
    }

    public CarEncoder putSomeNumbers(long value0, long value1, long value2, long value3) {
        this.buffer.putInt(this.offset + 12, (int)value0, ByteOrder.LITTLE_ENDIAN);
        this.buffer.putInt(this.offset + 16, (int)value1, ByteOrder.LITTLE_ENDIAN);
        this.buffer.putInt(this.offset + 20, (int)value2, ByteOrder.LITTLE_ENDIAN);
        this.buffer.putInt(this.offset + 24, (int)value3, ByteOrder.LITTLE_ENDIAN);
        return this;
    }

    public static int vehicleCodeId() {
        return 6;
    }

    public static int vehicleCodeSinceVersion() {
        return 0;
    }

    public static int vehicleCodeEncodingOffset() {
        return 28;
    }

    public static int vehicleCodeEncodingLength() {
        return 6;
    }

    public static String vehicleCodeMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static byte vehicleCodeNullValue() {
        return 0;
    }

    public static byte vehicleCodeMinValue() {
        return 32;
    }

    public static byte vehicleCodeMaxValue() {
        return 126;
    }

    public static int vehicleCodeLength() {
        return 6;
    }

    public CarEncoder vehicleCode(int index, byte value) {
        if (index < 0 || index >= 6) {
            throw new IndexOutOfBoundsException("index out of range: index=" + index);
        }
        int pos = this.offset + 28 + index * 1;
        this.buffer.putByte(pos, value);
        return this;
    }

    public static String vehicleCodeCharacterEncoding() {
        return StandardCharsets.US_ASCII.name();
    }

    public CarEncoder putVehicleCode(byte[] src, int srcOffset) {
        int length = 6;
        if (srcOffset < 0 || srcOffset > src.length - 6) {
            throw new IndexOutOfBoundsException("Copy will go out of range: offset=" + srcOffset);
        }
        this.buffer.putBytes(this.offset + 28, src, srcOffset, 6);
        return this;
    }

    public CarEncoder vehicleCode(String src) {
        int srcLength;
        int length = 6;
        int n = srcLength = null == src ? 0 : src.length();
        if (srcLength > 6) {
            throw new IndexOutOfBoundsException("String too large for copy: byte length=" + srcLength);
        }
        this.buffer.putStringWithoutLengthAscii(this.offset + 28, src);
        for (int start = srcLength; start < 6; ++start) {
            this.buffer.putByte(this.offset + 28 + start, (byte)0);
        }
        return this;
    }

    public CarEncoder vehicleCode(CharSequence src) {
        int srcLength;
        int length = 6;
        int n = srcLength = null == src ? 0 : src.length();
        if (srcLength > 6) {
            throw new IndexOutOfBoundsException("CharSequence too large for copy: byte length=" + srcLength);
        }
        this.buffer.putStringWithoutLengthAscii(this.offset + 28, src);
        for (int start = srcLength; start < 6; ++start) {
            this.buffer.putByte(this.offset + 28 + start, (byte)0);
        }
        return this;
    }

    public static int extrasId() {
        return 7;
    }

    public static int extrasSinceVersion() {
        return 0;
    }

    public static int extrasEncodingOffset() {
        return 34;
    }

    public static int extrasEncodingLength() {
        return 1;
    }

    public static String extrasMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public OptionalExtrasEncoder extras() {
        this.extras.wrap(this.buffer, this.offset + 34);
        return this.extras;
    }

    public static int discountedModelId() {
        return 8;
    }

    public static int discountedModelSinceVersion() {
        return 0;
    }

    public static int discountedModelEncodingOffset() {
        return 35;
    }

    public static int discountedModelEncodingLength() {
        return 1;
    }

    public static String discountedModelMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "constant";
        }
        return "";
    }

    public static int engineId() {
        return 9;
    }

    public static int engineSinceVersion() {
        return 0;
    }

    public static int engineEncodingOffset() {
        return 35;
    }

    public static int engineEncodingLength() {
        return 10;
    }

    public static String engineMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public EngineEncoder engine() {
        this.engine.wrap(this.buffer, this.offset + 35);
        return this.engine;
    }

    public static long fuelFiguresId() {
        return 10L;
    }

    public FuelFiguresEncoder fuelFiguresCount(int count) {
        this.fuelFigures.wrap(this.buffer, count);
        return this.fuelFigures;
    }

    public static long performanceFiguresId() {
        return 13L;
    }

    public PerformanceFiguresEncoder performanceFiguresCount(int count) {
        this.performanceFigures.wrap(this.buffer, count);
        return this.performanceFigures;
    }

    public static int manufacturerId() {
        return 18;
    }

    public static String manufacturerCharacterEncoding() {
        return StandardCharsets.UTF_8.name();
    }

    public static String manufacturerMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static int manufacturerHeaderLength() {
        return 4;
    }

    public CarEncoder putManufacturer(DirectBuffer src, int srcOffset, int length) {
        if (length > 0x40000000) {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 4 + length);
        this.buffer.putInt(limit, length, ByteOrder.LITTLE_ENDIAN);
        this.buffer.putBytes(limit + 4, src, srcOffset, length);
        return this;
    }

    public CarEncoder putManufacturer(byte[] src, int srcOffset, int length) {
        if (length > 0x40000000) {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 4 + length);
        this.buffer.putInt(limit, length, ByteOrder.LITTLE_ENDIAN);
        this.buffer.putBytes(limit + 4, src, srcOffset, length);
        return this;
    }

    public CarEncoder manufacturer(String value) {
        byte[] bytes = null == value || value.isEmpty() ? ArrayUtil.EMPTY_BYTE_ARRAY : value.getBytes(StandardCharsets.UTF_8);
        int length = bytes.length;
        if (length > 0x40000000) {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 4 + length);
        this.buffer.putInt(limit, length, ByteOrder.LITTLE_ENDIAN);
        this.buffer.putBytes(limit + 4, bytes, 0, length);
        return this;
    }

    public static int modelId() {
        return 19;
    }

    public static String modelCharacterEncoding() {
        return StandardCharsets.UTF_8.name();
    }

    public static String modelMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static int modelHeaderLength() {
        return 4;
    }

    public CarEncoder putModel(DirectBuffer src, int srcOffset, int length) {
        if (length > 0x40000000) {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 4 + length);
        this.buffer.putInt(limit, length, ByteOrder.LITTLE_ENDIAN);
        this.buffer.putBytes(limit + 4, src, srcOffset, length);
        return this;
    }

    public CarEncoder putModel(byte[] src, int srcOffset, int length) {
        if (length > 0x40000000) {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 4 + length);
        this.buffer.putInt(limit, length, ByteOrder.LITTLE_ENDIAN);
        this.buffer.putBytes(limit + 4, src, srcOffset, length);
        return this;
    }

    public CarEncoder model(String value) {
        byte[] bytes = null == value || value.isEmpty() ? ArrayUtil.EMPTY_BYTE_ARRAY : value.getBytes(StandardCharsets.UTF_8);
        int length = bytes.length;
        if (length > 0x40000000) {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 4 + length);
        this.buffer.putInt(limit, length, ByteOrder.LITTLE_ENDIAN);
        this.buffer.putBytes(limit + 4, bytes, 0, length);
        return this;
    }

    public static int activationCodeId() {
        return 20;
    }

    public static String activationCodeCharacterEncoding() {
        return StandardCharsets.US_ASCII.name();
    }

    public static String activationCodeMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static int activationCodeHeaderLength() {
        return 4;
    }

    public CarEncoder putActivationCode(DirectBuffer src, int srcOffset, int length) {
        if (length > 0x40000000) {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 4 + length);
        this.buffer.putInt(limit, length, ByteOrder.LITTLE_ENDIAN);
        this.buffer.putBytes(limit + 4, src, srcOffset, length);
        return this;
    }

    public CarEncoder putActivationCode(byte[] src, int srcOffset, int length) {
        if (length > 0x40000000) {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 4 + length);
        this.buffer.putInt(limit, length, ByteOrder.LITTLE_ENDIAN);
        this.buffer.putBytes(limit + 4, src, srcOffset, length);
        return this;
    }

    public CarEncoder activationCode(String value) {
        int length;
        int n = length = null == value ? 0 : value.length();
        if (length > 0x40000000) {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 4 + length);
        this.buffer.putInt(limit, length, ByteOrder.LITTLE_ENDIAN);
        this.buffer.putStringWithoutLengthAscii(limit + 4, value);
        return this;
    }

    public CarEncoder activationCode(CharSequence value) {
        int length;
        int n = length = null == value ? 0 : value.length();
        if (length > 0x40000000) {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 4 + length);
        this.buffer.putInt(limit, length, ByteOrder.LITTLE_ENDIAN);
        this.buffer.putStringWithoutLengthAscii(limit + 4, value);
        return this;
    }

    public String toString() {
        if (null == this.buffer) {
            return "";
        }
        return this.appendTo(new StringBuilder()).toString();
    }

    public StringBuilder appendTo(StringBuilder builder) {
        if (null == this.buffer) {
            return builder;
        }
        CarDecoder decoder = new CarDecoder();
        decoder.wrap((DirectBuffer)this.buffer, this.initialOffset, 45, 0);
        return decoder.appendTo(builder);
    }

    public static final class PerformanceFiguresEncoder {
        public static final int HEADER_SIZE = 4;
        private final CarEncoder parentMessage;
        private MutableDirectBuffer buffer;
        private int count;
        private int index;
        private int offset;
        private int initialLimit;
        private final AccelerationEncoder acceleration;

        PerformanceFiguresEncoder(CarEncoder parentMessage) {
            this.parentMessage = parentMessage;
            this.acceleration = new AccelerationEncoder(parentMessage);
        }

        public void wrap(MutableDirectBuffer buffer, int count) {
            int limit;
            if (count < 0 || count > 65534) {
                throw new IllegalArgumentException("count outside allowed range: count=" + count);
            }
            if (buffer != this.buffer) {
                this.buffer = buffer;
            }
            this.index = 0;
            this.count = count;
            this.initialLimit = limit = this.parentMessage.limit();
            this.parentMessage.limit(limit + 4);
            buffer.putShort(limit + 0, (short)1, ByteOrder.LITTLE_ENDIAN);
            buffer.putShort(limit + 2, (short)count, ByteOrder.LITTLE_ENDIAN);
        }

        public PerformanceFiguresEncoder next() {
            if (this.index >= this.count) {
                throw new NoSuchElementException();
            }
            this.offset = this.parentMessage.limit();
            this.parentMessage.limit(this.offset + PerformanceFiguresEncoder.sbeBlockLength());
            ++this.index;
            return this;
        }

        public int resetCountToIndex() {
            this.count = this.index;
            this.buffer.putShort(this.initialLimit + 2, (short)this.count, ByteOrder.LITTLE_ENDIAN);
            return this.count;
        }

        public static int countMinValue() {
            return 0;
        }

        public static int countMaxValue() {
            return 65534;
        }

        public static int sbeHeaderSize() {
            return 4;
        }

        public static int sbeBlockLength() {
            return 1;
        }

        public static int octaneRatingId() {
            return 14;
        }

        public static int octaneRatingSinceVersion() {
            return 0;
        }

        public static int octaneRatingEncodingOffset() {
            return 0;
        }

        public static int octaneRatingEncodingLength() {
            return 1;
        }

        public static String octaneRatingMetaAttribute(MetaAttribute metaAttribute) {
            if (MetaAttribute.PRESENCE == metaAttribute) {
                return "required";
            }
            return "";
        }

        public static short octaneRatingNullValue() {
            return 255;
        }

        public static short octaneRatingMinValue() {
            return 90;
        }

        public static short octaneRatingMaxValue() {
            return 110;
        }

        public PerformanceFiguresEncoder octaneRating(short value) {
            this.buffer.putByte(this.offset + 0, (byte)value);
            return this;
        }

        public static long accelerationId() {
            return 15L;
        }

        public AccelerationEncoder accelerationCount(int count) {
            this.acceleration.wrap(this.buffer, count);
            return this.acceleration;
        }

        public static final class AccelerationEncoder {
            public static final int HEADER_SIZE = 4;
            private final CarEncoder parentMessage;
            private MutableDirectBuffer buffer;
            private int count;
            private int index;
            private int offset;
            private int initialLimit;

            AccelerationEncoder(CarEncoder parentMessage) {
                this.parentMessage = parentMessage;
            }

            public void wrap(MutableDirectBuffer buffer, int count) {
                int limit;
                if (count < 0 || count > 65534) {
                    throw new IllegalArgumentException("count outside allowed range: count=" + count);
                }
                if (buffer != this.buffer) {
                    this.buffer = buffer;
                }
                this.index = 0;
                this.count = count;
                this.initialLimit = limit = this.parentMessage.limit();
                this.parentMessage.limit(limit + 4);
                buffer.putShort(limit + 0, (short)6, ByteOrder.LITTLE_ENDIAN);
                buffer.putShort(limit + 2, (short)count, ByteOrder.LITTLE_ENDIAN);
            }

            public AccelerationEncoder next() {
                if (this.index >= this.count) {
                    throw new NoSuchElementException();
                }
                this.offset = this.parentMessage.limit();
                this.parentMessage.limit(this.offset + AccelerationEncoder.sbeBlockLength());
                ++this.index;
                return this;
            }

            public int resetCountToIndex() {
                this.count = this.index;
                this.buffer.putShort(this.initialLimit + 2, (short)this.count, ByteOrder.LITTLE_ENDIAN);
                return this.count;
            }

            public static int countMinValue() {
                return 0;
            }

            public static int countMaxValue() {
                return 65534;
            }

            public static int sbeHeaderSize() {
                return 4;
            }

            public static int sbeBlockLength() {
                return 6;
            }

            public static int mphId() {
                return 16;
            }

            public static int mphSinceVersion() {
                return 0;
            }

            public static int mphEncodingOffset() {
                return 0;
            }

            public static int mphEncodingLength() {
                return 2;
            }

            public static String mphMetaAttribute(MetaAttribute metaAttribute) {
                if (MetaAttribute.PRESENCE == metaAttribute) {
                    return "required";
                }
                return "";
            }

            public static int mphNullValue() {
                return 65535;
            }

            public static int mphMinValue() {
                return 0;
            }

            public static int mphMaxValue() {
                return 65534;
            }

            public AccelerationEncoder mph(int value) {
                this.buffer.putShort(this.offset + 0, (short)value, ByteOrder.LITTLE_ENDIAN);
                return this;
            }

            public static int secondsId() {
                return 17;
            }

            public static int secondsSinceVersion() {
                return 0;
            }

            public static int secondsEncodingOffset() {
                return 2;
            }

            public static int secondsEncodingLength() {
                return 4;
            }

            public static String secondsMetaAttribute(MetaAttribute metaAttribute) {
                if (MetaAttribute.PRESENCE == metaAttribute) {
                    return "required";
                }
                return "";
            }

            public static float secondsNullValue() {
                return Float.NaN;
            }

            public static float secondsMinValue() {
                return Float.MIN_VALUE;
            }

            public static float secondsMaxValue() {
                return Float.MAX_VALUE;
            }

            public AccelerationEncoder seconds(float value) {
                this.buffer.putFloat(this.offset + 2, value, ByteOrder.LITTLE_ENDIAN);
                return this;
            }
        }
    }

    public static final class FuelFiguresEncoder {
        public static final int HEADER_SIZE = 4;
        private final CarEncoder parentMessage;
        private MutableDirectBuffer buffer;
        private int count;
        private int index;
        private int offset;
        private int initialLimit;

        FuelFiguresEncoder(CarEncoder parentMessage) {
            this.parentMessage = parentMessage;
        }

        public void wrap(MutableDirectBuffer buffer, int count) {
            int limit;
            if (count < 0 || count > 65534) {
                throw new IllegalArgumentException("count outside allowed range: count=" + count);
            }
            if (buffer != this.buffer) {
                this.buffer = buffer;
            }
            this.index = 0;
            this.count = count;
            this.initialLimit = limit = this.parentMessage.limit();
            this.parentMessage.limit(limit + 4);
            buffer.putShort(limit + 0, (short)6, ByteOrder.LITTLE_ENDIAN);
            buffer.putShort(limit + 2, (short)count, ByteOrder.LITTLE_ENDIAN);
        }

        public FuelFiguresEncoder next() {
            if (this.index >= this.count) {
                throw new NoSuchElementException();
            }
            this.offset = this.parentMessage.limit();
            this.parentMessage.limit(this.offset + FuelFiguresEncoder.sbeBlockLength());
            ++this.index;
            return this;
        }

        public int resetCountToIndex() {
            this.count = this.index;
            this.buffer.putShort(this.initialLimit + 2, (short)this.count, ByteOrder.LITTLE_ENDIAN);
            return this.count;
        }

        public static int countMinValue() {
            return 0;
        }

        public static int countMaxValue() {
            return 65534;
        }

        public static int sbeHeaderSize() {
            return 4;
        }

        public static int sbeBlockLength() {
            return 6;
        }

        public static int speedId() {
            return 11;
        }

        public static int speedSinceVersion() {
            return 0;
        }

        public static int speedEncodingOffset() {
            return 0;
        }

        public static int speedEncodingLength() {
            return 2;
        }

        public static String speedMetaAttribute(MetaAttribute metaAttribute) {
            if (MetaAttribute.PRESENCE == metaAttribute) {
                return "required";
            }
            return "";
        }

        public static int speedNullValue() {
            return 65535;
        }

        public static int speedMinValue() {
            return 0;
        }

        public static int speedMaxValue() {
            return 65534;
        }

        public FuelFiguresEncoder speed(int value) {
            this.buffer.putShort(this.offset + 0, (short)value, ByteOrder.LITTLE_ENDIAN);
            return this;
        }

        public static int mpgId() {
            return 12;
        }

        public static int mpgSinceVersion() {
            return 0;
        }

        public static int mpgEncodingOffset() {
            return 2;
        }

        public static int mpgEncodingLength() {
            return 4;
        }

        public static String mpgMetaAttribute(MetaAttribute metaAttribute) {
            if (MetaAttribute.PRESENCE == metaAttribute) {
                return "required";
            }
            return "";
        }

        public static float mpgNullValue() {
            return Float.NaN;
        }

        public static float mpgMinValue() {
            return Float.MIN_VALUE;
        }

        public static float mpgMaxValue() {
            return Float.MAX_VALUE;
        }

        public FuelFiguresEncoder mpg(float value) {
            this.buffer.putFloat(this.offset + 2, value, ByteOrder.LITTLE_ENDIAN);
            return this;
        }

        public static int usageDescriptionId() {
            return 200;
        }

        public static String usageDescriptionCharacterEncoding() {
            return StandardCharsets.US_ASCII.name();
        }

        public static String usageDescriptionMetaAttribute(MetaAttribute metaAttribute) {
            if (MetaAttribute.PRESENCE == metaAttribute) {
                return "required";
            }
            return "";
        }

        public static int usageDescriptionHeaderLength() {
            return 4;
        }

        public FuelFiguresEncoder putUsageDescription(DirectBuffer src, int srcOffset, int length) {
            if (length > 0x40000000) {
                throw new IllegalStateException("length > maxValue for type: " + length);
            }
            int headerLength = 4;
            int limit = this.parentMessage.limit();
            this.parentMessage.limit(limit + 4 + length);
            this.buffer.putInt(limit, length, ByteOrder.LITTLE_ENDIAN);
            this.buffer.putBytes(limit + 4, src, srcOffset, length);
            return this;
        }

        public FuelFiguresEncoder putUsageDescription(byte[] src, int srcOffset, int length) {
            if (length > 0x40000000) {
                throw new IllegalStateException("length > maxValue for type: " + length);
            }
            int headerLength = 4;
            int limit = this.parentMessage.limit();
            this.parentMessage.limit(limit + 4 + length);
            this.buffer.putInt(limit, length, ByteOrder.LITTLE_ENDIAN);
            this.buffer.putBytes(limit + 4, src, srcOffset, length);
            return this;
        }

        public FuelFiguresEncoder usageDescription(String value) {
            int length;
            int n = length = null == value ? 0 : value.length();
            if (length > 0x40000000) {
                throw new IllegalStateException("length > maxValue for type: " + length);
            }
            int headerLength = 4;
            int limit = this.parentMessage.limit();
            this.parentMessage.limit(limit + 4 + length);
            this.buffer.putInt(limit, length, ByteOrder.LITTLE_ENDIAN);
            this.buffer.putStringWithoutLengthAscii(limit + 4, value);
            return this;
        }

        public FuelFiguresEncoder usageDescription(CharSequence value) {
            int length;
            int n = length = null == value ? 0 : value.length();
            if (length > 0x40000000) {
                throw new IllegalStateException("length > maxValue for type: " + length);
            }
            int headerLength = 4;
            int limit = this.parentMessage.limit();
            this.parentMessage.limit(limit + 4 + length);
            this.buffer.putInt(limit, length, ByteOrder.LITTLE_ENDIAN);
            this.buffer.putStringWithoutLengthAscii(limit + 4, value);
            return this;
        }
    }
}

