/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.decoder_flyweight;

import java.nio.charset.StandardCharsets;
import org.agrona.AsciiSequenceView;
import org.agrona.DirectBuffer;
import org.agrona.collections.IntHashSet;
import uk.co.real_logic.artio.Constants;
import uk.co.real_logic.artio.builder.Encoder;
import uk.co.real_logic.artio.builder.ExampleMessageEncoder;
import uk.co.real_logic.artio.builder.RejectUnknownField;
import uk.co.real_logic.artio.builder.Validation;
import uk.co.real_logic.artio.decoder_flyweight.HeaderDecoder;
import uk.co.real_logic.artio.decoder_flyweight.MessageDecoder;
import uk.co.real_logic.artio.decoder_flyweight.TrailerDecoder;
import uk.co.real_logic.artio.dictionary.generation.CodecUtil;
import uk.co.real_logic.artio.util.AsciiBuffer;

public class ExampleMessageDecoder
implements MessageDecoder {
    public final IntHashSet REQUIRED_FIELDS = new IntHashSet(2);
    private final IntHashSet alreadyVisitedFields;
    private final IntHashSet unknownFields;
    private final IntHashSet missingRequiredFields;
    private int invalidTagId;
    private int rejectReason;
    public static final long MESSAGE_TYPE = 66L;
    public static final String MESSAGE_TYPE_AS_STRING = "B";
    public static final char[] MESSAGE_TYPE_CHARS = "B".toCharArray();
    public static final byte[] MESSAGE_TYPE_BYTES = "B".getBytes(StandardCharsets.US_ASCII);
    public final IntHashSet messageFields;
    private final TrailerDecoder trailer;
    private final HeaderDecoder header;
    private char[] testReqID;
    private int testReqIDOffset;
    private int testReqIDLength;
    private AsciiBuffer buffer;

    public ExampleMessageDecoder() {
        if (Validation.CODEC_VALIDATION_ENABLED) {
            this.REQUIRED_FIELDS.add(112);
        }
        this.alreadyVisitedFields = new IntHashSet(2);
        this.unknownFields = new IntHashSet(10);
        this.missingRequiredFields = new IntHashSet(2);
        this.invalidTagId = -1;
        this.rejectReason = -1;
        this.messageFields = new IntHashSet(34);
        this.messageFields.add(8);
        this.messageFields.add(9);
        this.messageFields.add(35);
        this.messageFields.add(49);
        this.messageFields.add(56);
        this.messageFields.add(34);
        this.messageFields.add(50);
        this.messageFields.add(142);
        this.messageFields.add(57);
        this.messageFields.add(143);
        this.messageFields.add(43);
        this.messageFields.add(97);
        this.messageFields.add(52);
        this.messageFields.add(122);
        this.messageFields.add(369);
        this.messageFields.add(112);
        this.messageFields.add(10);
        this.trailer = new TrailerDecoder();
        this.header = new HeaderDecoder(this.trailer);
        this.testReqID = new char[1];
    }

    public int invalidTagId() {
        return this.invalidTagId;
    }

    public int rejectReason() {
        return this.rejectReason;
    }

    public boolean validate() {
        if (this.rejectReason != -1) {
            return false;
        }
        IntHashSet.IntIterator missingFieldsIterator = this.missingRequiredFields.iterator();
        IntHashSet.IntIterator unknownFieldsIterator = this.unknownFields.iterator();
        if (RejectUnknownField.CODEC_REJECT_UNKNOWN_FIELD_ENABLED && unknownFieldsIterator.hasNext()) {
            this.invalidTagId = unknownFieldsIterator.nextValue();
            this.rejectReason = Constants.ALL_FIELDS.contains(this.invalidTagId) ? 2 : 0;
            return false;
        }
        if (!this.header.validate()) {
            this.invalidTagId = this.header.invalidTagId();
            this.rejectReason = this.header.rejectReason();
            return false;
        }
        if (!this.trailer.validate()) {
            this.invalidTagId = this.trailer.invalidTagId();
            this.rejectReason = this.trailer.rejectReason();
            return false;
        }
        if (missingFieldsIterator.hasNext()) {
            this.invalidTagId = missingFieldsIterator.nextValue();
            this.rejectReason = 1;
            return false;
        }
        return true;
    }

    @Override
    public TrailerDecoder trailer() {
        return this.trailer;
    }

    @Override
    public HeaderDecoder header() {
        return this.header;
    }

    public char[] testReqID() {
        if (this.buffer != null && this.testReqIDLength > 0) {
            this.testReqID = this.buffer.getChars(this.testReqID, this.testReqIDOffset, this.testReqIDLength);
        }
        return this.testReqID;
    }

    public int testReqIDLength() {
        return this.testReqIDLength;
    }

    public String testReqIDAsString() {
        return this.buffer != null ? this.buffer.getStringWithoutLengthAscii(this.testReqIDOffset, this.testReqIDLength) : "";
    }

    public void testReqID(AsciiSequenceView view) {
        view.wrap((DirectBuffer)this.buffer, this.testReqIDOffset, this.testReqIDLength);
    }

    public int decode(AsciiBuffer buffer, int offset, int length) {
        int seenFieldCount = 0;
        if (Validation.CODEC_VALIDATION_ENABLED) {
            this.missingRequiredFields.copy(this.REQUIRED_FIELDS);
            this.alreadyVisitedFields.clear();
        }
        this.buffer = buffer;
        int end = offset + length;
        int position = offset;
        position += this.header.decode(buffer, position, length);
        while (position < end) {
            int equalsPosition = buffer.scan(position, end, '=');
            if (equalsPosition == -1) {
                return position;
            }
            int tag = buffer.getInt(position, equalsPosition);
            int valueOffset = equalsPosition + 1;
            int endOfField = buffer.scan(valueOffset, end, (byte)1);
            if (endOfField == -1 || equalsPosition == -1) {
                this.rejectReason = 5;
                break;
            }
            int valueLength = endOfField - valueOffset;
            if (Validation.CODEC_VALIDATION_ENABLED) {
                if (tag <= 0) {
                    this.invalidTagId = tag;
                    this.rejectReason = 0;
                } else if (valueLength == 0) {
                    this.invalidTagId = tag;
                    this.rejectReason = 4;
                }
                if (!this.alreadyVisitedFields.add(tag)) {
                    this.invalidTagId = tag;
                    this.rejectReason = 13;
                }
                this.missingRequiredFields.remove(tag);
                ++seenFieldCount;
            }
            switch (tag) {
                case 112: {
                    this.testReqIDOffset = valueOffset;
                    this.testReqIDLength = valueLength;
                    break;
                }
                default: {
                    if (!RejectUnknownField.CODEC_REJECT_UNKNOWN_FIELD_ENABLED) {
                        this.alreadyVisitedFields.remove(tag);
                    } else if (!this.trailer.REQUIRED_FIELDS.contains(tag)) {
                        this.unknownFields.add(tag);
                    }
                    if (!RejectUnknownField.CODEC_REJECT_UNKNOWN_FIELD_ENABLED && !this.trailer.REQUIRED_FIELDS.contains(tag)) break;
                    position += this.trailer.decode(buffer, position, end - position);
                    return position - offset;
                }
            }
            if (position >= endOfField + 1) continue;
            position = endOfField + 1;
        }
        position += this.trailer.decode(buffer, position, end - position);
        return position - offset;
    }

    public void reset() {
        this.header.reset();
        this.trailer.reset();
        this.resetMessage();
        this.buffer = null;
        if (Validation.CODEC_VALIDATION_ENABLED) {
            this.invalidTagId = -1;
            this.rejectReason = -1;
            this.missingRequiredFields.clear();
            this.unknownFields.clear();
            this.alreadyVisitedFields.clear();
        }
    }

    public void resetMessage() {
        this.resetTestReqID();
    }

    public void resetTestReqID() {
        this.testReqIDOffset = 0;
        this.testReqIDLength = 0;
    }

    public String toString() {
        return this.appendTo(new StringBuilder()).toString();
    }

    public StringBuilder appendTo(StringBuilder builder) {
        return this.appendTo(builder, 1);
    }

    public StringBuilder appendTo(StringBuilder builder, int level) {
        builder.append("{\n");
        CodecUtil.indent((StringBuilder)builder, (int)level);
        builder.append("\"MessageName\": \"ExampleMessage\",\n");
        builder.append("  \"header\": ");
        this.header.appendTo(builder, level + 1);
        builder.append("\n");
        CodecUtil.indent((StringBuilder)builder, (int)level);
        builder.append("\"TestReqID\": \"");
        builder.append(this.testReqID(), 0, this.testReqIDLength());
        builder.append("\",\n");
        CodecUtil.indent((StringBuilder)builder, (int)(level - 1));
        builder.append("}");
        return builder;
    }

    public ExampleMessageEncoder toEncoder(Encoder encoder) {
        return this.toEncoder((ExampleMessageEncoder)encoder);
    }

    public ExampleMessageEncoder toEncoder(ExampleMessageEncoder encoder) {
        encoder.reset();
        encoder.testReqID(this.testReqID(), 0, this.testReqIDLength());
        return encoder;
    }
}

