/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.builder;

import org.agrona.AsciiSequenceView;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.agrona.concurrent.UnsafeBuffer;
import uk.co.real_logic.artio.EncodingException;
import uk.co.real_logic.artio.UserRequestType;
import uk.co.real_logic.artio.builder.Encoder;
import uk.co.real_logic.artio.builder.HeaderEncoder;
import uk.co.real_logic.artio.builder.TrailerEncoder;
import uk.co.real_logic.artio.builder.Validation;
import uk.co.real_logic.artio.dictionary.generation.CodecUtil;
import uk.co.real_logic.artio.util.MutableAsciiBuffer;

public class UserRequestEncoder
implements Encoder {
    private TrailerEncoder trailer = new TrailerEncoder();
    private HeaderEncoder header = new HeaderEncoder();
    private static final int userRequestIDHeaderLength = 4;
    private static final byte[] userRequestIDHeader = new byte[]{57, 50, 51, 61};
    private static final int userRequestTypeHeaderLength = 4;
    private static final byte[] userRequestTypeHeader = new byte[]{57, 50, 52, 61};
    private static final int usernameHeaderLength = 4;
    private static final byte[] usernameHeader = new byte[]{53, 53, 51, 61};
    private static final int passwordHeaderLength = 4;
    private static final byte[] passwordHeader = new byte[]{53, 53, 52, 61};
    private static final int newPasswordHeaderLength = 4;
    private static final byte[] newPasswordHeader = new byte[]{57, 50, 53, 61};
    private final MutableDirectBuffer userRequestID = new UnsafeBuffer();
    private int userRequestIDOffset = 0;
    private int userRequestIDLength = 0;
    private int userRequestType;
    private boolean hasUserRequestType;
    private final MutableDirectBuffer username = new UnsafeBuffer();
    private int usernameOffset = 0;
    private int usernameLength = 0;
    private final MutableDirectBuffer password = new UnsafeBuffer();
    private int passwordOffset = 0;
    private int passwordLength = 0;
    private final MutableDirectBuffer newPassword = new UnsafeBuffer();
    private int newPasswordOffset = 0;
    private int newPasswordLength = 0;

    public long messageType() {
        return 17730L;
    }

    public UserRequestEncoder() {
        this.header.msgType("BE");
    }

    public TrailerEncoder trailer() {
        return this.trailer;
    }

    public HeaderEncoder header() {
        return this.header;
    }

    public UserRequestEncoder userRequestID(DirectBuffer value, int offset, int length) {
        this.userRequestID.wrap(value);
        this.userRequestIDOffset = offset;
        this.userRequestIDLength = length;
        return this;
    }

    public UserRequestEncoder userRequestID(DirectBuffer value, int length) {
        return this.userRequestID(value, 0, length);
    }

    public UserRequestEncoder userRequestID(DirectBuffer value) {
        return this.userRequestID(value, 0, value.capacity());
    }

    public UserRequestEncoder userRequestID(byte[] value, int offset, int length) {
        this.userRequestID.wrap(value);
        this.userRequestIDOffset = offset;
        this.userRequestIDLength = length;
        return this;
    }

    public UserRequestEncoder userRequestID(byte[] value, int length) {
        return this.userRequestID(value, 0, length);
    }

    public UserRequestEncoder userRequestID(byte[] value) {
        return this.userRequestID(value, 0, value.length);
    }

    public boolean hasUserRequestID() {
        return this.userRequestIDLength > 0;
    }

    public MutableDirectBuffer userRequestID() {
        return this.userRequestID;
    }

    public String userRequestIDAsString() {
        return this.userRequestID.getStringWithoutLengthAscii(this.userRequestIDOffset, this.userRequestIDLength);
    }

    public UserRequestEncoder userRequestID(CharSequence value) {
        CodecUtil.toBytes((CharSequence)value, (MutableDirectBuffer)this.userRequestID);
        this.userRequestIDOffset = 0;
        this.userRequestIDLength = value.length();
        return this;
    }

    public UserRequestEncoder userRequestID(AsciiSequenceView value) {
        DirectBuffer buffer = value.buffer();
        if (buffer != null) {
            this.userRequestID.wrap(buffer);
            this.userRequestIDOffset = value.offset();
            this.userRequestIDLength = value.length();
        }
        return this;
    }

    public UserRequestEncoder userRequestID(char[] value) {
        return this.userRequestID(value, 0, value.length);
    }

    public UserRequestEncoder userRequestID(char[] value, int length) {
        return this.userRequestID(value, 0, length);
    }

    public UserRequestEncoder userRequestID(char[] value, int offset, int length) {
        CodecUtil.toBytes((char[])value, (MutableDirectBuffer)this.userRequestID, (int)offset, (int)length);
        this.userRequestIDOffset = 0;
        this.userRequestIDLength = length;
        return this;
    }

    public boolean hasUserRequestType() {
        return this.hasUserRequestType;
    }

    public UserRequestEncoder userRequestType(int value) {
        this.userRequestType = value;
        this.hasUserRequestType = true;
        return this;
    }

    public int userRequestType() {
        return this.userRequestType;
    }

    public UserRequestEncoder userRequestType(UserRequestType value) {
        if (Validation.CODEC_VALIDATION_ENABLED) {
            if (value == UserRequestType.ARTIO_UNKNOWN) {
                throw new EncodingException("Invalid Value Field: userRequestType Value: " + (Object)((Object)value));
            }
            if (value == UserRequestType.NULL_VAL) {
                return this;
            }
        }
        return this.userRequestType(value.representation());
    }

    public UserRequestEncoder username(DirectBuffer value, int offset, int length) {
        this.username.wrap(value);
        this.usernameOffset = offset;
        this.usernameLength = length;
        return this;
    }

    public UserRequestEncoder username(DirectBuffer value, int length) {
        return this.username(value, 0, length);
    }

    public UserRequestEncoder username(DirectBuffer value) {
        return this.username(value, 0, value.capacity());
    }

    public UserRequestEncoder username(byte[] value, int offset, int length) {
        this.username.wrap(value);
        this.usernameOffset = offset;
        this.usernameLength = length;
        return this;
    }

    public UserRequestEncoder username(byte[] value, int length) {
        return this.username(value, 0, length);
    }

    public UserRequestEncoder username(byte[] value) {
        return this.username(value, 0, value.length);
    }

    public boolean hasUsername() {
        return this.usernameLength > 0;
    }

    public MutableDirectBuffer username() {
        return this.username;
    }

    public String usernameAsString() {
        return this.username.getStringWithoutLengthAscii(this.usernameOffset, this.usernameLength);
    }

    public UserRequestEncoder username(CharSequence value) {
        CodecUtil.toBytes((CharSequence)value, (MutableDirectBuffer)this.username);
        this.usernameOffset = 0;
        this.usernameLength = value.length();
        return this;
    }

    public UserRequestEncoder username(AsciiSequenceView value) {
        DirectBuffer buffer = value.buffer();
        if (buffer != null) {
            this.username.wrap(buffer);
            this.usernameOffset = value.offset();
            this.usernameLength = value.length();
        }
        return this;
    }

    public UserRequestEncoder username(char[] value) {
        return this.username(value, 0, value.length);
    }

    public UserRequestEncoder username(char[] value, int length) {
        return this.username(value, 0, length);
    }

    public UserRequestEncoder username(char[] value, int offset, int length) {
        CodecUtil.toBytes((char[])value, (MutableDirectBuffer)this.username, (int)offset, (int)length);
        this.usernameOffset = 0;
        this.usernameLength = length;
        return this;
    }

    public UserRequestEncoder password(DirectBuffer value, int offset, int length) {
        this.password.wrap(value);
        this.passwordOffset = offset;
        this.passwordLength = length;
        return this;
    }

    public UserRequestEncoder password(DirectBuffer value, int length) {
        return this.password(value, 0, length);
    }

    public UserRequestEncoder password(DirectBuffer value) {
        return this.password(value, 0, value.capacity());
    }

    public UserRequestEncoder password(byte[] value, int offset, int length) {
        this.password.wrap(value);
        this.passwordOffset = offset;
        this.passwordLength = length;
        return this;
    }

    public UserRequestEncoder password(byte[] value, int length) {
        return this.password(value, 0, length);
    }

    public UserRequestEncoder password(byte[] value) {
        return this.password(value, 0, value.length);
    }

    public boolean hasPassword() {
        return this.passwordLength > 0;
    }

    public MutableDirectBuffer password() {
        return this.password;
    }

    public String passwordAsString() {
        return this.password.getStringWithoutLengthAscii(this.passwordOffset, this.passwordLength);
    }

    public UserRequestEncoder password(CharSequence value) {
        CodecUtil.toBytes((CharSequence)value, (MutableDirectBuffer)this.password);
        this.passwordOffset = 0;
        this.passwordLength = value.length();
        return this;
    }

    public UserRequestEncoder password(AsciiSequenceView value) {
        DirectBuffer buffer = value.buffer();
        if (buffer != null) {
            this.password.wrap(buffer);
            this.passwordOffset = value.offset();
            this.passwordLength = value.length();
        }
        return this;
    }

    public UserRequestEncoder password(char[] value) {
        return this.password(value, 0, value.length);
    }

    public UserRequestEncoder password(char[] value, int length) {
        return this.password(value, 0, length);
    }

    public UserRequestEncoder password(char[] value, int offset, int length) {
        CodecUtil.toBytes((char[])value, (MutableDirectBuffer)this.password, (int)offset, (int)length);
        this.passwordOffset = 0;
        this.passwordLength = length;
        return this;
    }

    public UserRequestEncoder newPassword(DirectBuffer value, int offset, int length) {
        this.newPassword.wrap(value);
        this.newPasswordOffset = offset;
        this.newPasswordLength = length;
        return this;
    }

    public UserRequestEncoder newPassword(DirectBuffer value, int length) {
        return this.newPassword(value, 0, length);
    }

    public UserRequestEncoder newPassword(DirectBuffer value) {
        return this.newPassword(value, 0, value.capacity());
    }

    public UserRequestEncoder newPassword(byte[] value, int offset, int length) {
        this.newPassword.wrap(value);
        this.newPasswordOffset = offset;
        this.newPasswordLength = length;
        return this;
    }

    public UserRequestEncoder newPassword(byte[] value, int length) {
        return this.newPassword(value, 0, length);
    }

    public UserRequestEncoder newPassword(byte[] value) {
        return this.newPassword(value, 0, value.length);
    }

    public boolean hasNewPassword() {
        return this.newPasswordLength > 0;
    }

    public MutableDirectBuffer newPassword() {
        return this.newPassword;
    }

    public String newPasswordAsString() {
        return this.newPassword.getStringWithoutLengthAscii(this.newPasswordOffset, this.newPasswordLength);
    }

    public UserRequestEncoder newPassword(CharSequence value) {
        CodecUtil.toBytes((CharSequence)value, (MutableDirectBuffer)this.newPassword);
        this.newPasswordOffset = 0;
        this.newPasswordLength = value.length();
        return this;
    }

    public UserRequestEncoder newPassword(AsciiSequenceView value) {
        DirectBuffer buffer = value.buffer();
        if (buffer != null) {
            this.newPassword.wrap(buffer);
            this.newPasswordOffset = value.offset();
            this.newPasswordLength = value.length();
        }
        return this;
    }

    public UserRequestEncoder newPassword(char[] value) {
        return this.newPassword(value, 0, value.length);
    }

    public UserRequestEncoder newPassword(char[] value, int length) {
        return this.newPassword(value, 0, length);
    }

    public UserRequestEncoder newPassword(char[] value, int offset, int length) {
        CodecUtil.toBytes((char[])value, (MutableDirectBuffer)this.newPassword, (int)offset, (int)length);
        this.newPasswordOffset = 0;
        this.newPasswordLength = length;
        return this;
    }

    public long encode(MutableAsciiBuffer buffer, int offset) {
        long startMessageResult = this.header.startMessage(buffer, offset);
        int bodyStart = Encoder.offset((long)startMessageResult);
        int position = bodyStart + Encoder.length((long)startMessageResult);
        if (this.userRequestIDLength > 0) {
            buffer.putBytes(position, userRequestIDHeader, 0, 4);
            buffer.putBytes(position += 4, (DirectBuffer)this.userRequestID, this.userRequestIDOffset, this.userRequestIDLength);
            buffer.putSeparator(position += this.userRequestIDLength);
            ++position;
        } else if (Validation.CODEC_VALIDATION_ENABLED) {
            throw new EncodingException("Missing Field: UserRequestID");
        }
        if (this.hasUserRequestType) {
            buffer.putBytes(position, userRequestTypeHeader, 0, 4);
            position += 4;
            position += buffer.putIntAscii(position, this.userRequestType);
            buffer.putSeparator(position);
            ++position;
        } else if (Validation.CODEC_VALIDATION_ENABLED) {
            throw new EncodingException("Missing Field: UserRequestType");
        }
        if (this.usernameLength > 0) {
            buffer.putBytes(position, usernameHeader, 0, 4);
            buffer.putBytes(position += 4, (DirectBuffer)this.username, this.usernameOffset, this.usernameLength);
            buffer.putSeparator(position += this.usernameLength);
            ++position;
        } else if (Validation.CODEC_VALIDATION_ENABLED) {
            throw new EncodingException("Missing Field: Username");
        }
        if (this.passwordLength > 0) {
            buffer.putBytes(position, passwordHeader, 0, 4);
            buffer.putBytes(position += 4, (DirectBuffer)this.password, this.passwordOffset, this.passwordLength);
            buffer.putSeparator(position += this.passwordLength);
            ++position;
        }
        if (this.newPasswordLength > 0) {
            buffer.putBytes(position, newPasswordHeader, 0, 4);
            buffer.putBytes(position += 4, (DirectBuffer)this.newPassword, this.newPasswordOffset, this.newPasswordLength);
            buffer.putSeparator(position += this.newPasswordLength);
            ++position;
        }
        position += this.trailer.startTrailer(buffer, position);
        int messageStart = this.header.finishHeader(buffer, bodyStart, position - bodyStart);
        return this.trailer.finishMessage(buffer, messageStart, position);
    }

    public void reset() {
        this.header.reset();
        this.trailer.reset();
        this.resetMessage();
    }

    public void resetMessage() {
        this.resetUserRequestID();
        this.resetUserRequestType();
        this.resetUsername();
        this.resetPassword();
        this.resetNewPassword();
    }

    public void resetUserRequestID() {
        this.userRequestIDLength = 0;
    }

    public void resetUserRequestType() {
        this.hasUserRequestType = false;
    }

    public void resetUsername() {
        this.usernameLength = 0;
    }

    public void resetPassword() {
        this.passwordLength = 0;
    }

    public void resetNewPassword() {
        this.newPasswordLength = 0;
    }

    public String toString() {
        String entries = "  \"header\": " + this.header.toString().replace("\n", "\n  ") + "\n" + (this.hasUserRequestID() ? String.format("  \"UserRequestID\": \"%s\",\n", this.userRequestID.getStringWithoutLengthAscii(this.userRequestIDOffset, this.userRequestIDLength)) : "") + (this.hasUserRequestType() ? String.format("  \"UserRequestType\": \"%s\",\n", this.userRequestType) : "") + (this.hasUsername() ? String.format("  \"Username\": \"%s\",\n", this.username.getStringWithoutLengthAscii(this.usernameOffset, this.usernameLength)) : "") + (this.hasPassword() ? String.format("  \"Password\": \"%s\",\n", this.password.getStringWithoutLengthAscii(this.passwordOffset, this.passwordLength)) : "") + (this.hasNewPassword() ? String.format("  \"NewPassword\": \"%s\",\n", this.newPassword.getStringWithoutLengthAscii(this.newPasswordOffset, this.newPasswordLength)) : "");
        entries = "{\n  \"MessageName\": \"UserRequest\",\n" + entries + "}";
        return entries;
    }
}

