/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.builder;

import java.nio.charset.StandardCharsets;
import org.agrona.AsciiSequenceView;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.agrona.concurrent.UnsafeBuffer;
import uk.co.real_logic.artio.EncodingException;
import uk.co.real_logic.artio.MsgType;
import uk.co.real_logic.artio.builder.Encoder;
import uk.co.real_logic.artio.builder.SessionHeaderEncoder;
import uk.co.real_logic.artio.builder.Validation;
import uk.co.real_logic.artio.dictionary.generation.CodecUtil;
import uk.co.real_logic.artio.util.MutableAsciiBuffer;

public class HeaderEncoder
implements SessionHeaderEncoder {
    private static final byte[] DEFAULT_BEGIN_STRING = "FIX.4.4".getBytes(StandardCharsets.US_ASCII);
    private static final int beginStringHeaderLength = 2;
    private static final byte[] beginStringHeader = new byte[]{56, 61};
    private static final int bodyLengthHeaderLength = 2;
    private static final byte[] bodyLengthHeader = new byte[]{57, 61};
    private static final int msgTypeHeaderLength = 3;
    private static final byte[] msgTypeHeader = new byte[]{51, 53, 61};
    private static final int senderCompIDHeaderLength = 3;
    private static final byte[] senderCompIDHeader = new byte[]{52, 57, 61};
    private static final int targetCompIDHeaderLength = 3;
    private static final byte[] targetCompIDHeader = new byte[]{53, 54, 61};
    private static final int msgSeqNumHeaderLength = 3;
    private static final byte[] msgSeqNumHeader = new byte[]{51, 52, 61};
    private static final int senderSubIDHeaderLength = 3;
    private static final byte[] senderSubIDHeader = new byte[]{53, 48, 61};
    private static final int senderLocationIDHeaderLength = 4;
    private static final byte[] senderLocationIDHeader = new byte[]{49, 52, 50, 61};
    private static final int targetSubIDHeaderLength = 3;
    private static final byte[] targetSubIDHeader = new byte[]{53, 55, 61};
    private static final int targetLocationIDHeaderLength = 4;
    private static final byte[] targetLocationIDHeader = new byte[]{49, 52, 51, 61};
    private static final int possDupFlagHeaderLength = 3;
    private static final byte[] possDupFlagHeader = new byte[]{52, 51, 61};
    private static final int possResendHeaderLength = 3;
    private static final byte[] possResendHeader = new byte[]{57, 55, 61};
    private static final int sendingTimeHeaderLength = 3;
    private static final byte[] sendingTimeHeader = new byte[]{53, 50, 61};
    private static final int origSendingTimeHeaderLength = 4;
    private static final byte[] origSendingTimeHeader = new byte[]{49, 50, 50, 61};
    private static final int lastMsgSeqNumProcessedHeaderLength = 4;
    private static final byte[] lastMsgSeqNumProcessedHeader = new byte[]{51, 54, 57, 61};
    private final MutableDirectBuffer beginString = new UnsafeBuffer();
    private int beginStringOffset = 0;
    private int beginStringLength = 0;
    private final MutableDirectBuffer msgType = new UnsafeBuffer();
    private int msgTypeOffset = 0;
    private int msgTypeLength = 0;
    private final MutableDirectBuffer senderCompID = new UnsafeBuffer();
    private int senderCompIDOffset = 0;
    private int senderCompIDLength = 0;
    private final MutableDirectBuffer targetCompID = new UnsafeBuffer();
    private int targetCompIDOffset = 0;
    private int targetCompIDLength = 0;
    private int msgSeqNum;
    private boolean hasMsgSeqNum;
    private final MutableDirectBuffer senderSubID = new UnsafeBuffer();
    private int senderSubIDOffset = 0;
    private int senderSubIDLength = 0;
    private final MutableDirectBuffer senderLocationID = new UnsafeBuffer();
    private int senderLocationIDOffset = 0;
    private int senderLocationIDLength = 0;
    private final MutableDirectBuffer targetSubID = new UnsafeBuffer();
    private int targetSubIDOffset = 0;
    private int targetSubIDLength = 0;
    private final MutableDirectBuffer targetLocationID = new UnsafeBuffer();
    private int targetLocationIDOffset = 0;
    private int targetLocationIDLength = 0;
    private boolean possDupFlag;
    private boolean hasPossDupFlag;
    private boolean possResend;
    private boolean hasPossResend;
    private final MutableDirectBuffer sendingTime = new UnsafeBuffer();
    private int sendingTimeOffset = 0;
    private int sendingTimeLength = 0;
    private final MutableDirectBuffer origSendingTime = new UnsafeBuffer();
    private int origSendingTimeOffset = 0;
    private int origSendingTimeLength = 0;
    private int lastMsgSeqNumProcessed;
    private boolean hasLastMsgSeqNumProcessed;

    public HeaderEncoder() {
        this.beginString(DEFAULT_BEGIN_STRING);
    }

    public HeaderEncoder beginString(DirectBuffer value, int offset, int length) {
        this.beginString.wrap(value);
        this.beginStringOffset = offset;
        this.beginStringLength = length;
        return this;
    }

    public HeaderEncoder beginString(DirectBuffer value, int length) {
        return this.beginString(value, 0, length);
    }

    public HeaderEncoder beginString(DirectBuffer value) {
        return this.beginString(value, 0, value.capacity());
    }

    public HeaderEncoder beginString(byte[] value, int offset, int length) {
        this.beginString.wrap(value);
        this.beginStringOffset = offset;
        this.beginStringLength = length;
        return this;
    }

    public HeaderEncoder beginString(byte[] value, int length) {
        return this.beginString(value, 0, length);
    }

    public HeaderEncoder beginString(byte[] value) {
        return this.beginString(value, 0, value.length);
    }

    public boolean hasBeginString() {
        return this.beginStringLength > 0;
    }

    public MutableDirectBuffer beginString() {
        return this.beginString;
    }

    public String beginStringAsString() {
        return this.beginString.getStringWithoutLengthAscii(this.beginStringOffset, this.beginStringLength);
    }

    public HeaderEncoder beginString(CharSequence value) {
        CodecUtil.toBytes((CharSequence)value, (MutableDirectBuffer)this.beginString);
        this.beginStringOffset = 0;
        this.beginStringLength = value.length();
        return this;
    }

    public HeaderEncoder beginString(AsciiSequenceView value) {
        DirectBuffer buffer = value.buffer();
        if (buffer != null) {
            this.beginString.wrap(buffer);
            this.beginStringOffset = value.offset();
            this.beginStringLength = value.length();
        }
        return this;
    }

    public HeaderEncoder beginString(char[] value) {
        return this.beginString(value, 0, value.length);
    }

    public HeaderEncoder beginString(char[] value, int length) {
        return this.beginString(value, 0, length);
    }

    public HeaderEncoder beginString(char[] value, int offset, int length) {
        CodecUtil.toBytes((char[])value, (MutableDirectBuffer)this.beginString, (int)offset, (int)length);
        this.beginStringOffset = 0;
        this.beginStringLength = length;
        return this;
    }

    public HeaderEncoder msgType(DirectBuffer value, int offset, int length) {
        this.msgType.wrap(value);
        this.msgTypeOffset = offset;
        this.msgTypeLength = length;
        return this;
    }

    public HeaderEncoder msgType(DirectBuffer value, int length) {
        return this.msgType(value, 0, length);
    }

    public HeaderEncoder msgType(DirectBuffer value) {
        return this.msgType(value, 0, value.capacity());
    }

    public HeaderEncoder msgType(byte[] value, int offset, int length) {
        this.msgType.wrap(value);
        this.msgTypeOffset = offset;
        this.msgTypeLength = length;
        return this;
    }

    public HeaderEncoder msgType(byte[] value, int length) {
        return this.msgType(value, 0, length);
    }

    public HeaderEncoder msgType(byte[] value) {
        return this.msgType(value, 0, value.length);
    }

    public boolean hasMsgType() {
        return this.msgTypeLength > 0;
    }

    public MutableDirectBuffer msgType() {
        return this.msgType;
    }

    public String msgTypeAsString() {
        return this.msgType.getStringWithoutLengthAscii(this.msgTypeOffset, this.msgTypeLength);
    }

    public HeaderEncoder msgType(CharSequence value) {
        CodecUtil.toBytes((CharSequence)value, (MutableDirectBuffer)this.msgType);
        this.msgTypeOffset = 0;
        this.msgTypeLength = value.length();
        return this;
    }

    public HeaderEncoder msgType(AsciiSequenceView value) {
        DirectBuffer buffer = value.buffer();
        if (buffer != null) {
            this.msgType.wrap(buffer);
            this.msgTypeOffset = value.offset();
            this.msgTypeLength = value.length();
        }
        return this;
    }

    public HeaderEncoder msgType(char[] value) {
        return this.msgType(value, 0, value.length);
    }

    public HeaderEncoder msgType(char[] value, int length) {
        return this.msgType(value, 0, length);
    }

    public HeaderEncoder msgType(char[] value, int offset, int length) {
        CodecUtil.toBytes((char[])value, (MutableDirectBuffer)this.msgType, (int)offset, (int)length);
        this.msgTypeOffset = 0;
        this.msgTypeLength = length;
        return this;
    }

    public HeaderEncoder msgType(MsgType value) {
        return this.msgType(value.representation());
    }

    public HeaderEncoder senderCompID(DirectBuffer value, int offset, int length) {
        this.senderCompID.wrap(value);
        this.senderCompIDOffset = offset;
        this.senderCompIDLength = length;
        return this;
    }

    public HeaderEncoder senderCompID(DirectBuffer value, int length) {
        return this.senderCompID(value, 0, length);
    }

    public HeaderEncoder senderCompID(DirectBuffer value) {
        return this.senderCompID(value, 0, value.capacity());
    }

    public HeaderEncoder senderCompID(byte[] value, int offset, int length) {
        this.senderCompID.wrap(value);
        this.senderCompIDOffset = offset;
        this.senderCompIDLength = length;
        return this;
    }

    public HeaderEncoder senderCompID(byte[] value, int length) {
        return this.senderCompID(value, 0, length);
    }

    public HeaderEncoder senderCompID(byte[] value) {
        return this.senderCompID(value, 0, value.length);
    }

    public boolean hasSenderCompID() {
        return this.senderCompIDLength > 0;
    }

    public MutableDirectBuffer senderCompID() {
        return this.senderCompID;
    }

    public String senderCompIDAsString() {
        return this.senderCompID.getStringWithoutLengthAscii(this.senderCompIDOffset, this.senderCompIDLength);
    }

    public HeaderEncoder senderCompID(CharSequence value) {
        CodecUtil.toBytes((CharSequence)value, (MutableDirectBuffer)this.senderCompID);
        this.senderCompIDOffset = 0;
        this.senderCompIDLength = value.length();
        return this;
    }

    public HeaderEncoder senderCompID(AsciiSequenceView value) {
        DirectBuffer buffer = value.buffer();
        if (buffer != null) {
            this.senderCompID.wrap(buffer);
            this.senderCompIDOffset = value.offset();
            this.senderCompIDLength = value.length();
        }
        return this;
    }

    public HeaderEncoder senderCompID(char[] value) {
        return this.senderCompID(value, 0, value.length);
    }

    public HeaderEncoder senderCompID(char[] value, int length) {
        return this.senderCompID(value, 0, length);
    }

    public HeaderEncoder senderCompID(char[] value, int offset, int length) {
        CodecUtil.toBytes((char[])value, (MutableDirectBuffer)this.senderCompID, (int)offset, (int)length);
        this.senderCompIDOffset = 0;
        this.senderCompIDLength = length;
        return this;
    }

    public HeaderEncoder targetCompID(DirectBuffer value, int offset, int length) {
        this.targetCompID.wrap(value);
        this.targetCompIDOffset = offset;
        this.targetCompIDLength = length;
        return this;
    }

    public HeaderEncoder targetCompID(DirectBuffer value, int length) {
        return this.targetCompID(value, 0, length);
    }

    public HeaderEncoder targetCompID(DirectBuffer value) {
        return this.targetCompID(value, 0, value.capacity());
    }

    public HeaderEncoder targetCompID(byte[] value, int offset, int length) {
        this.targetCompID.wrap(value);
        this.targetCompIDOffset = offset;
        this.targetCompIDLength = length;
        return this;
    }

    public HeaderEncoder targetCompID(byte[] value, int length) {
        return this.targetCompID(value, 0, length);
    }

    public HeaderEncoder targetCompID(byte[] value) {
        return this.targetCompID(value, 0, value.length);
    }

    public boolean hasTargetCompID() {
        return this.targetCompIDLength > 0;
    }

    public MutableDirectBuffer targetCompID() {
        return this.targetCompID;
    }

    public String targetCompIDAsString() {
        return this.targetCompID.getStringWithoutLengthAscii(this.targetCompIDOffset, this.targetCompIDLength);
    }

    public HeaderEncoder targetCompID(CharSequence value) {
        CodecUtil.toBytes((CharSequence)value, (MutableDirectBuffer)this.targetCompID);
        this.targetCompIDOffset = 0;
        this.targetCompIDLength = value.length();
        return this;
    }

    public HeaderEncoder targetCompID(AsciiSequenceView value) {
        DirectBuffer buffer = value.buffer();
        if (buffer != null) {
            this.targetCompID.wrap(buffer);
            this.targetCompIDOffset = value.offset();
            this.targetCompIDLength = value.length();
        }
        return this;
    }

    public HeaderEncoder targetCompID(char[] value) {
        return this.targetCompID(value, 0, value.length);
    }

    public HeaderEncoder targetCompID(char[] value, int length) {
        return this.targetCompID(value, 0, length);
    }

    public HeaderEncoder targetCompID(char[] value, int offset, int length) {
        CodecUtil.toBytes((char[])value, (MutableDirectBuffer)this.targetCompID, (int)offset, (int)length);
        this.targetCompIDOffset = 0;
        this.targetCompIDLength = length;
        return this;
    }

    public boolean hasMsgSeqNum() {
        return this.hasMsgSeqNum;
    }

    public HeaderEncoder msgSeqNum(int value) {
        this.msgSeqNum = value;
        this.hasMsgSeqNum = true;
        return this;
    }

    public int msgSeqNum() {
        return this.msgSeqNum;
    }

    public HeaderEncoder senderSubID(DirectBuffer value, int offset, int length) {
        this.senderSubID.wrap(value);
        this.senderSubIDOffset = offset;
        this.senderSubIDLength = length;
        return this;
    }

    public HeaderEncoder senderSubID(DirectBuffer value, int length) {
        return this.senderSubID(value, 0, length);
    }

    public HeaderEncoder senderSubID(DirectBuffer value) {
        return this.senderSubID(value, 0, value.capacity());
    }

    public HeaderEncoder senderSubID(byte[] value, int offset, int length) {
        this.senderSubID.wrap(value);
        this.senderSubIDOffset = offset;
        this.senderSubIDLength = length;
        return this;
    }

    public HeaderEncoder senderSubID(byte[] value, int length) {
        return this.senderSubID(value, 0, length);
    }

    public HeaderEncoder senderSubID(byte[] value) {
        return this.senderSubID(value, 0, value.length);
    }

    public boolean hasSenderSubID() {
        return this.senderSubIDLength > 0;
    }

    public MutableDirectBuffer senderSubID() {
        return this.senderSubID;
    }

    public String senderSubIDAsString() {
        return this.senderSubID.getStringWithoutLengthAscii(this.senderSubIDOffset, this.senderSubIDLength);
    }

    public HeaderEncoder senderSubID(CharSequence value) {
        CodecUtil.toBytes((CharSequence)value, (MutableDirectBuffer)this.senderSubID);
        this.senderSubIDOffset = 0;
        this.senderSubIDLength = value.length();
        return this;
    }

    public HeaderEncoder senderSubID(AsciiSequenceView value) {
        DirectBuffer buffer = value.buffer();
        if (buffer != null) {
            this.senderSubID.wrap(buffer);
            this.senderSubIDOffset = value.offset();
            this.senderSubIDLength = value.length();
        }
        return this;
    }

    public HeaderEncoder senderSubID(char[] value) {
        return this.senderSubID(value, 0, value.length);
    }

    public HeaderEncoder senderSubID(char[] value, int length) {
        return this.senderSubID(value, 0, length);
    }

    public HeaderEncoder senderSubID(char[] value, int offset, int length) {
        CodecUtil.toBytes((char[])value, (MutableDirectBuffer)this.senderSubID, (int)offset, (int)length);
        this.senderSubIDOffset = 0;
        this.senderSubIDLength = length;
        return this;
    }

    public HeaderEncoder senderLocationID(DirectBuffer value, int offset, int length) {
        this.senderLocationID.wrap(value);
        this.senderLocationIDOffset = offset;
        this.senderLocationIDLength = length;
        return this;
    }

    public HeaderEncoder senderLocationID(DirectBuffer value, int length) {
        return this.senderLocationID(value, 0, length);
    }

    public HeaderEncoder senderLocationID(DirectBuffer value) {
        return this.senderLocationID(value, 0, value.capacity());
    }

    public HeaderEncoder senderLocationID(byte[] value, int offset, int length) {
        this.senderLocationID.wrap(value);
        this.senderLocationIDOffset = offset;
        this.senderLocationIDLength = length;
        return this;
    }

    public HeaderEncoder senderLocationID(byte[] value, int length) {
        return this.senderLocationID(value, 0, length);
    }

    public HeaderEncoder senderLocationID(byte[] value) {
        return this.senderLocationID(value, 0, value.length);
    }

    public boolean hasSenderLocationID() {
        return this.senderLocationIDLength > 0;
    }

    public MutableDirectBuffer senderLocationID() {
        return this.senderLocationID;
    }

    public String senderLocationIDAsString() {
        return this.senderLocationID.getStringWithoutLengthAscii(this.senderLocationIDOffset, this.senderLocationIDLength);
    }

    public HeaderEncoder senderLocationID(CharSequence value) {
        CodecUtil.toBytes((CharSequence)value, (MutableDirectBuffer)this.senderLocationID);
        this.senderLocationIDOffset = 0;
        this.senderLocationIDLength = value.length();
        return this;
    }

    public HeaderEncoder senderLocationID(AsciiSequenceView value) {
        DirectBuffer buffer = value.buffer();
        if (buffer != null) {
            this.senderLocationID.wrap(buffer);
            this.senderLocationIDOffset = value.offset();
            this.senderLocationIDLength = value.length();
        }
        return this;
    }

    public HeaderEncoder senderLocationID(char[] value) {
        return this.senderLocationID(value, 0, value.length);
    }

    public HeaderEncoder senderLocationID(char[] value, int length) {
        return this.senderLocationID(value, 0, length);
    }

    public HeaderEncoder senderLocationID(char[] value, int offset, int length) {
        CodecUtil.toBytes((char[])value, (MutableDirectBuffer)this.senderLocationID, (int)offset, (int)length);
        this.senderLocationIDOffset = 0;
        this.senderLocationIDLength = length;
        return this;
    }

    public HeaderEncoder targetSubID(DirectBuffer value, int offset, int length) {
        this.targetSubID.wrap(value);
        this.targetSubIDOffset = offset;
        this.targetSubIDLength = length;
        return this;
    }

    public HeaderEncoder targetSubID(DirectBuffer value, int length) {
        return this.targetSubID(value, 0, length);
    }

    public HeaderEncoder targetSubID(DirectBuffer value) {
        return this.targetSubID(value, 0, value.capacity());
    }

    public HeaderEncoder targetSubID(byte[] value, int offset, int length) {
        this.targetSubID.wrap(value);
        this.targetSubIDOffset = offset;
        this.targetSubIDLength = length;
        return this;
    }

    public HeaderEncoder targetSubID(byte[] value, int length) {
        return this.targetSubID(value, 0, length);
    }

    public HeaderEncoder targetSubID(byte[] value) {
        return this.targetSubID(value, 0, value.length);
    }

    public boolean hasTargetSubID() {
        return this.targetSubIDLength > 0;
    }

    public MutableDirectBuffer targetSubID() {
        return this.targetSubID;
    }

    public String targetSubIDAsString() {
        return this.targetSubID.getStringWithoutLengthAscii(this.targetSubIDOffset, this.targetSubIDLength);
    }

    public HeaderEncoder targetSubID(CharSequence value) {
        CodecUtil.toBytes((CharSequence)value, (MutableDirectBuffer)this.targetSubID);
        this.targetSubIDOffset = 0;
        this.targetSubIDLength = value.length();
        return this;
    }

    public HeaderEncoder targetSubID(AsciiSequenceView value) {
        DirectBuffer buffer = value.buffer();
        if (buffer != null) {
            this.targetSubID.wrap(buffer);
            this.targetSubIDOffset = value.offset();
            this.targetSubIDLength = value.length();
        }
        return this;
    }

    public HeaderEncoder targetSubID(char[] value) {
        return this.targetSubID(value, 0, value.length);
    }

    public HeaderEncoder targetSubID(char[] value, int length) {
        return this.targetSubID(value, 0, length);
    }

    public HeaderEncoder targetSubID(char[] value, int offset, int length) {
        CodecUtil.toBytes((char[])value, (MutableDirectBuffer)this.targetSubID, (int)offset, (int)length);
        this.targetSubIDOffset = 0;
        this.targetSubIDLength = length;
        return this;
    }

    public HeaderEncoder targetLocationID(DirectBuffer value, int offset, int length) {
        this.targetLocationID.wrap(value);
        this.targetLocationIDOffset = offset;
        this.targetLocationIDLength = length;
        return this;
    }

    public HeaderEncoder targetLocationID(DirectBuffer value, int length) {
        return this.targetLocationID(value, 0, length);
    }

    public HeaderEncoder targetLocationID(DirectBuffer value) {
        return this.targetLocationID(value, 0, value.capacity());
    }

    public HeaderEncoder targetLocationID(byte[] value, int offset, int length) {
        this.targetLocationID.wrap(value);
        this.targetLocationIDOffset = offset;
        this.targetLocationIDLength = length;
        return this;
    }

    public HeaderEncoder targetLocationID(byte[] value, int length) {
        return this.targetLocationID(value, 0, length);
    }

    public HeaderEncoder targetLocationID(byte[] value) {
        return this.targetLocationID(value, 0, value.length);
    }

    public boolean hasTargetLocationID() {
        return this.targetLocationIDLength > 0;
    }

    public MutableDirectBuffer targetLocationID() {
        return this.targetLocationID;
    }

    public String targetLocationIDAsString() {
        return this.targetLocationID.getStringWithoutLengthAscii(this.targetLocationIDOffset, this.targetLocationIDLength);
    }

    public HeaderEncoder targetLocationID(CharSequence value) {
        CodecUtil.toBytes((CharSequence)value, (MutableDirectBuffer)this.targetLocationID);
        this.targetLocationIDOffset = 0;
        this.targetLocationIDLength = value.length();
        return this;
    }

    public HeaderEncoder targetLocationID(AsciiSequenceView value) {
        DirectBuffer buffer = value.buffer();
        if (buffer != null) {
            this.targetLocationID.wrap(buffer);
            this.targetLocationIDOffset = value.offset();
            this.targetLocationIDLength = value.length();
        }
        return this;
    }

    public HeaderEncoder targetLocationID(char[] value) {
        return this.targetLocationID(value, 0, value.length);
    }

    public HeaderEncoder targetLocationID(char[] value, int length) {
        return this.targetLocationID(value, 0, length);
    }

    public HeaderEncoder targetLocationID(char[] value, int offset, int length) {
        CodecUtil.toBytes((char[])value, (MutableDirectBuffer)this.targetLocationID, (int)offset, (int)length);
        this.targetLocationIDOffset = 0;
        this.targetLocationIDLength = length;
        return this;
    }

    public boolean hasPossDupFlag() {
        return this.hasPossDupFlag;
    }

    public HeaderEncoder possDupFlag(boolean value) {
        this.possDupFlag = value;
        this.hasPossDupFlag = true;
        return this;
    }

    public boolean possDupFlag() {
        return this.possDupFlag;
    }

    public boolean hasPossResend() {
        return this.hasPossResend;
    }

    public HeaderEncoder possResend(boolean value) {
        this.possResend = value;
        this.hasPossResend = true;
        return this;
    }

    public boolean possResend() {
        return this.possResend;
    }

    public HeaderEncoder sendingTime(DirectBuffer value, int offset, int length) {
        this.sendingTime.wrap(value);
        this.sendingTimeOffset = offset;
        this.sendingTimeLength = length;
        return this;
    }

    public HeaderEncoder sendingTime(DirectBuffer value, int length) {
        return this.sendingTime(value, 0, length);
    }

    public HeaderEncoder sendingTime(DirectBuffer value) {
        return this.sendingTime(value, 0, value.capacity());
    }

    public HeaderEncoder sendingTime(byte[] value, int offset, int length) {
        this.sendingTime.wrap(value);
        this.sendingTimeOffset = offset;
        this.sendingTimeLength = length;
        return this;
    }

    public HeaderEncoder sendingTime(byte[] value, int length) {
        return this.sendingTime(value, 0, length);
    }

    public HeaderEncoder sendingTime(byte[] value) {
        return this.sendingTime(value, 0, value.length);
    }

    public boolean hasSendingTime() {
        return this.sendingTimeLength > 0;
    }

    public MutableDirectBuffer sendingTime() {
        return this.sendingTime;
    }

    public String sendingTimeAsString() {
        return this.sendingTime.getStringWithoutLengthAscii(this.sendingTimeOffset, this.sendingTimeLength);
    }

    public HeaderEncoder origSendingTime(DirectBuffer value, int offset, int length) {
        this.origSendingTime.wrap(value);
        this.origSendingTimeOffset = offset;
        this.origSendingTimeLength = length;
        return this;
    }

    public HeaderEncoder origSendingTime(DirectBuffer value, int length) {
        return this.origSendingTime(value, 0, length);
    }

    public HeaderEncoder origSendingTime(DirectBuffer value) {
        return this.origSendingTime(value, 0, value.capacity());
    }

    public HeaderEncoder origSendingTime(byte[] value, int offset, int length) {
        this.origSendingTime.wrap(value);
        this.origSendingTimeOffset = offset;
        this.origSendingTimeLength = length;
        return this;
    }

    public HeaderEncoder origSendingTime(byte[] value, int length) {
        return this.origSendingTime(value, 0, length);
    }

    public HeaderEncoder origSendingTime(byte[] value) {
        return this.origSendingTime(value, 0, value.length);
    }

    public boolean hasOrigSendingTime() {
        return this.origSendingTimeLength > 0;
    }

    public MutableDirectBuffer origSendingTime() {
        return this.origSendingTime;
    }

    public String origSendingTimeAsString() {
        return this.origSendingTime.getStringWithoutLengthAscii(this.origSendingTimeOffset, this.origSendingTimeLength);
    }

    public boolean hasLastMsgSeqNumProcessed() {
        return this.hasLastMsgSeqNumProcessed;
    }

    public HeaderEncoder lastMsgSeqNumProcessed(int value) {
        this.lastMsgSeqNumProcessed = value;
        this.hasLastMsgSeqNumProcessed = true;
        return this;
    }

    public int lastMsgSeqNumProcessed() {
        return this.lastMsgSeqNumProcessed;
    }

    int finishHeader(MutableAsciiBuffer buffer, int bodyStart, int bodyLength) {
        int position = bodyStart - 1;
        buffer.putSeparator(position);
        position = buffer.putNaturalIntAsciiFromEnd(bodyLength, position);
        buffer.putBytes(position -= 2, bodyLengthHeader, 0, 2);
        if (this.beginStringLength > 0) {
            buffer.putSeparator(--position);
            buffer.putBytes(position -= this.beginStringLength, (DirectBuffer)this.beginString, this.beginStringOffset, this.beginStringLength);
            buffer.putBytes(position -= 2, beginStringHeader, 0, 2);
        } else if (Validation.CODEC_VALIDATION_ENABLED) {
            throw new EncodingException("Missing Field: BeginString");
        }
        return position;
    }

    public long startMessage(MutableAsciiBuffer buffer, int offset) {
        int start;
        int position = start = offset + this.beginStringLength + 16;
        if (this.msgTypeLength > 0) {
            buffer.putBytes(position, msgTypeHeader, 0, 3);
            buffer.putBytes(position += 3, (DirectBuffer)this.msgType, this.msgTypeOffset, this.msgTypeLength);
            buffer.putSeparator(position += this.msgTypeLength);
            ++position;
        } else if (Validation.CODEC_VALIDATION_ENABLED) {
            throw new EncodingException("Missing Field: MsgType");
        }
        if (this.senderCompIDLength > 0) {
            buffer.putBytes(position, senderCompIDHeader, 0, 3);
            buffer.putBytes(position += 3, (DirectBuffer)this.senderCompID, this.senderCompIDOffset, this.senderCompIDLength);
            buffer.putSeparator(position += this.senderCompIDLength);
            ++position;
        } else if (Validation.CODEC_VALIDATION_ENABLED) {
            throw new EncodingException("Missing Field: SenderCompID");
        }
        if (this.targetCompIDLength > 0) {
            buffer.putBytes(position, targetCompIDHeader, 0, 3);
            buffer.putBytes(position += 3, (DirectBuffer)this.targetCompID, this.targetCompIDOffset, this.targetCompIDLength);
            buffer.putSeparator(position += this.targetCompIDLength);
            ++position;
        } else if (Validation.CODEC_VALIDATION_ENABLED) {
            throw new EncodingException("Missing Field: TargetCompID");
        }
        if (this.hasMsgSeqNum) {
            buffer.putBytes(position, msgSeqNumHeader, 0, 3);
            position += 3;
            position += buffer.putIntAscii(position, this.msgSeqNum);
            buffer.putSeparator(position);
            ++position;
        }
        if (this.senderSubIDLength > 0) {
            buffer.putBytes(position, senderSubIDHeader, 0, 3);
            buffer.putBytes(position += 3, (DirectBuffer)this.senderSubID, this.senderSubIDOffset, this.senderSubIDLength);
            buffer.putSeparator(position += this.senderSubIDLength);
            ++position;
        }
        if (this.senderLocationIDLength > 0) {
            buffer.putBytes(position, senderLocationIDHeader, 0, 4);
            buffer.putBytes(position += 4, (DirectBuffer)this.senderLocationID, this.senderLocationIDOffset, this.senderLocationIDLength);
            buffer.putSeparator(position += this.senderLocationIDLength);
            ++position;
        }
        if (this.targetSubIDLength > 0) {
            buffer.putBytes(position, targetSubIDHeader, 0, 3);
            buffer.putBytes(position += 3, (DirectBuffer)this.targetSubID, this.targetSubIDOffset, this.targetSubIDLength);
            buffer.putSeparator(position += this.targetSubIDLength);
            ++position;
        }
        if (this.targetLocationIDLength > 0) {
            buffer.putBytes(position, targetLocationIDHeader, 0, 4);
            buffer.putBytes(position += 4, (DirectBuffer)this.targetLocationID, this.targetLocationIDOffset, this.targetLocationIDLength);
            buffer.putSeparator(position += this.targetLocationIDLength);
            ++position;
        }
        if (this.hasPossDupFlag) {
            buffer.putBytes(position, possDupFlagHeader, 0, 3);
            position += 3;
            position += buffer.putBooleanAscii(position, this.possDupFlag);
            buffer.putSeparator(position);
            ++position;
        }
        if (this.hasPossResend) {
            buffer.putBytes(position, possResendHeader, 0, 3);
            position += 3;
            position += buffer.putBooleanAscii(position, this.possResend);
            buffer.putSeparator(position);
            ++position;
        }
        if (this.sendingTimeLength > 0) {
            buffer.putBytes(position, sendingTimeHeader, 0, 3);
            buffer.putBytes(position += 3, (DirectBuffer)this.sendingTime, this.sendingTimeOffset, this.sendingTimeLength);
            buffer.putSeparator(position += this.sendingTimeLength);
            ++position;
        } else if (Validation.CODEC_VALIDATION_ENABLED) {
            throw new EncodingException("Missing Field: SendingTime");
        }
        if (this.origSendingTimeLength > 0) {
            buffer.putBytes(position, origSendingTimeHeader, 0, 4);
            buffer.putBytes(position += 4, (DirectBuffer)this.origSendingTime, this.origSendingTimeOffset, this.origSendingTimeLength);
            buffer.putSeparator(position += this.origSendingTimeLength);
            ++position;
        }
        if (this.hasLastMsgSeqNumProcessed) {
            buffer.putBytes(position, lastMsgSeqNumProcessedHeader, 0, 4);
            position += 4;
            position += buffer.putIntAscii(position, this.lastMsgSeqNumProcessed);
            buffer.putSeparator(position);
            ++position;
        }
        return Encoder.result((int)(position - start), (int)start);
    }

    public void reset() {
        this.resetSenderCompID();
        this.resetTargetCompID();
        this.resetMsgSeqNum();
        this.resetSenderSubID();
        this.resetSenderLocationID();
        this.resetTargetSubID();
        this.resetTargetLocationID();
        this.resetPossDupFlag();
        this.resetPossResend();
        this.resetSendingTime();
        this.resetOrigSendingTime();
        this.resetLastMsgSeqNumProcessed();
        this.beginString(DEFAULT_BEGIN_STRING);
    }

    public void resetSenderCompID() {
        this.senderCompIDLength = 0;
    }

    public void resetTargetCompID() {
        this.targetCompIDLength = 0;
    }

    public void resetMsgSeqNum() {
        this.hasMsgSeqNum = false;
    }

    public void resetSenderSubID() {
        this.senderSubIDLength = 0;
    }

    public void resetSenderLocationID() {
        this.senderLocationIDLength = 0;
    }

    public void resetTargetSubID() {
        this.targetSubIDLength = 0;
    }

    public void resetTargetLocationID() {
        this.targetLocationIDLength = 0;
    }

    public void resetPossDupFlag() {
        this.hasPossDupFlag = false;
    }

    public void resetPossResend() {
        this.hasPossResend = false;
    }

    public void resetSendingTime() {
        this.sendingTimeLength = 0;
    }

    public void resetOrigSendingTime() {
        this.origSendingTimeLength = 0;
    }

    public void resetLastMsgSeqNumProcessed() {
        this.hasLastMsgSeqNumProcessed = false;
    }

    public String toString() {
        String entries = (this.hasBeginString() ? String.format("  \"BeginString\": \"%s\",\n", this.beginString.getStringWithoutLengthAscii(this.beginStringOffset, this.beginStringLength)) : "") + "" + (this.hasMsgType() ? String.format("  \"MsgType\": \"%s\",\n", this.msgType.getStringWithoutLengthAscii(this.msgTypeOffset, this.msgTypeLength)) : "") + (this.hasSenderCompID() ? String.format("  \"SenderCompID\": \"%s\",\n", this.senderCompID.getStringWithoutLengthAscii(this.senderCompIDOffset, this.senderCompIDLength)) : "") + (this.hasTargetCompID() ? String.format("  \"TargetCompID\": \"%s\",\n", this.targetCompID.getStringWithoutLengthAscii(this.targetCompIDOffset, this.targetCompIDLength)) : "") + (this.hasMsgSeqNum() ? String.format("  \"MsgSeqNum\": \"%s\",\n", this.msgSeqNum) : "") + (this.hasSenderSubID() ? String.format("  \"SenderSubID\": \"%s\",\n", this.senderSubID.getStringWithoutLengthAscii(this.senderSubIDOffset, this.senderSubIDLength)) : "") + (this.hasSenderLocationID() ? String.format("  \"SenderLocationID\": \"%s\",\n", this.senderLocationID.getStringWithoutLengthAscii(this.senderLocationIDOffset, this.senderLocationIDLength)) : "") + (this.hasTargetSubID() ? String.format("  \"TargetSubID\": \"%s\",\n", this.targetSubID.getStringWithoutLengthAscii(this.targetSubIDOffset, this.targetSubIDLength)) : "") + (this.hasTargetLocationID() ? String.format("  \"TargetLocationID\": \"%s\",\n", this.targetLocationID.getStringWithoutLengthAscii(this.targetLocationIDOffset, this.targetLocationIDLength)) : "") + (this.hasPossDupFlag() ? String.format("  \"PossDupFlag\": \"%s\",\n", this.possDupFlag) : "") + (this.hasPossResend() ? String.format("  \"PossResend\": \"%s\",\n", this.possResend) : "") + (this.hasSendingTime() ? String.format("  \"SendingTime\": \"%s\",\n", this.sendingTime.getStringWithoutLengthAscii(this.sendingTimeOffset, this.sendingTimeLength)) : "") + (this.hasOrigSendingTime() ? String.format("  \"OrigSendingTime\": \"%s\",\n", this.origSendingTime.getStringWithoutLengthAscii(this.origSendingTimeOffset, this.origSendingTimeLength)) : "") + (this.hasLastMsgSeqNumProcessed() ? String.format("  \"LastMsgSeqNumProcessed\": \"%s\",\n", this.lastMsgSeqNumProcessed) : "");
        entries = "{\n  \"MessageName\": \"Header\",\n" + entries + "}";
        return entries;
    }
}

