/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.decoder_flyweight;

import java.nio.charset.StandardCharsets;
import org.agrona.AsciiSequenceView;
import org.agrona.DirectBuffer;
import org.agrona.collections.IntHashSet;
import uk.co.real_logic.artio.CancelOnDisconnectType;
import uk.co.real_logic.artio.Constants;
import uk.co.real_logic.artio.EncryptMethod;
import uk.co.real_logic.artio.builder.CommonDecoderImpl;
import uk.co.real_logic.artio.builder.Encoder;
import uk.co.real_logic.artio.builder.LogonEncoder;
import uk.co.real_logic.artio.builder.RejectUnknownEnumValue;
import uk.co.real_logic.artio.builder.RejectUnknownField;
import uk.co.real_logic.artio.builder.Validation;
import uk.co.real_logic.artio.decoder.AbstractLogonDecoder;
import uk.co.real_logic.artio.decoder_flyweight.HeaderDecoder;
import uk.co.real_logic.artio.decoder_flyweight.MessageDecoder;
import uk.co.real_logic.artio.decoder_flyweight.TrailerDecoder;
import uk.co.real_logic.artio.dictionary.CharArrayWrapper;
import uk.co.real_logic.artio.dictionary.Generated;
import uk.co.real_logic.artio.dictionary.generation.CodecUtil;
import uk.co.real_logic.artio.util.AsciiBuffer;

@Generated(value={"uk.co.real_logic.artio"})
public class LogonDecoder
extends CommonDecoderImpl
implements MessageDecoder,
AbstractLogonDecoder {
    public final IntHashSet REQUIRED_FIELDS = new IntHashSet(4);
    private final IntHashSet alreadyVisitedFields;
    private final IntHashSet unknownFields;
    private final IntHashSet missingRequiredFields;
    public static final long MESSAGE_TYPE = 65L;
    public static final String MESSAGE_TYPE_AS_STRING = "A";
    public static final char[] MESSAGE_TYPE_CHARS = "A".toCharArray();
    public static final byte[] MESSAGE_TYPE_BYTES = "A".getBytes(StandardCharsets.US_ASCII);
    public final IntHashSet messageFields;
    private final TrailerDecoder trailer;
    private final HeaderDecoder header;
    private int encryptMethod;
    private int encryptMethodOffset;
    private int encryptMethodLength;
    private final CharArrayWrapper encryptMethodWrapper;
    private int heartBtInt;
    private int heartBtIntOffset;
    private int heartBtIntLength;
    private int rawDataLength;
    private boolean hasRawDataLength;
    private int rawDataLengthOffset;
    private int rawDataLengthLength;
    private byte[] rawData;
    private boolean hasRawData;
    private int rawDataOffset;
    private boolean resetSeqNumFlag;
    private int resetSeqNumFlagLength;
    private boolean hasResetSeqNumFlag;
    private int nextExpectedMsgSeqNum;
    private boolean hasNextExpectedMsgSeqNum;
    private int nextExpectedMsgSeqNumOffset;
    private int nextExpectedMsgSeqNumLength;
    private int maxMessageSize;
    private boolean hasMaxMessageSize;
    private int maxMessageSizeOffset;
    private int maxMessageSizeLength;
    private boolean testMessageIndicator;
    private int testMessageIndicatorLength;
    private boolean hasTestMessageIndicator;
    private char[] username;
    private boolean hasUsername;
    private int usernameOffset;
    private int usernameLength;
    private final CharArrayWrapper usernameWrapper;
    private char[] password;
    private boolean hasPassword;
    private int passwordOffset;
    private int passwordLength;
    private final CharArrayWrapper passwordWrapper;
    private int cancelOnDisconnectType;
    private boolean hasCancelOnDisconnectType;
    private int cancelOnDisconnectTypeOffset;
    private int cancelOnDisconnectTypeLength;
    private final CharArrayWrapper cancelOnDisconnectTypeWrapper;
    private int cODTimeoutWindow;
    private boolean hasCODTimeoutWindow;
    private int cODTimeoutWindowOffset;
    private int cODTimeoutWindowLength;

    public LogonDecoder() {
        if (Validation.CODEC_VALIDATION_ENABLED) {
            this.REQUIRED_FIELDS.add(98);
            this.REQUIRED_FIELDS.add(108);
        }
        this.alreadyVisitedFields = new IntHashSet(24);
        this.unknownFields = new IntHashSet(10);
        this.missingRequiredFields = new IntHashSet(4);
        this.messageFields = new IntHashSet(56);
        this.messageFields.add(8);
        this.messageFields.add(9);
        this.messageFields.add(35);
        this.messageFields.add(49);
        this.messageFields.add(56);
        this.messageFields.add(34);
        this.messageFields.add(50);
        this.messageFields.add(142);
        this.messageFields.add(57);
        this.messageFields.add(143);
        this.messageFields.add(43);
        this.messageFields.add(97);
        this.messageFields.add(52);
        this.messageFields.add(122);
        this.messageFields.add(369);
        this.messageFields.add(98);
        this.messageFields.add(108);
        this.messageFields.add(95);
        this.messageFields.add(96);
        this.messageFields.add(141);
        this.messageFields.add(789);
        this.messageFields.add(383);
        this.messageFields.add(464);
        this.messageFields.add(553);
        this.messageFields.add(554);
        this.messageFields.add(35002);
        this.messageFields.add(35003);
        this.messageFields.add(10);
        this.trailer = new TrailerDecoder();
        this.header = new HeaderDecoder(this.trailer);
        this.encryptMethod = Integer.MIN_VALUE;
        this.encryptMethodWrapper = new CharArrayWrapper();
        this.heartBtInt = Integer.MIN_VALUE;
        this.rawDataLength = Integer.MIN_VALUE;
        this.rawData = new byte[1];
        this.resetSeqNumFlagLength = 0;
        this.nextExpectedMsgSeqNum = Integer.MIN_VALUE;
        this.maxMessageSize = Integer.MIN_VALUE;
        this.testMessageIndicatorLength = 0;
        this.username = new char[1];
        this.usernameWrapper = new CharArrayWrapper();
        this.password = new char[1];
        this.passwordWrapper = new CharArrayWrapper();
        this.cancelOnDisconnectType = Integer.MIN_VALUE;
        this.cancelOnDisconnectTypeWrapper = new CharArrayWrapper();
        this.cODTimeoutWindow = Integer.MIN_VALUE;
    }

    public boolean validate() {
        if (this.rejectReason != -1) {
            return false;
        }
        IntHashSet.IntIterator missingFieldsIterator = this.missingRequiredFields.iterator();
        IntHashSet.IntIterator unknownFieldsIterator = this.unknownFields.iterator();
        if (RejectUnknownField.CODEC_REJECT_UNKNOWN_FIELD_ENABLED && unknownFieldsIterator.hasNext()) {
            this.invalidTagId = unknownFieldsIterator.nextValue();
            this.rejectReason = Constants.ALL_FIELDS.contains(this.invalidTagId) ? 2 : 0;
            return false;
        }
        if (!this.header.validate()) {
            this.invalidTagId = this.header.invalidTagId();
            this.rejectReason = this.header.rejectReason();
            return false;
        }
        if (!this.trailer.validate()) {
            this.invalidTagId = this.trailer.invalidTagId();
            this.rejectReason = this.trailer.rejectReason();
            return false;
        }
        if (missingFieldsIterator.hasNext()) {
            this.invalidTagId = missingFieldsIterator.nextValue();
            this.rejectReason = 1;
            return false;
        }
        if (RejectUnknownEnumValue.CODEC_REJECT_UNKNOWN_ENUM_VALUE_ENABLED && !EncryptMethod.isValid(this.encryptMethod())) {
            this.invalidTagId = 98;
            this.rejectReason = 5;
            return false;
        }
        if (this.hasCancelOnDisconnectType && RejectUnknownEnumValue.CODEC_REJECT_UNKNOWN_ENUM_VALUE_ENABLED && !CancelOnDisconnectType.isValid(this.cancelOnDisconnectType())) {
            this.invalidTagId = 35002;
            this.rejectReason = 5;
            return false;
        }
        if (this.hasResetSeqNumFlag && Validation.CODEC_VALIDATION_ENABLED && this.resetSeqNumFlagLength > 1) {
            this.invalidTagId = 141;
            this.rejectReason = 5;
            return false;
        }
        if (this.hasTestMessageIndicator && Validation.CODEC_VALIDATION_ENABLED && this.testMessageIndicatorLength > 1) {
            this.invalidTagId = 464;
            this.rejectReason = 5;
            return false;
        }
        return true;
    }

    @Override
    public TrailerDecoder trailer() {
        return this.trailer;
    }

    @Override
    public HeaderDecoder header() {
        return this.header;
    }

    public int encryptMethod() {
        if (this.buffer != null && this.encryptMethodLength > 0) {
            this.encryptMethod = this.getIntFlyweight(this.buffer, this.encryptMethodOffset, this.encryptMethodLength, 98, Validation.CODEC_VALIDATION_ENABLED);
        }
        return this.encryptMethod;
    }

    public int encryptMethodLength() {
        return this.encryptMethodLength;
    }

    public EncryptMethod encryptMethodAsEnum() {
        return EncryptMethod.decode(this.encryptMethod());
    }

    public int heartBtInt() {
        if (this.buffer != null && this.heartBtIntLength > 0) {
            this.heartBtInt = this.getIntFlyweight(this.buffer, this.heartBtIntOffset, this.heartBtIntLength, 108, Validation.CODEC_VALIDATION_ENABLED);
        }
        return this.heartBtInt;
    }

    public int heartBtIntLength() {
        return this.heartBtIntLength;
    }

    public int rawDataLength() {
        if (!this.hasRawDataLength) {
            throw new IllegalArgumentException("No value for optional field: RawDataLength");
        }
        if (this.buffer != null && this.rawDataLengthLength > 0) {
            this.rawDataLength = this.getIntFlyweight(this.buffer, this.rawDataLengthOffset, this.rawDataLengthLength, 95, Validation.CODEC_VALIDATION_ENABLED);
        }
        return this.rawDataLength;
    }

    public boolean hasRawDataLength() {
        return this.hasRawDataLength;
    }

    public int rawDataLengthLength() {
        if (!this.hasRawDataLength) {
            throw new IllegalArgumentException("No value for optional field: RawDataLength");
        }
        return this.rawDataLengthLength;
    }

    public byte[] rawData() {
        if (!this.hasRawData) {
            throw new IllegalArgumentException("No value for optional field: RawData");
        }
        if (this.buffer != null && this.rawDataLength > 0) {
            this.rawData = this.buffer.getBytes(this.rawData, this.rawDataOffset, this.rawDataLength);
        }
        return this.rawData;
    }

    public boolean hasRawData() {
        return this.hasRawData;
    }

    public int resetSeqNumFlagLength() {
        return this.resetSeqNumFlagLength;
    }

    public boolean resetSeqNumFlag() {
        if (!this.hasResetSeqNumFlag) {
            throw new IllegalArgumentException("No value for optional field: ResetSeqNumFlag");
        }
        return this.resetSeqNumFlag;
    }

    public boolean hasResetSeqNumFlag() {
        return this.hasResetSeqNumFlag;
    }

    public int nextExpectedMsgSeqNum() {
        if (!this.hasNextExpectedMsgSeqNum) {
            throw new IllegalArgumentException("No value for optional field: NextExpectedMsgSeqNum");
        }
        if (this.buffer != null && this.nextExpectedMsgSeqNumLength > 0) {
            this.nextExpectedMsgSeqNum = this.getIntFlyweight(this.buffer, this.nextExpectedMsgSeqNumOffset, this.nextExpectedMsgSeqNumLength, 789, Validation.CODEC_VALIDATION_ENABLED);
        }
        return this.nextExpectedMsgSeqNum;
    }

    public boolean hasNextExpectedMsgSeqNum() {
        return this.hasNextExpectedMsgSeqNum;
    }

    public int nextExpectedMsgSeqNumLength() {
        if (!this.hasNextExpectedMsgSeqNum) {
            throw new IllegalArgumentException("No value for optional field: NextExpectedMsgSeqNum");
        }
        return this.nextExpectedMsgSeqNumLength;
    }

    public int maxMessageSize() {
        if (!this.hasMaxMessageSize) {
            throw new IllegalArgumentException("No value for optional field: MaxMessageSize");
        }
        if (this.buffer != null && this.maxMessageSizeLength > 0) {
            this.maxMessageSize = this.getIntFlyweight(this.buffer, this.maxMessageSizeOffset, this.maxMessageSizeLength, 383, Validation.CODEC_VALIDATION_ENABLED);
        }
        return this.maxMessageSize;
    }

    public boolean hasMaxMessageSize() {
        return this.hasMaxMessageSize;
    }

    public int maxMessageSizeLength() {
        if (!this.hasMaxMessageSize) {
            throw new IllegalArgumentException("No value for optional field: MaxMessageSize");
        }
        return this.maxMessageSizeLength;
    }

    public int testMessageIndicatorLength() {
        return this.testMessageIndicatorLength;
    }

    public boolean testMessageIndicator() {
        if (!this.hasTestMessageIndicator) {
            throw new IllegalArgumentException("No value for optional field: TestMessageIndicator");
        }
        return this.testMessageIndicator;
    }

    public boolean hasTestMessageIndicator() {
        return this.hasTestMessageIndicator;
    }

    public char[] username() {
        if (!this.hasUsername) {
            throw new IllegalArgumentException("No value for optional field: Username");
        }
        if (this.buffer != null && this.usernameLength > 0) {
            this.username = this.buffer.getChars(this.username, this.usernameOffset, this.usernameLength);
        }
        return this.username;
    }

    public boolean hasUsername() {
        return this.hasUsername;
    }

    public int usernameLength() {
        if (!this.hasUsername) {
            throw new IllegalArgumentException("No value for optional field: Username");
        }
        return this.usernameLength;
    }

    public String usernameAsString() {
        return this.hasUsername ? this.buffer.getStringWithoutLengthAscii(this.usernameOffset, this.usernameLength) : null;
    }

    public AsciiSequenceView username(AsciiSequenceView view) {
        if (!this.hasUsername) {
            throw new IllegalArgumentException("No value for optional field: Username");
        }
        return view.wrap((DirectBuffer)this.buffer, this.usernameOffset, this.usernameLength);
    }

    public char[] password() {
        if (!this.hasPassword) {
            throw new IllegalArgumentException("No value for optional field: Password");
        }
        if (this.buffer != null && this.passwordLength > 0) {
            this.password = this.buffer.getChars(this.password, this.passwordOffset, this.passwordLength);
        }
        return this.password;
    }

    public boolean hasPassword() {
        return this.hasPassword;
    }

    public int passwordLength() {
        if (!this.hasPassword) {
            throw new IllegalArgumentException("No value for optional field: Password");
        }
        return this.passwordLength;
    }

    public String passwordAsString() {
        return this.hasPassword ? this.buffer.getStringWithoutLengthAscii(this.passwordOffset, this.passwordLength) : null;
    }

    public AsciiSequenceView password(AsciiSequenceView view) {
        if (!this.hasPassword) {
            throw new IllegalArgumentException("No value for optional field: Password");
        }
        return view.wrap((DirectBuffer)this.buffer, this.passwordOffset, this.passwordLength);
    }

    public int cancelOnDisconnectType() {
        if (!this.hasCancelOnDisconnectType) {
            throw new IllegalArgumentException("No value for optional field: CancelOnDisconnectType");
        }
        if (this.buffer != null && this.cancelOnDisconnectTypeLength > 0) {
            this.cancelOnDisconnectType = this.getIntFlyweight(this.buffer, this.cancelOnDisconnectTypeOffset, this.cancelOnDisconnectTypeLength, 35002, Validation.CODEC_VALIDATION_ENABLED);
        }
        return this.cancelOnDisconnectType;
    }

    public boolean hasCancelOnDisconnectType() {
        return this.hasCancelOnDisconnectType;
    }

    public int cancelOnDisconnectTypeLength() {
        if (!this.hasCancelOnDisconnectType) {
            throw new IllegalArgumentException("No value for optional field: CancelOnDisconnectType");
        }
        return this.cancelOnDisconnectTypeLength;
    }

    public CancelOnDisconnectType cancelOnDisconnectTypeAsEnum() {
        if (!this.hasCancelOnDisconnectType) {
            return CancelOnDisconnectType.NULL_VAL;
        }
        return CancelOnDisconnectType.decode(this.cancelOnDisconnectType());
    }

    public int cODTimeoutWindow() {
        if (!this.hasCODTimeoutWindow) {
            throw new IllegalArgumentException("No value for optional field: CODTimeoutWindow");
        }
        if (this.buffer != null && this.cODTimeoutWindowLength > 0) {
            this.cODTimeoutWindow = this.getIntFlyweight(this.buffer, this.cODTimeoutWindowOffset, this.cODTimeoutWindowLength, 35003, Validation.CODEC_VALIDATION_ENABLED);
        }
        return this.cODTimeoutWindow;
    }

    public boolean hasCODTimeoutWindow() {
        return this.hasCODTimeoutWindow;
    }

    public int cODTimeoutWindowLength() {
        if (!this.hasCODTimeoutWindow) {
            throw new IllegalArgumentException("No value for optional field: CODTimeoutWindow");
        }
        return this.cODTimeoutWindowLength;
    }

    public boolean supportsUsername() {
        return true;
    }

    public boolean supportsPassword() {
        return true;
    }

    public boolean supportsCancelOnDisconnectType() {
        return true;
    }

    public boolean supportsCODTimeoutWindow() {
        return true;
    }

    public int decode(AsciiBuffer buffer, int offset, int length) {
        int position;
        int seenFieldCount = 0;
        if (Validation.CODEC_VALIDATION_ENABLED) {
            this.missingRequiredFields.copy(this.REQUIRED_FIELDS);
            this.alreadyVisitedFields.clear();
        }
        this.buffer = buffer;
        int end = offset + length;
        int positionIter = position = offset;
        position += this.header.decode(buffer, position, length);
        while (position < end) {
            int equalsPosition = buffer.scan(position, end, '=');
            if (equalsPosition == -1) {
                return position;
            }
            int tag = buffer.getInt(position, equalsPosition);
            int valueOffset = equalsPosition + 1;
            int endOfField = buffer.scan(valueOffset, end, (byte)1);
            if (endOfField == -1) {
                this.rejectReason = 5;
                break;
            }
            int valueLength = endOfField - valueOffset;
            if (Validation.CODEC_VALIDATION_ENABLED) {
                if (tag <= 0) {
                    this.invalidTagId = tag;
                    this.rejectReason = 0;
                } else if (valueLength == 0) {
                    this.invalidTagId = tag;
                    this.rejectReason = 4;
                }
                if (!this.alreadyVisitedFields.add(tag)) {
                    this.invalidTagId = tag;
                    this.rejectReason = 13;
                }
                this.missingRequiredFields.remove(tag);
                ++seenFieldCount;
            }
            switch (tag) {
                case 98: {
                    this.encryptMethodOffset = valueOffset;
                    this.encryptMethodLength = valueLength;
                    break;
                }
                case 108: {
                    this.heartBtIntOffset = valueOffset;
                    this.heartBtIntLength = valueLength;
                    break;
                }
                case 95: {
                    this.hasRawDataLength = true;
                    this.rawDataLengthOffset = valueOffset;
                    this.rawDataLengthLength = valueLength;
                    break;
                }
                case 96: {
                    this.hasRawData = true;
                    endOfField = valueOffset + this.rawDataLength();
                    this.rawDataOffset = valueOffset;
                    break;
                }
                case 141: {
                    this.hasResetSeqNumFlag = true;
                    this.resetSeqNumFlag = buffer.getBoolean(valueOffset);
                    this.resetSeqNumFlagLength = valueLength;
                    break;
                }
                case 789: {
                    this.hasNextExpectedMsgSeqNum = true;
                    this.nextExpectedMsgSeqNumOffset = valueOffset;
                    this.nextExpectedMsgSeqNumLength = valueLength;
                    break;
                }
                case 383: {
                    this.hasMaxMessageSize = true;
                    this.maxMessageSizeOffset = valueOffset;
                    this.maxMessageSizeLength = valueLength;
                    break;
                }
                case 464: {
                    this.hasTestMessageIndicator = true;
                    this.testMessageIndicator = buffer.getBoolean(valueOffset);
                    this.testMessageIndicatorLength = valueLength;
                    break;
                }
                case 553: {
                    this.hasUsername = true;
                    this.usernameOffset = valueOffset;
                    this.usernameLength = valueLength;
                    break;
                }
                case 554: {
                    this.hasPassword = true;
                    this.passwordOffset = valueOffset;
                    this.passwordLength = valueLength;
                    break;
                }
                case 35002: {
                    this.hasCancelOnDisconnectType = true;
                    this.cancelOnDisconnectTypeOffset = valueOffset;
                    this.cancelOnDisconnectTypeLength = valueLength;
                    break;
                }
                case 35003: {
                    this.hasCODTimeoutWindow = true;
                    this.cODTimeoutWindowOffset = valueOffset;
                    this.cODTimeoutWindowLength = valueLength;
                    break;
                }
                default: {
                    if (!RejectUnknownField.CODEC_REJECT_UNKNOWN_FIELD_ENABLED) {
                        this.alreadyVisitedFields.remove(tag);
                    } else if (!this.trailer.REQUIRED_FIELDS.contains(tag)) {
                        this.unknownFields.add(tag);
                    }
                    if (!RejectUnknownField.CODEC_REJECT_UNKNOWN_FIELD_ENABLED && !this.trailer.REQUIRED_FIELDS.contains(tag)) break;
                    position += this.trailer.decode(buffer, position, end - position);
                    return position - offset;
                }
            }
            if (position >= endOfField + 1) continue;
            position = endOfField + 1;
        }
        position += this.trailer.decode(buffer, position, end - position);
        return position - offset;
    }

    public void reset() {
        this.header.reset();
        this.trailer.reset();
        this.resetMessage();
        this.buffer = null;
        if (Validation.CODEC_VALIDATION_ENABLED) {
            this.invalidTagId = -1;
            this.rejectReason = -1;
            this.missingRequiredFields.clear();
            this.unknownFields.clear();
            this.alreadyVisitedFields.clear();
        }
    }

    public void resetMessage() {
        this.resetEncryptMethod();
        this.resetHeartBtInt();
        this.resetRawDataLength();
        this.resetRawData();
        this.resetResetSeqNumFlag();
        this.resetNextExpectedMsgSeqNum();
        this.resetMaxMessageSize();
        this.resetTestMessageIndicator();
        this.resetUsername();
        this.resetPassword();
        this.resetCancelOnDisconnectType();
        this.resetCODTimeoutWindow();
    }

    public void resetEncryptMethod() {
        this.encryptMethodLength = 0;
        this.encryptMethod = Integer.MIN_VALUE;
    }

    public void resetHeartBtInt() {
        this.heartBtIntLength = 0;
        this.heartBtInt = Integer.MIN_VALUE;
    }

    public void resetRawDataLength() {
        this.hasRawDataLength = false;
    }

    public void resetRawData() {
        this.hasRawData = false;
    }

    public void resetResetSeqNumFlag() {
        this.hasResetSeqNumFlag = false;
    }

    public void resetNextExpectedMsgSeqNum() {
        this.hasNextExpectedMsgSeqNum = false;
    }

    public void resetMaxMessageSize() {
        this.hasMaxMessageSize = false;
    }

    public void resetTestMessageIndicator() {
        this.hasTestMessageIndicator = false;
    }

    public void resetUsername() {
        this.hasUsername = false;
    }

    public void resetPassword() {
        this.hasPassword = false;
    }

    public void resetCancelOnDisconnectType() {
        this.hasCancelOnDisconnectType = false;
    }

    public void resetCODTimeoutWindow() {
        this.hasCODTimeoutWindow = false;
    }

    public String toString() {
        return this.appendTo(new StringBuilder()).toString();
    }

    public StringBuilder appendTo(StringBuilder builder) {
        return this.appendTo(builder, 1);
    }

    public StringBuilder appendTo(StringBuilder builder, int level) {
        builder.append("{\n");
        CodecUtil.indent((StringBuilder)builder, (int)level);
        builder.append("\"MessageName\": \"Logon\",\n");
        builder.append("  \"header\": ");
        this.header.appendTo(builder, level + 1);
        builder.append("\n");
        CodecUtil.indent((StringBuilder)builder, (int)level);
        builder.append("\"EncryptMethod\": \"");
        builder.append(this.encryptMethod());
        builder.append("\",\n");
        CodecUtil.indent((StringBuilder)builder, (int)level);
        builder.append("\"HeartBtInt\": \"");
        builder.append(this.heartBtInt());
        builder.append("\",\n");
        if (this.hasRawDataLength()) {
            CodecUtil.indent((StringBuilder)builder, (int)level);
            builder.append("\"RawDataLength\": \"");
            builder.append(this.rawDataLength());
            builder.append("\",\n");
        }
        if (this.hasRawData()) {
            CodecUtil.indent((StringBuilder)builder, (int)level);
            builder.append("\"RawData\": \"");
            CodecUtil.appendData((StringBuilder)builder, (byte[])this.rawData(), (int)this.rawDataLength());
            builder.append("\",\n");
        }
        if (this.hasResetSeqNumFlag()) {
            CodecUtil.indent((StringBuilder)builder, (int)level);
            builder.append("\"ResetSeqNumFlag\": \"");
            builder.append(this.resetSeqNumFlag());
            builder.append("\",\n");
        }
        if (this.hasNextExpectedMsgSeqNum()) {
            CodecUtil.indent((StringBuilder)builder, (int)level);
            builder.append("\"NextExpectedMsgSeqNum\": \"");
            builder.append(this.nextExpectedMsgSeqNum());
            builder.append("\",\n");
        }
        if (this.hasMaxMessageSize()) {
            CodecUtil.indent((StringBuilder)builder, (int)level);
            builder.append("\"MaxMessageSize\": \"");
            builder.append(this.maxMessageSize());
            builder.append("\",\n");
        }
        if (this.hasTestMessageIndicator()) {
            CodecUtil.indent((StringBuilder)builder, (int)level);
            builder.append("\"TestMessageIndicator\": \"");
            builder.append(this.testMessageIndicator());
            builder.append("\",\n");
        }
        if (this.hasUsername()) {
            CodecUtil.indent((StringBuilder)builder, (int)level);
            builder.append("\"Username\": \"");
            builder.append(this.username(), 0, this.usernameLength());
            builder.append("\",\n");
        }
        if (this.hasPassword()) {
            CodecUtil.indent((StringBuilder)builder, (int)level);
            builder.append("\"Password\": \"");
            builder.append(this.password(), 0, this.passwordLength());
            builder.append("\",\n");
        }
        if (this.hasCancelOnDisconnectType()) {
            CodecUtil.indent((StringBuilder)builder, (int)level);
            builder.append("\"CancelOnDisconnectType\": \"");
            builder.append(this.cancelOnDisconnectType());
            builder.append("\",\n");
        }
        if (this.hasCODTimeoutWindow()) {
            CodecUtil.indent((StringBuilder)builder, (int)level);
            builder.append("\"CODTimeoutWindow\": \"");
            builder.append(this.cODTimeoutWindow());
            builder.append("\",\n");
        }
        CodecUtil.indent((StringBuilder)builder, (int)(level - 1));
        builder.append("}");
        return builder;
    }

    public LogonEncoder toEncoder(Encoder encoder) {
        return this.toEncoder((LogonEncoder)encoder);
    }

    public LogonEncoder toEncoder(LogonEncoder encoder) {
        encoder.reset();
        encoder.encryptMethod(this.encryptMethod());
        encoder.heartBtInt(this.heartBtInt());
        if (this.hasRawDataLength()) {
            encoder.rawDataLength(this.rawDataLength());
        }
        if (this.hasRawData()) {
            encoder.rawDataAsCopy(this.rawData(), 0, this.rawDataLength());
            encoder.rawDataLength(this.rawDataLength());
        }
        if (this.hasResetSeqNumFlag()) {
            encoder.resetSeqNumFlag(this.resetSeqNumFlag());
        }
        if (this.hasNextExpectedMsgSeqNum()) {
            encoder.nextExpectedMsgSeqNum(this.nextExpectedMsgSeqNum());
        }
        if (this.hasMaxMessageSize()) {
            encoder.maxMessageSize(this.maxMessageSize());
        }
        if (this.hasTestMessageIndicator()) {
            encoder.testMessageIndicator(this.testMessageIndicator());
        }
        if (this.hasUsername()) {
            encoder.username(this.username(), 0, this.usernameLength());
        }
        if (this.hasPassword()) {
            encoder.password(this.password(), 0, this.passwordLength());
        }
        if (this.hasCancelOnDisconnectType()) {
            encoder.cancelOnDisconnectType(this.cancelOnDisconnectType());
        }
        if (this.hasCODTimeoutWindow()) {
            encoder.cODTimeoutWindow(this.cODTimeoutWindow());
        }
        return encoder;
    }
}

