/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.other.builder;

import org.agrona.AsciiSequenceView;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.agrona.concurrent.UnsafeBuffer;
import uk.co.real_logic.artio.EncodingException;
import uk.co.real_logic.artio.builder.Encoder;
import uk.co.real_logic.artio.builder.Validation;
import uk.co.real_logic.artio.dictionary.Generated;
import uk.co.real_logic.artio.dictionary.generation.CodecUtil;
import uk.co.real_logic.artio.other.ExecType;
import uk.co.real_logic.artio.other.OrdStatus;
import uk.co.real_logic.artio.other.Side;
import uk.co.real_logic.artio.other.builder.HeaderEncoder;
import uk.co.real_logic.artio.other.builder.InstrumentEncoder;
import uk.co.real_logic.artio.other.builder.TrailerEncoder;
import uk.co.real_logic.artio.util.MutableAsciiBuffer;

@Generated(value={"uk.co.real_logic.artio"})
public class ExecutionReportEncoder
implements Encoder {
    private final TrailerEncoder trailer = new TrailerEncoder();
    private final HeaderEncoder header = new HeaderEncoder();
    private static final int orderIDHeaderLength = 3;
    private static final byte[] orderIDHeader = new byte[]{51, 55, 61};
    private static final int execIDHeaderLength = 3;
    private static final byte[] execIDHeader = new byte[]{49, 55, 61};
    private static final int execTypeHeaderLength = 4;
    private static final byte[] execTypeHeader = new byte[]{49, 53, 48, 61};
    private static final int ordStatusHeaderLength = 3;
    private static final byte[] ordStatusHeader = new byte[]{51, 57, 61};
    private static final int sideHeaderLength = 3;
    private static final byte[] sideHeader = new byte[]{53, 52, 61};
    private final MutableDirectBuffer orderID = new UnsafeBuffer();
    private byte[] orderIDInternalBuffer = this.orderID.byteArray();
    private int orderIDOffset = 0;
    private int orderIDLength = 0;
    private final MutableDirectBuffer execID = new UnsafeBuffer();
    private byte[] execIDInternalBuffer = this.execID.byteArray();
    private int execIDOffset = 0;
    private int execIDLength = 0;
    private char execType;
    private boolean hasExecType;
    private char ordStatus;
    private boolean hasOrdStatus;
    private final InstrumentEncoder instrument = new InstrumentEncoder();
    private char side;
    private boolean hasSide;

    public long messageType() {
        return 56L;
    }

    public ExecutionReportEncoder() {
        this.header.msgType("8");
    }

    public TrailerEncoder trailer() {
        return this.trailer;
    }

    public HeaderEncoder header() {
        return this.header;
    }

    public ExecutionReportEncoder orderID(DirectBuffer value, int offset, int length) {
        this.orderID.wrap(value);
        this.orderIDOffset = offset;
        this.orderIDLength = length;
        return this;
    }

    public ExecutionReportEncoder orderID(DirectBuffer value, int length) {
        return this.orderID(value, 0, length);
    }

    public ExecutionReportEncoder orderID(DirectBuffer value) {
        return this.orderID(value, 0, value.capacity());
    }

    public ExecutionReportEncoder orderID(byte[] value, int offset, int length) {
        this.orderID.wrap(value);
        this.orderIDOffset = offset;
        this.orderIDLength = length;
        return this;
    }

    public ExecutionReportEncoder orderIDAsCopy(byte[] value, int offset, int length) {
        if (CodecUtil.copyInto((MutableDirectBuffer)this.orderID, (byte[])value, (int)offset, (int)length)) {
            this.orderIDInternalBuffer = this.orderID.byteArray();
        }
        this.orderIDOffset = 0;
        this.orderIDLength = length;
        return this;
    }

    public ExecutionReportEncoder orderID(byte[] value, int length) {
        return this.orderID(value, 0, length);
    }

    public ExecutionReportEncoder orderID(byte[] value) {
        return this.orderID(value, 0, value.length);
    }

    public boolean hasOrderID() {
        return this.orderIDLength > 0;
    }

    public MutableDirectBuffer orderID() {
        return this.orderID;
    }

    public String orderIDAsString() {
        return this.orderID.getStringWithoutLengthAscii(this.orderIDOffset, this.orderIDLength);
    }

    public ExecutionReportEncoder orderID(CharSequence value) {
        if (CodecUtil.toBytes((CharSequence)value, (MutableDirectBuffer)this.orderID)) {
            this.orderIDInternalBuffer = this.orderID.byteArray();
        }
        this.orderIDOffset = 0;
        this.orderIDLength = value.length();
        return this;
    }

    public ExecutionReportEncoder orderID(AsciiSequenceView value) {
        DirectBuffer buffer = value.buffer();
        if (buffer != null) {
            this.orderID.wrap(buffer);
            this.orderIDOffset = value.offset();
            this.orderIDLength = value.length();
        }
        return this;
    }

    public ExecutionReportEncoder orderID(char[] value) {
        return this.orderID(value, 0, value.length);
    }

    public ExecutionReportEncoder orderID(char[] value, int length) {
        return this.orderID(value, 0, length);
    }

    public ExecutionReportEncoder orderID(char[] value, int offset, int length) {
        if (CodecUtil.toBytes((char[])value, (MutableDirectBuffer)this.orderID, (int)offset, (int)length)) {
            this.orderIDInternalBuffer = this.orderID.byteArray();
        }
        this.orderIDOffset = 0;
        this.orderIDLength = length;
        return this;
    }

    public ExecutionReportEncoder execID(DirectBuffer value, int offset, int length) {
        this.execID.wrap(value);
        this.execIDOffset = offset;
        this.execIDLength = length;
        return this;
    }

    public ExecutionReportEncoder execID(DirectBuffer value, int length) {
        return this.execID(value, 0, length);
    }

    public ExecutionReportEncoder execID(DirectBuffer value) {
        return this.execID(value, 0, value.capacity());
    }

    public ExecutionReportEncoder execID(byte[] value, int offset, int length) {
        this.execID.wrap(value);
        this.execIDOffset = offset;
        this.execIDLength = length;
        return this;
    }

    public ExecutionReportEncoder execIDAsCopy(byte[] value, int offset, int length) {
        if (CodecUtil.copyInto((MutableDirectBuffer)this.execID, (byte[])value, (int)offset, (int)length)) {
            this.execIDInternalBuffer = this.execID.byteArray();
        }
        this.execIDOffset = 0;
        this.execIDLength = length;
        return this;
    }

    public ExecutionReportEncoder execID(byte[] value, int length) {
        return this.execID(value, 0, length);
    }

    public ExecutionReportEncoder execID(byte[] value) {
        return this.execID(value, 0, value.length);
    }

    public boolean hasExecID() {
        return this.execIDLength > 0;
    }

    public MutableDirectBuffer execID() {
        return this.execID;
    }

    public String execIDAsString() {
        return this.execID.getStringWithoutLengthAscii(this.execIDOffset, this.execIDLength);
    }

    public ExecutionReportEncoder execID(CharSequence value) {
        if (CodecUtil.toBytes((CharSequence)value, (MutableDirectBuffer)this.execID)) {
            this.execIDInternalBuffer = this.execID.byteArray();
        }
        this.execIDOffset = 0;
        this.execIDLength = value.length();
        return this;
    }

    public ExecutionReportEncoder execID(AsciiSequenceView value) {
        DirectBuffer buffer = value.buffer();
        if (buffer != null) {
            this.execID.wrap(buffer);
            this.execIDOffset = value.offset();
            this.execIDLength = value.length();
        }
        return this;
    }

    public ExecutionReportEncoder execID(char[] value) {
        return this.execID(value, 0, value.length);
    }

    public ExecutionReportEncoder execID(char[] value, int length) {
        return this.execID(value, 0, length);
    }

    public ExecutionReportEncoder execID(char[] value, int offset, int length) {
        if (CodecUtil.toBytes((char[])value, (MutableDirectBuffer)this.execID, (int)offset, (int)length)) {
            this.execIDInternalBuffer = this.execID.byteArray();
        }
        this.execIDOffset = 0;
        this.execIDLength = length;
        return this;
    }

    public boolean hasExecType() {
        return this.hasExecType;
    }

    public ExecutionReportEncoder execType(char value) {
        this.execType = value;
        this.hasExecType = true;
        return this;
    }

    public char execType() {
        return this.execType;
    }

    public ExecutionReportEncoder execType(ExecType value) {
        if (Validation.CODEC_VALIDATION_ENABLED) {
            if (value == ExecType.ARTIO_UNKNOWN) {
                throw new EncodingException("Invalid Value Field: execType Value: " + String.valueOf((Object)value));
            }
            if (value == ExecType.NULL_VAL) {
                return this;
            }
        }
        return this.execType(value.representation());
    }

    public boolean hasOrdStatus() {
        return this.hasOrdStatus;
    }

    public ExecutionReportEncoder ordStatus(char value) {
        this.ordStatus = value;
        this.hasOrdStatus = true;
        return this;
    }

    public char ordStatus() {
        return this.ordStatus;
    }

    public ExecutionReportEncoder ordStatus(OrdStatus value) {
        if (Validation.CODEC_VALIDATION_ENABLED) {
            if (value == OrdStatus.ARTIO_UNKNOWN) {
                throw new EncodingException("Invalid Value Field: ordStatus Value: " + String.valueOf((Object)value));
            }
            if (value == OrdStatus.NULL_VAL) {
                return this;
            }
        }
        return this.ordStatus(value.representation());
    }

    public InstrumentEncoder instrument() {
        return this.instrument;
    }

    public boolean hasSide() {
        return this.hasSide;
    }

    public ExecutionReportEncoder side(char value) {
        this.side = value;
        this.hasSide = true;
        return this;
    }

    public char side() {
        return this.side;
    }

    public ExecutionReportEncoder side(Side value) {
        if (Validation.CODEC_VALIDATION_ENABLED) {
            if (value == Side.ARTIO_UNKNOWN) {
                throw new EncodingException("Invalid Value Field: side Value: " + String.valueOf((Object)value));
            }
            if (value == Side.NULL_VAL) {
                return this;
            }
        }
        return this.side(value.representation());
    }

    public long encode(MutableAsciiBuffer buffer, int offset) {
        long startMessageResult = this.header.startMessage(buffer, offset);
        int bodyStart = Encoder.offset((long)startMessageResult);
        int position = bodyStart + Encoder.length((long)startMessageResult);
        if (this.orderIDLength > 0) {
            buffer.putBytes(position, orderIDHeader, 0, 3);
            buffer.putBytes(position += 3, (DirectBuffer)this.orderID, this.orderIDOffset, this.orderIDLength);
            buffer.putSeparator(position += this.orderIDLength);
            ++position;
        } else if (Validation.CODEC_VALIDATION_ENABLED) {
            throw new EncodingException("Missing Field: OrderID");
        }
        if (this.execIDLength > 0) {
            buffer.putBytes(position, execIDHeader, 0, 3);
            buffer.putBytes(position += 3, (DirectBuffer)this.execID, this.execIDOffset, this.execIDLength);
            buffer.putSeparator(position += this.execIDLength);
            ++position;
        } else if (Validation.CODEC_VALIDATION_ENABLED) {
            throw new EncodingException("Missing Field: ExecID");
        }
        if (this.hasExecType) {
            buffer.putBytes(position, execTypeHeader, 0, 4);
            position += 4;
            position += buffer.putCharAscii(position, this.execType);
            buffer.putSeparator(position);
            ++position;
        } else if (Validation.CODEC_VALIDATION_ENABLED) {
            throw new EncodingException("Missing Field: ExecType");
        }
        if (this.hasOrdStatus) {
            buffer.putBytes(position, ordStatusHeader, 0, 3);
            position += 3;
            position += buffer.putCharAscii(position, this.ordStatus);
            buffer.putSeparator(position);
            ++position;
        } else if (Validation.CODEC_VALIDATION_ENABLED) {
            throw new EncodingException("Missing Field: OrdStatus");
        }
        position += this.instrument.encode(buffer, position);
        if (this.hasSide) {
            buffer.putBytes(position, sideHeader, 0, 3);
            position += 3;
            position += buffer.putCharAscii(position, this.side);
            buffer.putSeparator(position);
            ++position;
        } else if (Validation.CODEC_VALIDATION_ENABLED) {
            throw new EncodingException("Missing Field: Side");
        }
        position += this.trailer.startTrailer(buffer, position);
        int messageStart = this.header.finishHeader(buffer, bodyStart, position - bodyStart);
        return this.trailer.finishMessage(buffer, messageStart, position);
    }

    public void reset() {
        this.header.reset();
        this.trailer.reset();
        this.resetMessage();
    }

    public void resetMessage() {
        this.resetOrderID();
        this.resetExecID();
        this.resetExecType();
        this.resetOrdStatus();
        this.resetSide();
        this.instrument.reset();
    }

    public void resetOrderID() {
        this.orderIDLength = 0;
        this.orderID.wrap(this.orderIDInternalBuffer);
    }

    public void resetExecID() {
        this.execIDLength = 0;
        this.execID.wrap(this.execIDInternalBuffer);
    }

    public void resetExecType() {
        this.execType = '\u0001';
    }

    public void resetOrdStatus() {
        this.ordStatus = '\u0001';
    }

    public void resetSide() {
        this.side = '\u0001';
    }

    public String toString() {
        return this.appendTo(new StringBuilder()).toString();
    }

    public StringBuilder appendTo(StringBuilder builder) {
        return this.appendTo(builder, 1);
    }

    public StringBuilder appendTo(StringBuilder builder, int level) {
        builder.append("{\n");
        CodecUtil.indent((StringBuilder)builder, (int)level);
        builder.append("\"MessageName\": \"ExecutionReport\",\n");
        builder.append("  \"header\": ");
        this.header.appendTo(builder, level + 1);
        builder.append("\n");
        if (this.hasOrderID()) {
            CodecUtil.indent((StringBuilder)builder, (int)level);
            builder.append("\"OrderID\": \"");
            CodecUtil.appendBuffer((StringBuilder)builder, (MutableDirectBuffer)this.orderID, (int)this.orderIDOffset, (int)this.orderIDLength);
            builder.append("\",\n");
        }
        if (this.hasExecID()) {
            CodecUtil.indent((StringBuilder)builder, (int)level);
            builder.append("\"ExecID\": \"");
            CodecUtil.appendBuffer((StringBuilder)builder, (MutableDirectBuffer)this.execID, (int)this.execIDOffset, (int)this.execIDLength);
            builder.append("\",\n");
        }
        if (this.hasExecType()) {
            CodecUtil.indent((StringBuilder)builder, (int)level);
            builder.append("\"ExecType\": \"");
            builder.append(this.execType);
            builder.append("\",\n");
        }
        if (this.hasOrdStatus()) {
            CodecUtil.indent((StringBuilder)builder, (int)level);
            builder.append("\"OrdStatus\": \"");
            builder.append(this.ordStatus);
            builder.append("\",\n");
        }
        CodecUtil.indent((StringBuilder)builder, (int)level);
        builder.append("\"Instrument\": ");
        this.instrument.appendTo(builder, level + 1);
        builder.append("\n");
        if (this.hasSide()) {
            CodecUtil.indent((StringBuilder)builder, (int)level);
            builder.append("\"Side\": \"");
            builder.append(this.side);
            builder.append("\",\n");
        }
        CodecUtil.indent((StringBuilder)builder, (int)(level - 1));
        builder.append("}");
        return builder;
    }

    public ExecutionReportEncoder copyTo(Encoder encoder) {
        return this.copyTo((ExecutionReportEncoder)encoder);
    }

    public ExecutionReportEncoder copyTo(ExecutionReportEncoder encoder) {
        encoder.reset();
        if (this.hasOrderID()) {
            encoder.orderIDAsCopy(this.orderID.byteArray(), 0, this.orderIDLength);
        }
        if (this.hasExecID()) {
            encoder.execIDAsCopy(this.execID.byteArray(), 0, this.execIDLength);
        }
        if (this.hasExecType()) {
            encoder.execType(this.execType());
        }
        if (this.hasOrdStatus()) {
            encoder.ordStatus(this.ordStatus());
        }
        this.instrument.copyTo(encoder.instrument());
        if (this.hasSide()) {
            encoder.side(this.side());
        }
        return encoder;
    }
}

