/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.other.builder;

import org.agrona.AsciiSequenceView;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.agrona.concurrent.UnsafeBuffer;
import uk.co.real_logic.artio.EncodingException;
import uk.co.real_logic.artio.builder.AbstractRejectEncoder;
import uk.co.real_logic.artio.builder.Encoder;
import uk.co.real_logic.artio.builder.Validation;
import uk.co.real_logic.artio.dictionary.Generated;
import uk.co.real_logic.artio.dictionary.generation.CodecUtil;
import uk.co.real_logic.artio.other.SessionRejectReason;
import uk.co.real_logic.artio.other.builder.HeaderEncoder;
import uk.co.real_logic.artio.other.builder.TrailerEncoder;
import uk.co.real_logic.artio.util.MutableAsciiBuffer;

@Generated(value={"uk.co.real_logic.artio"})
public class RejectEncoder
implements AbstractRejectEncoder {
    private final TrailerEncoder trailer = new TrailerEncoder();
    private final HeaderEncoder header = new HeaderEncoder();
    private static final int refSeqNumHeaderLength = 3;
    private static final byte[] refSeqNumHeader = new byte[]{52, 53, 61};
    private static final int refTagIDHeaderLength = 4;
    private static final byte[] refTagIDHeader = new byte[]{51, 55, 49, 61};
    private static final int refMsgTypeHeaderLength = 4;
    private static final byte[] refMsgTypeHeader = new byte[]{51, 55, 50, 61};
    private static final int sessionRejectReasonHeaderLength = 4;
    private static final byte[] sessionRejectReasonHeader = new byte[]{51, 55, 51, 61};
    private static final int textHeaderLength = 3;
    private static final byte[] textHeader = new byte[]{53, 56, 61};
    private int refSeqNum;
    private boolean hasRefSeqNum;
    private int refTagID;
    private boolean hasRefTagID;
    private final MutableDirectBuffer refMsgType = new UnsafeBuffer();
    private byte[] refMsgTypeInternalBuffer = this.refMsgType.byteArray();
    private int refMsgTypeOffset = 0;
    private int refMsgTypeLength = 0;
    private int sessionRejectReason;
    private boolean hasSessionRejectReason;
    private final MutableDirectBuffer text = new UnsafeBuffer();
    private byte[] textInternalBuffer = this.text.byteArray();
    private int textOffset = 0;
    private int textLength = 0;

    public long messageType() {
        return 51L;
    }

    public RejectEncoder() {
        this.header.msgType("3");
    }

    public TrailerEncoder trailer() {
        return this.trailer;
    }

    public HeaderEncoder header() {
        return this.header;
    }

    public boolean hasRefSeqNum() {
        return this.hasRefSeqNum;
    }

    public RejectEncoder refSeqNum(int value) {
        this.refSeqNum = value;
        this.hasRefSeqNum = true;
        return this;
    }

    public int refSeqNum() {
        return this.refSeqNum;
    }

    public boolean hasRefTagID() {
        return this.hasRefTagID;
    }

    public RejectEncoder refTagID(int value) {
        this.refTagID = value;
        this.hasRefTagID = true;
        return this;
    }

    public int refTagID() {
        return this.refTagID;
    }

    public RejectEncoder refMsgType(DirectBuffer value, int offset, int length) {
        this.refMsgType.wrap(value);
        this.refMsgTypeOffset = offset;
        this.refMsgTypeLength = length;
        return this;
    }

    public RejectEncoder refMsgType(DirectBuffer value, int length) {
        return this.refMsgType(value, 0, length);
    }

    public RejectEncoder refMsgType(DirectBuffer value) {
        return this.refMsgType(value, 0, value.capacity());
    }

    public RejectEncoder refMsgType(byte[] value, int offset, int length) {
        this.refMsgType.wrap(value);
        this.refMsgTypeOffset = offset;
        this.refMsgTypeLength = length;
        return this;
    }

    public RejectEncoder refMsgTypeAsCopy(byte[] value, int offset, int length) {
        if (CodecUtil.copyInto((MutableDirectBuffer)this.refMsgType, (byte[])value, (int)offset, (int)length)) {
            this.refMsgTypeInternalBuffer = this.refMsgType.byteArray();
        }
        this.refMsgTypeOffset = 0;
        this.refMsgTypeLength = length;
        return this;
    }

    public RejectEncoder refMsgType(byte[] value, int length) {
        return this.refMsgType(value, 0, length);
    }

    public RejectEncoder refMsgType(byte[] value) {
        return this.refMsgType(value, 0, value.length);
    }

    public boolean hasRefMsgType() {
        return this.refMsgTypeLength > 0;
    }

    public MutableDirectBuffer refMsgType() {
        return this.refMsgType;
    }

    public String refMsgTypeAsString() {
        return this.refMsgType.getStringWithoutLengthAscii(this.refMsgTypeOffset, this.refMsgTypeLength);
    }

    public RejectEncoder refMsgType(CharSequence value) {
        if (CodecUtil.toBytes((CharSequence)value, (MutableDirectBuffer)this.refMsgType)) {
            this.refMsgTypeInternalBuffer = this.refMsgType.byteArray();
        }
        this.refMsgTypeOffset = 0;
        this.refMsgTypeLength = value.length();
        return this;
    }

    public RejectEncoder refMsgType(AsciiSequenceView value) {
        DirectBuffer buffer = value.buffer();
        if (buffer != null) {
            this.refMsgType.wrap(buffer);
            this.refMsgTypeOffset = value.offset();
            this.refMsgTypeLength = value.length();
        }
        return this;
    }

    public RejectEncoder refMsgType(char[] value) {
        return this.refMsgType(value, 0, value.length);
    }

    public RejectEncoder refMsgType(char[] value, int length) {
        return this.refMsgType(value, 0, length);
    }

    public RejectEncoder refMsgType(char[] value, int offset, int length) {
        if (CodecUtil.toBytes((char[])value, (MutableDirectBuffer)this.refMsgType, (int)offset, (int)length)) {
            this.refMsgTypeInternalBuffer = this.refMsgType.byteArray();
        }
        this.refMsgTypeOffset = 0;
        this.refMsgTypeLength = length;
        return this;
    }

    public boolean hasSessionRejectReason() {
        return this.hasSessionRejectReason;
    }

    public RejectEncoder sessionRejectReason(int value) {
        this.sessionRejectReason = value;
        this.hasSessionRejectReason = true;
        return this;
    }

    public int sessionRejectReason() {
        return this.sessionRejectReason;
    }

    public RejectEncoder sessionRejectReason(SessionRejectReason value) {
        if (Validation.CODEC_VALIDATION_ENABLED) {
            if (value == SessionRejectReason.ARTIO_UNKNOWN) {
                throw new EncodingException("Invalid Value Field: sessionRejectReason Value: " + value);
            }
            if (value == SessionRejectReason.NULL_VAL) {
                return this;
            }
        }
        return this.sessionRejectReason(value.representation());
    }

    public RejectEncoder text(DirectBuffer value, int offset, int length) {
        this.text.wrap(value);
        this.textOffset = offset;
        this.textLength = length;
        return this;
    }

    public RejectEncoder text(DirectBuffer value, int length) {
        return this.text(value, 0, length);
    }

    public RejectEncoder text(DirectBuffer value) {
        return this.text(value, 0, value.capacity());
    }

    public RejectEncoder text(byte[] value, int offset, int length) {
        this.text.wrap(value);
        this.textOffset = offset;
        this.textLength = length;
        return this;
    }

    public RejectEncoder textAsCopy(byte[] value, int offset, int length) {
        if (CodecUtil.copyInto((MutableDirectBuffer)this.text, (byte[])value, (int)offset, (int)length)) {
            this.textInternalBuffer = this.text.byteArray();
        }
        this.textOffset = 0;
        this.textLength = length;
        return this;
    }

    public RejectEncoder text(byte[] value, int length) {
        return this.text(value, 0, length);
    }

    public RejectEncoder text(byte[] value) {
        return this.text(value, 0, value.length);
    }

    public boolean hasText() {
        return this.textLength > 0;
    }

    public MutableDirectBuffer text() {
        return this.text;
    }

    public String textAsString() {
        return this.text.getStringWithoutLengthAscii(this.textOffset, this.textLength);
    }

    public RejectEncoder text(CharSequence value) {
        if (CodecUtil.toBytes((CharSequence)value, (MutableDirectBuffer)this.text)) {
            this.textInternalBuffer = this.text.byteArray();
        }
        this.textOffset = 0;
        this.textLength = value.length();
        return this;
    }

    public RejectEncoder text(AsciiSequenceView value) {
        DirectBuffer buffer = value.buffer();
        if (buffer != null) {
            this.text.wrap(buffer);
            this.textOffset = value.offset();
            this.textLength = value.length();
        }
        return this;
    }

    public RejectEncoder text(char[] value) {
        return this.text(value, 0, value.length);
    }

    public RejectEncoder text(char[] value, int length) {
        return this.text(value, 0, length);
    }

    public RejectEncoder text(char[] value, int offset, int length) {
        if (CodecUtil.toBytes((char[])value, (MutableDirectBuffer)this.text, (int)offset, (int)length)) {
            this.textInternalBuffer = this.text.byteArray();
        }
        this.textOffset = 0;
        this.textLength = length;
        return this;
    }

    public boolean supportsRefMsgType() {
        return true;
    }

    public long encode(MutableAsciiBuffer buffer, int offset) {
        long startMessageResult = this.header.startMessage(buffer, offset);
        int bodyStart = Encoder.offset((long)startMessageResult);
        int position = bodyStart + Encoder.length((long)startMessageResult);
        if (this.hasRefSeqNum) {
            buffer.putBytes(position, refSeqNumHeader, 0, 3);
            position += 3;
            position += buffer.putIntAscii(position, this.refSeqNum);
            buffer.putSeparator(position);
            ++position;
        } else if (Validation.CODEC_VALIDATION_ENABLED) {
            throw new EncodingException("Missing Field: RefSeqNum");
        }
        if (this.hasRefTagID) {
            buffer.putBytes(position, refTagIDHeader, 0, 4);
            position += 4;
            position += buffer.putIntAscii(position, this.refTagID);
            buffer.putSeparator(position);
            ++position;
        }
        if (this.refMsgTypeLength > 0) {
            buffer.putBytes(position, refMsgTypeHeader, 0, 4);
            buffer.putBytes(position += 4, (DirectBuffer)this.refMsgType, this.refMsgTypeOffset, this.refMsgTypeLength);
            buffer.putSeparator(position += this.refMsgTypeLength);
            ++position;
        }
        if (this.hasSessionRejectReason) {
            buffer.putBytes(position, sessionRejectReasonHeader, 0, 4);
            position += 4;
            position += buffer.putIntAscii(position, this.sessionRejectReason);
            buffer.putSeparator(position);
            ++position;
        }
        if (this.textLength > 0) {
            buffer.putBytes(position, textHeader, 0, 3);
            buffer.putBytes(position += 3, (DirectBuffer)this.text, this.textOffset, this.textLength);
            buffer.putSeparator(position += this.textLength);
            ++position;
        }
        position += this.trailer.startTrailer(buffer, position);
        int messageStart = this.header.finishHeader(buffer, bodyStart, position - bodyStart);
        return this.trailer.finishMessage(buffer, messageStart, position);
    }

    public void reset() {
        this.header.reset();
        this.trailer.reset();
        this.resetMessage();
    }

    public void resetMessage() {
        this.resetRefSeqNum();
        this.resetRefTagID();
        this.resetRefMsgType();
        this.resetSessionRejectReason();
        this.resetText();
    }

    public void resetRefSeqNum() {
        this.hasRefSeqNum = false;
    }

    public void resetRefTagID() {
        this.hasRefTagID = false;
    }

    public void resetRefMsgType() {
        this.refMsgTypeLength = 0;
        this.refMsgType.wrap(this.refMsgTypeInternalBuffer);
    }

    public void resetSessionRejectReason() {
        this.hasSessionRejectReason = false;
    }

    public void resetText() {
        this.textLength = 0;
        this.text.wrap(this.textInternalBuffer);
    }

    public String toString() {
        return this.appendTo(new StringBuilder()).toString();
    }

    public StringBuilder appendTo(StringBuilder builder) {
        return this.appendTo(builder, 1);
    }

    public StringBuilder appendTo(StringBuilder builder, int level) {
        builder.append("{\n");
        CodecUtil.indent((StringBuilder)builder, (int)level);
        builder.append("\"MessageName\": \"Reject\",\n");
        builder.append("  \"header\": ");
        this.header.appendTo(builder, level + 1);
        builder.append("\n");
        if (this.hasRefSeqNum()) {
            CodecUtil.indent((StringBuilder)builder, (int)level);
            builder.append("\"RefSeqNum\": \"");
            builder.append(this.refSeqNum);
            builder.append("\",\n");
        }
        if (this.hasRefTagID()) {
            CodecUtil.indent((StringBuilder)builder, (int)level);
            builder.append("\"RefTagID\": \"");
            builder.append(this.refTagID);
            builder.append("\",\n");
        }
        if (this.hasRefMsgType()) {
            CodecUtil.indent((StringBuilder)builder, (int)level);
            builder.append("\"RefMsgType\": \"");
            CodecUtil.appendBuffer((StringBuilder)builder, (MutableDirectBuffer)this.refMsgType, (int)this.refMsgTypeOffset, (int)this.refMsgTypeLength);
            builder.append("\",\n");
        }
        if (this.hasSessionRejectReason()) {
            CodecUtil.indent((StringBuilder)builder, (int)level);
            builder.append("\"SessionRejectReason\": \"");
            builder.append(this.sessionRejectReason);
            builder.append("\",\n");
        }
        if (this.hasText()) {
            CodecUtil.indent((StringBuilder)builder, (int)level);
            builder.append("\"Text\": \"");
            CodecUtil.appendBuffer((StringBuilder)builder, (MutableDirectBuffer)this.text, (int)this.textOffset, (int)this.textLength);
            builder.append("\",\n");
        }
        CodecUtil.indent((StringBuilder)builder, (int)(level - 1));
        builder.append("}");
        return builder;
    }

    public RejectEncoder copyTo(Encoder encoder) {
        return this.copyTo((RejectEncoder)encoder);
    }

    public RejectEncoder copyTo(RejectEncoder encoder) {
        encoder.reset();
        if (this.hasRefSeqNum()) {
            encoder.refSeqNum(this.refSeqNum());
        }
        if (this.hasRefTagID()) {
            encoder.refTagID(this.refTagID());
        }
        if (this.hasRefMsgType()) {
            encoder.refMsgTypeAsCopy(this.refMsgType.byteArray(), 0, this.refMsgTypeLength);
        }
        if (this.hasSessionRejectReason()) {
            encoder.sessionRejectReason(this.sessionRejectReason());
        }
        if (this.hasText()) {
            encoder.textAsCopy(this.text.byteArray(), 0, this.textLength);
        }
        return encoder;
    }
}

