/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.other;

import java.util.HashMap;
import uk.co.real_logic.artio.builder.StringRepresentable;
import uk.co.real_logic.artio.dictionary.CharArrayMap;
import uk.co.real_logic.artio.dictionary.CharArrayWrapper;

public enum MsgType implements StringRepresentable
{
    HEARTBEAT("0"),
    TEST_REQUEST("1"),
    RESEND_REQUEST("2"),
    REJECT("3"),
    SEQUENCE_RESET("4"),
    LOGOUT("5"),
    EXECUTION_REPORT("8"),
    LOGON("A"),
    ORDER_SINGLE("D"),
    USER_REQUEST("BE"),
    NULL_VAL("\u0001"),
    ARTIO_UNKNOWN("\u0002");

    private final String representation;
    private static final CharArrayMap<MsgType> charMap;

    private MsgType(String representation) {
        this.representation = representation;
    }

    public final String representation() {
        return this.representation;
    }

    public static MsgType decode(CharArrayWrapper key) {
        MsgType value = (MsgType)((Object)charMap.get(key));
        if (value == null) {
            return ARTIO_UNKNOWN;
        }
        return value;
    }

    public static boolean isValid(CharArrayWrapper key) {
        return charMap.containsKey(key);
    }

    public static MsgType decode(String representation) {
        switch (representation) {
            case "0": {
                return HEARTBEAT;
            }
            case "1": {
                return TEST_REQUEST;
            }
            case "2": {
                return RESEND_REQUEST;
            }
            case "3": {
                return REJECT;
            }
            case "4": {
                return SEQUENCE_RESET;
            }
            case "5": {
                return LOGOUT;
            }
            case "8": {
                return EXECUTION_REPORT;
            }
            case "A": {
                return LOGON;
            }
            case "D": {
                return ORDER_SINGLE;
            }
            case "BE": {
                return USER_REQUEST;
            }
        }
        return ARTIO_UNKNOWN;
    }

    static {
        HashMap<String, MsgType> stringMap = new HashMap<String, MsgType>();
        stringMap.put("0", HEARTBEAT);
        stringMap.put("1", TEST_REQUEST);
        stringMap.put("2", RESEND_REQUEST);
        stringMap.put("3", REJECT);
        stringMap.put("4", SEQUENCE_RESET);
        stringMap.put("5", LOGOUT);
        stringMap.put("8", EXECUTION_REPORT);
        stringMap.put("A", LOGON);
        stringMap.put("D", ORDER_SINGLE);
        stringMap.put("BE", USER_REQUEST);
        charMap = new CharArrayMap(stringMap);
    }
}

