/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.engine.logger;

import java.io.File;
import org.agrona.collections.Long2LongHashMap;
import uk.co.real_logic.artio.engine.logger.ReplayIndexDescriptor;
import uk.co.real_logic.artio.engine.logger.ReplayIndexExtractor;
import uk.co.real_logic.artio.engine.logger.ReplayQuery;

public final class ReplayIndexPositionScanner {
    public static void main(String[] args) {
        Long2LongHashMap recordingIdToNewStartPosition = new Long2LongHashMap(-1L);
        ReplayIndexPositionScanner.printFiles(args[0], 1, "inbound", recordingIdToNewStartPosition);
        ReplayIndexPositionScanner.printFiles(args[0], 2, "outbound", recordingIdToNewStartPosition);
        System.out.println("Aggregated recordingIdToNewStartPosition = " + recordingIdToNewStartPosition);
    }

    private static void printFiles(String logFilePath, int streamId, String direction, Long2LongHashMap aggregateRecordingIdToNewStartPosition) {
        File logFileDir = new File(logFilePath);
        System.out.println("Scanning: " + direction);
        long[] maxPosition = new long[]{0L};
        ReplayIndexDescriptor.listReplayIndexSessionIds((File)logFileDir, (int)streamId).stream().sorted().forEach(sessionId -> {
            File file = ReplayIndexDescriptor.replayIndexFile((String)logFilePath, (long)sessionId, (int)streamId);
            ReplayIndexExtractor.StartPositionExtractor positionExtractor = new ReplayIndexExtractor.StartPositionExtractor();
            ReplayIndexExtractor.extract((File)file, (ReplayIndexExtractor.ReplayIndexHandler)positionExtractor);
            System.out.println("file = " + file);
            System.out.println("positionExtractor.highestSequenceIndex() = " + positionExtractor.highestSequenceIndex());
            Long2LongHashMap recordingIdToStartPosition = positionExtractor.recordingIdToStartPosition();
            System.out.println("positionExtractor.recordingIdToStartPosition() = " + recordingIdToStartPosition);
            ReplayQuery.aggregateLowerPosition((Long2LongHashMap)recordingIdToStartPosition, (Long2LongHashMap)aggregateRecordingIdToNewStartPosition);
            ReplayIndexExtractor.BoundaryPositionExtractor boundaryPositionExtractor = new ReplayIndexExtractor.BoundaryPositionExtractor(false);
            ReplayIndexExtractor.extract((File)file, (ReplayIndexExtractor.ReplayIndexHandler)boundaryPositionExtractor);
            Long2LongHashMap recordingIdToMaxPosition = boundaryPositionExtractor.recordingIdToPosition();
            System.out.println("boundaryPositionExtractor = " + recordingIdToMaxPosition);
            Long2LongHashMap.ValueIterator it = recordingIdToMaxPosition.values().iterator();
            if (it.hasNext()) {
                long position = it.nextValue();
                maxPosition[0] = Math.max(maxPosition[0], position);
            }
            boundaryPositionExtractor.findInconsistentSequenceIndexPositions();
        });
        System.out.println("maxPosition = " + maxPosition[0]);
        System.out.println("\n\n");
    }
}

