/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.engine.logger;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.List;
import org.agrona.LangUtil;
import uk.co.real_logic.artio.engine.logger.ReplayIndexExtractor;
import uk.co.real_logic.artio.storage.messages.ReplayIndexRecordDecoder;

public final class ReplayIndexDumper {
    public static void main(String[] args) throws IOException {
        File file = new File(args[0]);
        String output = "replay-index-dump.csv";
        try (final BufferedWriter out = new BufferedWriter(new FileWriter("replay-index-dump.csv"));){
            out.write("beginPosition,sequenceIndex,sequenceNumber,recordingId,readLength\n");
            ReplayIndexExtractor.extract((File)file, (ReplayIndexExtractor.ReplayIndexHandler)new ReplayIndexExtractor.ReplayIndexHandler(){

                public void onEntry(ReplayIndexRecordDecoder indexRecord) {
                    long beginPosition = indexRecord.position();
                    int sequenceIndex = indexRecord.sequenceIndex();
                    int sequenceNumber = indexRecord.sequenceNumber();
                    long recordingId = indexRecord.recordingId();
                    int readLength = indexRecord.length();
                    try {
                        out.write(beginPosition + "," + sequenceIndex + "," + sequenceNumber + "," + recordingId + "," + readLength + "\n");
                    }
                    catch (IOException e) {
                        LangUtil.rethrowUnchecked((Throwable)e);
                    }
                }

                public void onLapped() {
                    System.err.println("Error: lapped by writer currently updating the file");
                }
            });
        }
        ReplayIndexExtractor.ReplayIndexValidator validator = new ReplayIndexExtractor.ReplayIndexValidator();
        ReplayIndexExtractor.extract((File)file, (ReplayIndexExtractor.ReplayIndexHandler)validator);
        List errors = validator.errors();
        errors.forEach(System.err::println);
    }
}

