/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.stress;

import io.aeron.archive.Archive;
import io.aeron.archive.ArchiveThreadingMode;
import io.aeron.archive.ArchivingMediaDriver;
import io.aeron.driver.MediaDriver;
import io.aeron.driver.ThreadingMode;
import java.util.Collections;
import org.agrona.ErrorHandler;
import org.agrona.concurrent.Agent;
import org.agrona.concurrent.AgentRunner;
import org.agrona.concurrent.IdleStrategy;
import uk.co.real_logic.artio.SampleUtil;
import uk.co.real_logic.artio.engine.EngineConfiguration;
import uk.co.real_logic.artio.engine.FixEngine;
import uk.co.real_logic.artio.library.AcquiringSessionExistsHandler;
import uk.co.real_logic.artio.library.FixLibrary;
import uk.co.real_logic.artio.library.LibraryConfiguration;
import uk.co.real_logic.artio.library.SessionExistsHandler;
import uk.co.real_logic.artio.stress.StressConfiguration;
import uk.co.real_logic.artio.stress.StressSessionHandler;
import uk.co.real_logic.artio.stress.StressUtil;
import uk.co.real_logic.artio.validation.AuthenticationStrategy;
import uk.co.real_logic.artio.validation.SessionPersistenceStrategy;

public class Server
implements Agent {
    private final ArchivingMediaDriver mediaDriver;
    private final FixEngine fixEngine;
    private final FixLibrary fixLibrary;

    public Server() {
        AuthenticationStrategy authenticationStrategy = logon -> true;
        String aeronChannel = "aeron:udp?endpoint=localhost:10000";
        EngineConfiguration configuration = new EngineConfiguration().bindTo("localhost", StressConfiguration.PORT).logFileDir("stress-server-logs").libraryAeronChannel("aeron:udp?endpoint=localhost:10000").sessionPersistenceStrategy(SessionPersistenceStrategy.alwaysPersistent());
        configuration.authenticationStrategy(authenticationStrategy).agentNamePrefix("server-");
        System.out.println("Server Logs at " + configuration.logFileDir());
        StressUtil.cleanupOldLogFileDir(configuration);
        MediaDriver.Context context = new MediaDriver.Context().threadingMode(ThreadingMode.SHARED).dirDeleteOnStart(true);
        Archive.Context archiveContext = new Archive.Context().threadingMode(ArchiveThreadingMode.SHARED).deleteArchiveOnStart(true);
        this.mediaDriver = ArchivingMediaDriver.launch((MediaDriver.Context)context, (Archive.Context)archiveContext);
        this.fixEngine = FixEngine.launch((EngineConfiguration)configuration);
        LibraryConfiguration libraryConfiguration = new LibraryConfiguration();
        libraryConfiguration.agentNamePrefix("server-");
        this.fixLibrary = SampleUtil.blockingConnect(libraryConfiguration.sessionAcquireHandler((session, acquiredInfo) -> new StressSessionHandler(session)).sessionExistsHandler((SessionExistsHandler)new AcquiringSessionExistsHandler(true)).libraryAeronChannels(Collections.singletonList("aeron:udp?endpoint=localhost:10000")));
    }

    public static AgentRunner createServer(IdleStrategy idleStrategy, ErrorHandler errorHandler) {
        return new AgentRunner(idleStrategy, errorHandler, null, (Agent)new Server());
    }

    public int doWork() {
        return this.fixLibrary.poll(1);
    }

    public String roleName() {
        return "stress server";
    }

    public void onClose() {
        this.fixLibrary.close();
        this.fixEngine.close();
        this.mediaDriver.close();
    }
}

