/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.admin;

import uk.co.real_logic.artio.engine.EngineConfiguration;
import uk.co.real_logic.artio.engine.MappedFile;
import uk.co.real_logic.artio.engine.logger.SequenceNumberIndexReader;

public final class EngineIndexPrinter {
    public static void main(String[] args) {
        for (String engineLogDir : args) {
            int sequenceNumber;
            EngineConfiguration engineConfiguration = new EngineConfiguration().logFileDir(engineLogDir).libraryAeronChannel("").conclude();
            MappedFile receivedSequenceNumberIndex = engineConfiguration.receivedSequenceNumberIndex();
            System.out.printf("Inspecting %s%n", receivedSequenceNumberIndex.file().getAbsolutePath());
            SequenceNumberIndexReader reader = new SequenceNumberIndexReader(receivedSequenceNumberIndex.buffer(), Throwable::printStackTrace, null, null);
            for (long sessionId = 0L; sessionId < Long.MAX_VALUE && (sequenceNumber = reader.lastKnownSequenceNumber(sessionId)) != -1; ++sessionId) {
                System.out.printf("Last seen sequence number for %d is %d%n", sessionId, sequenceNumber);
            }
        }
    }
}

