/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.example_exchange;

import io.aeron.logbuffer.ControlledFragmentHandler;
import java.nio.charset.StandardCharsets;
import org.agrona.DirectBuffer;
import org.agrona.concurrent.UnsafeBuffer;
import uk.co.real_logic.artio.ExecType;
import uk.co.real_logic.artio.OrdStatus;
import uk.co.real_logic.artio.OrdType;
import uk.co.real_logic.artio.Pressure;
import uk.co.real_logic.artio.Side;
import uk.co.real_logic.artio.builder.Encoder;
import uk.co.real_logic.artio.builder.ExecutionReportEncoder;
import uk.co.real_logic.artio.decoder.NewOrderSingleDecoder;
import uk.co.real_logic.artio.dictionary.generation.CodecUtil;
import uk.co.real_logic.artio.fields.DecimalFloat;
import uk.co.real_logic.artio.library.OnMessageInfo;
import uk.co.real_logic.artio.library.SessionHandler;
import uk.co.real_logic.artio.messages.DisconnectReason;
import uk.co.real_logic.artio.session.Session;
import uk.co.real_logic.artio.util.AsciiBuffer;
import uk.co.real_logic.artio.util.MutableAsciiBuffer;

public class ExchangeSessionHandler
implements SessionHandler {
    private static final DecimalFloat MINIMUM_PRICE = new DecimalFloat().fromLong(100L);
    private static final char[] VALID_SYMBOL = "MSFT".toCharArray();
    private static final byte[] SYMBOL_BYTES = "MSFT".getBytes(StandardCharsets.US_ASCII);
    private static final int SIZE_OF_ASCII_LONG = String.valueOf(Long.MAX_VALUE).length();
    private static final byte[] EXEC_ID_BUFFER = new byte[SIZE_OF_ASCII_LONG];
    private static int execIdEncodedLength;
    private static final UnsafeBuffer EXEC_ID_ENCODER;
    private static long execId;
    private static final byte[] ORDER_ID_BUFFER;
    private static int orderIdEncodedLength;
    private static final UnsafeBuffer ORDER_ID_ENCODER;
    private long orderId = 0L;
    private final NewOrderSingleDecoder newOrderSingle = new NewOrderSingleDecoder();
    private final ExecutionReportEncoder executionReport = new ExecutionReportEncoder();
    private final MutableAsciiBuffer asciiBuffer = new MutableAsciiBuffer();

    ExchangeSessionHandler(Session session) {
    }

    public ControlledFragmentHandler.Action onMessage(DirectBuffer buffer, int offset, int length, int libraryId, Session session, int sequenceIndex, long messageType, long timestampInNs, long position, OnMessageInfo messageInfo) {
        this.asciiBuffer.wrap(buffer, offset, length);
        if (messageType == 68L) {
            this.newOrderSingle.decode((AsciiBuffer)this.asciiBuffer, 0, length);
            if (!this.validOrder()) {
                return this.cancelOrder(session);
            }
            return this.fillOrder(session);
        }
        return ControlledFragmentHandler.Action.CONTINUE;
    }

    private ControlledFragmentHandler.Action cancelOrder(Session session) {
        Side side = this.newOrderSingle.sideAsEnum();
        this.newOrderId();
        this.newExecId();
        this.executionReport.execType(ExecType.FILL).ordStatus(OrdStatus.FILLED).orderID(ORDER_ID_BUFFER, orderIdEncodedLength).execID(EXEC_ID_BUFFER, execIdEncodedLength).side(side);
        this.executionReport.instrument().symbol(this.newOrderSingle.symbol(), this.newOrderSingle.symbolLength());
        return Pressure.apply((long)session.send((Encoder)this.executionReport));
    }

    private boolean validOrder() {
        if (!CodecUtil.equals((char[])VALID_SYMBOL, (char[])this.newOrderSingle.symbol(), (int)this.newOrderSingle.symbolLength())) {
            return false;
        }
        OrdType ordType = this.newOrderSingle.ordTypeAsEnum();
        if (ordType != OrdType.MARKET) {
            return false;
        }
        DecimalFloat price = this.newOrderSingle.price();
        return MINIMUM_PRICE.compareTo(price) > 0;
    }

    private ControlledFragmentHandler.Action fillOrder(Session session) {
        Side side = this.newOrderSingle.sideAsEnum();
        this.newOrderId();
        this.newExecId();
        this.executionReport.orderID(ORDER_ID_BUFFER, orderIdEncodedLength).execID(EXEC_ID_BUFFER, execIdEncodedLength).execType(ExecType.FILL).ordStatus(OrdStatus.FILLED).side(side);
        this.executionReport.instrument().symbol(SYMBOL_BYTES);
        long sendPosition = session.send((Encoder)this.executionReport);
        if (Pressure.isBackPressured((long)sendPosition)) {
            --this.orderId;
            --execId;
            return ControlledFragmentHandler.Action.ABORT;
        }
        return ControlledFragmentHandler.Action.CONTINUE;
    }

    private void newExecId() {
        execIdEncodedLength = EXEC_ID_ENCODER.putLongAscii(0, ++execId);
    }

    private void newOrderId() {
        ++this.orderId;
        orderIdEncodedLength = ORDER_ID_ENCODER.putLongAscii(0, this.orderId);
    }

    public void onSessionStart(Session session) {
    }

    public void onTimeout(int libraryId, Session session) {
    }

    public void onSlowStatus(int libraryId, Session session, boolean hasBecomeSlow) {
    }

    public ControlledFragmentHandler.Action onDisconnect(int libraryId, Session session, DisconnectReason reason) {
        return ControlledFragmentHandler.Action.CONTINUE;
    }

    static {
        EXEC_ID_ENCODER = new UnsafeBuffer(EXEC_ID_BUFFER);
        execId = 0L;
        ORDER_ID_BUFFER = new byte[SIZE_OF_ASCII_LONG];
        ORDER_ID_ENCODER = new UnsafeBuffer(ORDER_ID_BUFFER);
    }
}

