/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.example_buyer;

import io.aeron.logbuffer.ControlledFragmentHandler;
import org.agrona.DirectBuffer;
import uk.co.real_logic.artio.OrdType;
import uk.co.real_logic.artio.Pressure;
import uk.co.real_logic.artio.Reply;
import uk.co.real_logic.artio.Side;
import uk.co.real_logic.artio.builder.Encoder;
import uk.co.real_logic.artio.builder.NewOrderSingleEncoder;
import uk.co.real_logic.artio.decoder.ExecutionReportDecoder;
import uk.co.real_logic.artio.fields.DecimalFloat;
import uk.co.real_logic.artio.fields.UtcTimestampEncoder;
import uk.co.real_logic.artio.library.FixLibrary;
import uk.co.real_logic.artio.library.LibraryConnectHandler;
import uk.co.real_logic.artio.library.OnMessageInfo;
import uk.co.real_logic.artio.library.SessionAcquireHandler;
import uk.co.real_logic.artio.library.SessionAcquiredInfo;
import uk.co.real_logic.artio.library.SessionConfiguration;
import uk.co.real_logic.artio.library.SessionHandler;
import uk.co.real_logic.artio.messages.DisconnectReason;
import uk.co.real_logic.artio.session.Session;
import uk.co.real_logic.artio.util.AsciiBuffer;
import uk.co.real_logic.artio.util.MutableAsciiBuffer;

public class Buyer
implements LibraryConnectHandler,
SessionHandler,
SessionAcquireHandler {
    private final MutableAsciiBuffer asciiBuffer = new MutableAsciiBuffer();
    private final NewOrderSingleEncoder newOrderSingle = new NewOrderSingleEncoder();
    private final ExecutionReportDecoder executionReport = new ExecutionReportDecoder();
    private final DecimalFloat price = new DecimalFloat(100L);
    private final DecimalFloat orderQty = new DecimalFloat(2L);
    private final UtcTimestampEncoder transactTime = new UtcTimestampEncoder();
    private State state = State.LIBRARY_DISCONNECTED;
    private FixLibrary library;
    private Reply<Session> initiateReply;
    private Session session;

    public void onConnect(FixLibrary library) {
        System.out.println("Library Connected");
        this.state = State.LIBRARY_CONNECTED;
        this.library = library;
    }

    public void onDisconnect(FixLibrary library) {
        System.out.println("Library Disconnected");
        this.state = State.LIBRARY_DISCONNECTED;
        this.library = null;
    }

    public int poll() {
        this.checkReplies();
        switch (this.state) {
            case LIBRARY_CONNECTED: {
                this.connectSession();
                return 1;
            }
            case SESSION_CONNECTED: {
                this.sendOrder();
                return 1;
            }
        }
        return 0;
    }

    private void checkReplies() {
        if (this.initiateReply != null && !this.initiateReply.isExecuting()) {
            if (this.initiateReply.hasCompleted()) {
                System.out.println("Session Connected");
                this.session = (Session)this.initiateReply.resultIfPresent();
                this.state = State.SESSION_CONNECTED;
            } else {
                System.err.printf("Session connect failed %s%n", this.initiateReply.state());
                Exception error = this.initiateReply.error();
                if (error != null) {
                    error.printStackTrace();
                }
                System.exit(-1);
            }
            this.initiateReply = null;
        }
    }

    private void connectSession() {
        SessionConfiguration sessionConfig = SessionConfiguration.builder().address("localhost", 9999).targetCompId("exexchange").senderCompId("extrader").build();
        this.initiateReply = this.library.initiate(sessionConfig);
        this.state = State.SESSION_CONNECTING;
        System.out.println("Attempting to connect to exchange");
    }

    private void sendOrder() {
        int transactTimeLength = this.transactTime.encode(System.currentTimeMillis());
        this.newOrderSingle.clOrdID((CharSequence)"A").side(Side.BUY).transactTime(this.transactTime.buffer(), transactTimeLength).ordType(OrdType.MARKET).price(this.price);
        this.newOrderSingle.instrument().symbol((CharSequence)"MSFT");
        this.newOrderSingle.orderQtyData().orderQty(this.orderQty);
        long position = this.session.send((Encoder)this.newOrderSingle);
        if (!Pressure.isBackPressured((long)position)) {
            this.state = State.AWAITING_FILL;
        }
    }

    public ControlledFragmentHandler.Action onMessage(DirectBuffer buffer, int offset, int length, int libraryId, Session session, int sequenceIndex, long messageType, long timestampInNs, long position, OnMessageInfo messageInfo) {
        if (messageType == 56L) {
            this.asciiBuffer.wrap(buffer, offset, length);
            System.out.println("Received report: " + this.asciiBuffer.getAscii(0, length));
            this.executionReport.decode((AsciiBuffer)this.asciiBuffer, 0, length);
            System.out.println("Parsed report: " + this.executionReport);
            this.state = State.SESSION_CONNECTED;
        }
        return ControlledFragmentHandler.Action.CONTINUE;
    }

    public void onTimeout(int libraryId, Session session) {
    }

    public void onSlowStatus(int libraryId, Session session, boolean hasBecomeSlow) {
    }

    public ControlledFragmentHandler.Action onDisconnect(int libraryId, Session session, DisconnectReason reason) {
        this.state = State.LIBRARY_CONNECTED;
        return ControlledFragmentHandler.Action.CONTINUE;
    }

    public void onSessionStart(Session session) {
    }

    public SessionHandler onSessionAcquired(Session session, SessionAcquiredInfo isSlow) {
        return this;
    }

    private static enum State {
        LIBRARY_DISCONNECTED,
        LIBRARY_CONNECTED,
        SESSION_CONNECTING,
        SESSION_CONNECTED,
        AWAITING_FILL;

    }
}

