/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.stress;

import java.io.IOException;
import java.util.Collections;
import uk.co.real_logic.artio.SampleUtil;
import uk.co.real_logic.artio.library.FixLibrary;
import uk.co.real_logic.artio.library.LibraryConfiguration;

public final class ConstantlyRestartingLibrary {
    public static void main(String[] args) throws IOException {
        while (true) {
            LibraryConfiguration libraryConfiguration = new LibraryConfiguration().libraryAeronChannels(Collections.singletonList("aeron:udp?endpoint=localhost:10000"));
            libraryConfiguration.replyTimeoutInMs(1000L);
            FixLibrary library = SampleUtil.blockingConnect(libraryConfiguration);
            Throwable throwable = null;
            try {
                while (library.isConnected()) {
                    try {
                        Thread.sleep(libraryConfiguration.replyTimeoutInMs() * 2L);
                    }
                    catch (InterruptedException ex) {
                        ex.printStackTrace();
                    }
                    System.out.println("Finishing sleeping");
                    library.poll(1);
                }
                System.out.println("Disconnected: " + !library.isConnected());
                while (!library.isConnected()) {
                    library.poll(1);
                }
                System.out.println("Reconnected");
                System.out.println();
                System.out.println();
                continue;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (library == null) continue;
                if (throwable != null) {
                    try {
                        library.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                library.close();
                continue;
            }
            break;
        }
    }
}

