/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.reproduction;

import io.aeron.logbuffer.ControlledFragmentHandler;
import java.time.LocalDate;
import java.time.temporal.ChronoUnit;
import org.agrona.DirectBuffer;
import org.agrona.concurrent.EpochClock;
import org.agrona.concurrent.SystemEpochClock;
import uk.co.real_logic.artio.builder.Encoder;
import uk.co.real_logic.artio.builder.ExecutionReportEncoder;
import uk.co.real_logic.artio.builder.Printer;
import uk.co.real_logic.artio.decoder.NewOrderSingleDecoder;
import uk.co.real_logic.artio.decoder.PrinterImpl;
import uk.co.real_logic.artio.fields.DecimalFloat;
import uk.co.real_logic.artio.fields.UtcDateOnlyEncoder;
import uk.co.real_logic.artio.fields.UtcTimestampEncoder;
import uk.co.real_logic.artio.library.SessionHandler;
import uk.co.real_logic.artio.messages.DisconnectReason;
import uk.co.real_logic.artio.session.Session;
import uk.co.real_logic.artio.util.AsciiBuffer;
import uk.co.real_logic.artio.util.MutableAsciiBuffer;

public class SampleSessionHandler
implements SessionHandler {
    private final AsciiBuffer string = new MutableAsciiBuffer();
    private final Printer printer = new PrinterImpl();
    private final NewOrderSingleDecoder order = new NewOrderSingleDecoder();
    private final ExecutionReportEncoder ack = new ExecutionReportEncoder();
    private final ExecutionReportEncoder fill = new ExecutionReportEncoder();
    private final AsciiBuffer asciiBuffer = new MutableAsciiBuffer();
    private final DecimalFloat zero = new DecimalFloat(0L, 0);
    private final UtcTimestampEncoder timestampEncoder = new UtcTimestampEncoder();
    private final UtcDateOnlyEncoder dateOnlyEncoder = new UtcDateOnlyEncoder();
    private final byte[] dateOnlyBuffer = new byte[8];
    private final EpochClock clock = new SystemEpochClock();
    int execId = 1;

    public SampleSessionHandler(Session session) {
        this.dateOnlyEncoder.encode((int)this.getEpochDay(), this.dateOnlyBuffer);
    }

    public long getEpochDay() {
        LocalDate now = LocalDate.now();
        LocalDate epoch = LocalDate.ofEpochDay(0L);
        return ChronoUnit.DAYS.between(epoch, now);
    }

    public ControlledFragmentHandler.Action onMessage(DirectBuffer buffer, int offset, int length, int libraryId, Session session, int sequenceIndex, int messageType, long timestampInNs, long position) {
        if (messageType == 68) {
            this.asciiBuffer.wrap(buffer, offset, length);
            this.order.decode(this.asciiBuffer, 0, length);
            this.ack.execID((CharSequence)(this.order.clOrdIDAsString() + '-' + this.execId++));
            this.ack.orderID(this.order.clOrdID());
            this.ack.ordStatus('0');
            this.ack.side(this.order.side());
            this.ack.execType('0');
            session.send((Encoder)this.ack);
            this.fill.execID((CharSequence)(this.order.clOrdIDAsString() + '-' + this.execId++));
            this.fill.orderID(this.order.clOrdID());
            this.fill.ordStatus('2');
            this.fill.side(this.order.side());
            this.fill.execType('2');
            session.send((Encoder)this.fill);
        }
        return ControlledFragmentHandler.Action.CONTINUE;
    }

    public void onTimeout(int libraryId, Session session) {
        System.out.println("time out");
    }

    public void onSlowStatus(int libraryId, Session session, boolean hasBecomeSlow) {
    }

    public ControlledFragmentHandler.Action onDisconnect(int libraryId, Session session, DisconnectReason reason) {
        System.out.printf("%d Disconnected: %s%n", session.id(), reason);
        return ControlledFragmentHandler.Action.CONTINUE;
    }

    public void onSessionStart(Session session) {
        System.out.println("session started");
    }
}

