/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.message_examples;

import java.util.Collections;
import uk.co.real_logic.artio.Reply;
import uk.co.real_logic.artio.SampleUtil;
import uk.co.real_logic.artio.builder.Encoder;
import uk.co.real_logic.artio.builder.OrdType;
import uk.co.real_logic.artio.builder.OrderSingleEncoder;
import uk.co.real_logic.artio.builder.Side;
import uk.co.real_logic.artio.engine.EngineConfiguration;
import uk.co.real_logic.artio.engine.FixEngine;
import uk.co.real_logic.artio.fields.DecimalFloat;
import uk.co.real_logic.artio.library.FixLibrary;
import uk.co.real_logic.artio.library.LibraryConfiguration;
import uk.co.real_logic.artio.library.SessionConfiguration;
import uk.co.real_logic.artio.session.Session;
import uk.co.real_logic.artio.validation.AuthenticationStrategy;
import uk.co.real_logic.artio.validation.MessageValidationStrategy;

public final class MessageApiExamples {
    public static final String TARGET_COMP_ID = "targetCompId";
    public static final String SENDER_COMP_ID = "senderCompId";
    public static final String AERON_CHANNEL = "ipc:9999";

    public static void main(String[] args) throws Exception {
        EngineConfiguration configuration = new EngineConfiguration().libraryAeronChannel(AERON_CHANNEL);
        MessageValidationStrategy validationStrategy = MessageValidationStrategy.targetCompId((String)TARGET_COMP_ID).and(MessageValidationStrategy.senderCompId(Collections.singletonList(SENDER_COMP_ID)));
        AuthenticationStrategy authenticationStrategy = AuthenticationStrategy.of((MessageValidationStrategy)validationStrategy);
        configuration.messageValidationStrategy(validationStrategy).authenticationStrategy(authenticationStrategy);
        try (FixEngine ignore = FixEngine.launch((EngineConfiguration)configuration);){
            LibraryConfiguration libraryConfiguration = new LibraryConfiguration();
            libraryConfiguration.libraryAeronChannels(Collections.singletonList(AERON_CHANNEL)).messageValidationStrategy(validationStrategy).authenticationStrategy(authenticationStrategy);
            try (FixLibrary library = SampleUtil.blockingConnect(libraryConfiguration);){
                SessionConfiguration sessionConfig = SessionConfiguration.builder().address("broker.example.com", 9999).credentials("username", "password").senderCompId(SENDER_COMP_ID).targetCompId(TARGET_COMP_ID).build();
                Reply reply = library.initiate(sessionConfig);
                while (reply.isExecuting()) {
                    library.poll(1);
                }
                if (!reply.hasCompleted()) {
                    System.err.println("Unable to initiate the session, " + reply.state() + " " + reply.error());
                    System.exit(-1);
                }
                Session session = (Session)reply.resultIfPresent();
                DecimalFloat price = new DecimalFloat(2000L, 2);
                DecimalFloat quantity = new DecimalFloat(10L, 0);
                OrderSingleEncoder orderSingle = new OrderSingleEncoder();
                orderSingle.clOrdID("1").handlInst('1').ordType(OrdType.Market).side(Side.Sell).symbol("MSFT").price(price).orderQty(quantity).transactTime(System.currentTimeMillis());
                session.send((Encoder)orderSingle);
                orderSingle.price(price.set(2010L, 2)).orderQty(quantity.set(20L, 0));
                session.send((Encoder)orderSingle);
                orderSingle.price(price.set(2020L, 2)).orderQty(quantity.set(30L, 0));
                session.send((Encoder)orderSingle);
            }
        }
    }
}

