/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.message_examples;

import uk.co.real_logic.artio.ValidationError;
import uk.co.real_logic.artio.fields.AsciiFieldFlyweight;
import uk.co.real_logic.artio.otf.MessageControl;
import uk.co.real_logic.artio.otf.OtfMessageAcceptor;
import uk.co.real_logic.artio.util.AsciiBuffer;

public class SampleOtfAcceptor
implements OtfMessageAcceptor {
    private boolean wantsToSell;
    private String symbol;

    public MessageControl onNext() {
        System.out.println("a NewOrderSingle has arrived");
        return MessageControl.CONTINUE;
    }

    public MessageControl onField(int tag, AsciiBuffer buffer, int offset, int length) {
        switch (tag) {
            case 54: {
                this.wantsToSell = buffer.getByte(offset) == 50;
                break;
            }
            case 55: {
                this.symbol = buffer.getStringUtf8(offset, length);
            }
        }
        return MessageControl.CONTINUE;
    }

    public MessageControl onGroupHeader(int tag, int numInGroup) {
        return MessageControl.CONTINUE;
    }

    public MessageControl onGroupBegin(int tag, int numInGroup, int index) {
        return MessageControl.CONTINUE;
    }

    public MessageControl onGroupEnd(int tag, int numInGroup, int index) {
        return MessageControl.CONTINUE;
    }

    public MessageControl onComplete() {
        if (this.wantsToSell && "USD".equals(this.symbol)) {
            System.out.println("Our client wants to sell dollars");
        }
        return MessageControl.CONTINUE;
    }

    public boolean onError(ValidationError error, int messageType, int tagNumber, AsciiFieldFlyweight value) {
        return false;
    }
}

