/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.client;

import java.io.File;
import java.util.Collections;
import org.agrona.concurrent.IdleStrategy;
import org.agrona.concurrent.SleepingIdleStrategy;
import uk.co.real_logic.artio.CommonConfiguration;
import uk.co.real_logic.artio.SampleUtil;
import uk.co.real_logic.artio.builder.Encoder;
import uk.co.real_logic.artio.builder.TestRequestEncoder;
import uk.co.real_logic.artio.client.TestReqIdFinder;
import uk.co.real_logic.artio.engine.EngineConfiguration;
import uk.co.real_logic.artio.engine.FixEngine;
import uk.co.real_logic.artio.library.FixLibrary;
import uk.co.real_logic.artio.library.LibraryConfiguration;
import uk.co.real_logic.artio.library.LibraryUtil;
import uk.co.real_logic.artio.library.SessionConfiguration;
import uk.co.real_logic.artio.library.SessionHandler;
import uk.co.real_logic.artio.messages.SessionState;
import uk.co.real_logic.artio.server.SampleServer;
import uk.co.real_logic.artio.session.Session;

public final class SampleClient {
    private static final TestReqIdFinder TEST_REQ_ID_FINDER = new TestReqIdFinder();

    public static void main(String[] args) {
        String aeronChannel = "aeron:udp?endpoint=localhost:10002";
        EngineConfiguration configuration = new EngineConfiguration().libraryAeronChannel("aeron:udp?endpoint=localhost:10002").monitoringFile(CommonConfiguration.optimalTmpDirName() + File.separator + "fix-client" + File.separator + "engineCounters").logFileDir("client-logs");
        SampleServer.cleanupOldLogFileDir(configuration);
        try (FixEngine ignore = FixEngine.launch((EngineConfiguration)configuration);){
            SessionConfiguration sessionConfig = SessionConfiguration.builder().address("localhost", 9999).targetCompId("acceptor").senderCompId("initiator").build();
            SleepingIdleStrategy idleStrategy = new SleepingIdleStrategy(100L);
            try (FixLibrary library = SampleUtil.blockingConnect(new LibraryConfiguration().sessionAcquireHandler(SampleClient::onConnect).libraryAeronChannels(Collections.singletonList("aeron:udp?endpoint=localhost:10002")));){
                Session session = LibraryUtil.initiate((FixLibrary)library, (SessionConfiguration)sessionConfig, (int)10000, (IdleStrategy)idleStrategy);
                while (!session.canSendMessage()) {
                    idleStrategy.idle(library.poll(1));
                }
                TestRequestEncoder testRequest = new TestRequestEncoder();
                testRequest.testReqID((CharSequence)"Hello World");
                session.send((Encoder)testRequest);
                while (!"Hello World".equals(TEST_REQ_ID_FINDER.testReqId())) {
                    idleStrategy.idle(library.poll(1));
                }
                System.out.println("Success, received reply!");
                System.out.println(TEST_REQ_ID_FINDER.testReqId());
                session.startLogout();
                session.requestDisconnect();
                while (session.state() != SessionState.DISCONNECTED) {
                    idleStrategy.idle(library.poll(1));
                }
                System.out.println("Disconnected");
            }
        }
        System.exit(0);
    }

    private static SessionHandler onConnect(Session session, boolean isSlow) {
        return TEST_REQ_ID_FINDER;
    }
}

