/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.message_examples;

import java.util.Collections;
import uk.co.real_logic.artio.OrdType;
import uk.co.real_logic.artio.Reply;
import uk.co.real_logic.artio.SampleUtil;
import uk.co.real_logic.artio.Side;
import uk.co.real_logic.artio.builder.Encoder;
import uk.co.real_logic.artio.builder.NewOrderSingleEncoder;
import uk.co.real_logic.artio.engine.EngineConfiguration;
import uk.co.real_logic.artio.engine.FixEngine;
import uk.co.real_logic.artio.fields.DecimalFloat;
import uk.co.real_logic.artio.fields.ReadOnlyDecimalFloat;
import uk.co.real_logic.artio.fields.UtcTimestampEncoder;
import uk.co.real_logic.artio.library.FixLibrary;
import uk.co.real_logic.artio.library.LibraryConfiguration;
import uk.co.real_logic.artio.library.SessionConfiguration;
import uk.co.real_logic.artio.session.Session;
import uk.co.real_logic.artio.validation.AuthenticationStrategy;
import uk.co.real_logic.artio.validation.MessageValidationStrategy;

public final class MessageApiExamples {
    public static final String TARGET_COMP_ID = "targetCompId";
    public static final String SENDER_COMP_ID = "senderCompId";
    public static final String AERON_CHANNEL = "ipc:9999";

    public static void main(String[] args) {
        EngineConfiguration configuration = new EngineConfiguration().libraryAeronChannel(AERON_CHANNEL);
        MessageValidationStrategy validationStrategy = MessageValidationStrategy.targetCompId((String)TARGET_COMP_ID).and(MessageValidationStrategy.senderCompId(Collections.singletonList(SENDER_COMP_ID)));
        AuthenticationStrategy authenticationStrategy = AuthenticationStrategy.of((MessageValidationStrategy)validationStrategy);
        configuration.authenticationStrategy(authenticationStrategy).messageValidationStrategy(validationStrategy);
        try (FixEngine ignore = FixEngine.launch((EngineConfiguration)configuration);){
            LibraryConfiguration libraryConfiguration = new LibraryConfiguration();
            libraryConfiguration.libraryAeronChannels(Collections.singletonList(AERON_CHANNEL)).messageValidationStrategy(validationStrategy);
            try (FixLibrary library = SampleUtil.blockingConnect(libraryConfiguration);){
                SessionConfiguration sessionConfig = SessionConfiguration.builder().address("broker.example.com", 9999).credentials("username", "password").senderCompId(SENDER_COMP_ID).targetCompId(TARGET_COMP_ID).build();
                Reply reply = library.initiate(sessionConfig);
                while (reply.isExecuting()) {
                    library.poll(1);
                }
                if (!reply.hasCompleted()) {
                    System.err.println("Unable to initiate the session, " + String.valueOf(reply.state()) + " " + String.valueOf(reply.error()));
                    System.exit(-1);
                }
                Session session = (Session)reply.resultIfPresent();
                DecimalFloat price = new DecimalFloat(2000L, 2);
                UtcTimestampEncoder transactTime = new UtcTimestampEncoder();
                int transactTimeLength = transactTime.encode(System.currentTimeMillis());
                NewOrderSingleEncoder orderSingle = new NewOrderSingleEncoder();
                orderSingle.clOrdID((CharSequence)"1").side(Side.BUY).transactTime(transactTime.buffer(), transactTimeLength).ordType(OrdType.MARKET).price((ReadOnlyDecimalFloat)price);
                long position = session.trySend((Encoder)orderSingle);
                if (position < 0L) {
                    // empty if block
                }
                orderSingle.price((ReadOnlyDecimalFloat)price.set(2010L, 2));
                session.trySend((Encoder)orderSingle);
                orderSingle.price((ReadOnlyDecimalFloat)price.set(2020L, 2));
                session.trySend((Encoder)orderSingle);
            }
        }
    }
}

