/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.stress;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Random;
import org.agrona.IoUtil;
import org.agrona.concurrent.IdleStrategy;
import uk.co.real_logic.artio.CommonConfiguration;
import uk.co.real_logic.artio.builder.Encoder;
import uk.co.real_logic.artio.builder.TestRequestEncoder;
import uk.co.real_logic.artio.client.TestReqIdFinder;
import uk.co.real_logic.artio.engine.EngineConfiguration;
import uk.co.real_logic.artio.library.FixLibrary;
import uk.co.real_logic.artio.session.Session;
import uk.co.real_logic.artio.stress.StressConfiguration;

final class StressUtil {
    StressUtil() {
    }

    static String[] constructMessagePool(String prefix, Random random) {
        String[] pool = new String[StressConfiguration.MESSAGE_POOL];
        byte[] messageContent = new byte[StressConfiguration.MAX_LENGTH + 1];
        Arrays.fill(messageContent, (byte)88);
        for (int i = 0; i < pool.length; ++i) {
            int messageLength = StressConfiguration.MIN_LENGTH + random.nextInt(StressConfiguration.MAX_LENGTH - StressConfiguration.MIN_LENGTH + 1);
            pool[i] = String.format("%sTestReqId-%d-%s", prefix, i, new String(messageContent, 0, messageLength));
        }
        return pool;
    }

    static void exchangeMessages(FixLibrary library, Session session, IdleStrategy idleStrategy, TestReqIdFinder testReqIdFinder, String[] messagePool, Random random, String senderCompId) {
        TestRequestEncoder testRequest = new TestRequestEncoder();
        for (int j = 0; j < StressConfiguration.MESSAGES_EXCHANGED; ++j) {
            if (!StressConfiguration.PRINT_EXCHANGE) {
                System.out.format("\rMessage %d", j);
            }
            String msg = messagePool[random.nextInt(messagePool.length)];
            testRequest.testReqID((CharSequence)msg);
            while (session.trySend((Encoder)testRequest) < 0L) {
                idleStrategy.idle(library.poll(1));
            }
            long fails = 0L;
            while (!msg.equals(testReqIdFinder.testReqId())) {
                if (StressConfiguration.printFailedSpints(fails)) {
                    System.out.println(senderCompId + " Has repeatedly failed for " + msg);
                    fails = 0L;
                }
                idleStrategy.idle(library.poll(1));
                ++fails;
            }
            if (!StressConfiguration.PRINT_EXCHANGE) continue;
            System.out.println(senderCompId + " Success, received reply! " + msg);
        }
        if (!StressConfiguration.PRINT_EXCHANGE) {
            System.out.format("\r", new Object[0]);
        }
    }

    static void cleanupOldLogFileDir(EngineConfiguration configuration) {
        IoUtil.delete((File)new File(configuration.logFileDir()), (boolean)true);
        File tmpDir = new File(CommonConfiguration.optimalTmpDirName());
        for (File file2 : tmpDir.listFiles(file -> file.getName().contains("fix-library-"))) {
            IoUtil.delete((File)file2, (boolean)false);
        }
    }

    static void awaitKeyPress() {
        System.out.println("Press any key to exit");
        try {
            System.in.read();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }
}

