/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.server;

import io.aeron.archive.Archive;
import io.aeron.archive.ArchiveThreadingMode;
import io.aeron.archive.ArchivingMediaDriver;
import io.aeron.driver.MediaDriver;
import io.aeron.driver.ThreadingMode;
import java.io.File;
import java.util.Collections;
import java.util.concurrent.atomic.AtomicBoolean;
import org.agrona.IoUtil;
import org.agrona.concurrent.IdleStrategy;
import org.agrona.concurrent.SigInt;
import uk.co.real_logic.artio.CommonConfiguration;
import uk.co.real_logic.artio.SampleUtil;
import uk.co.real_logic.artio.engine.EngineConfiguration;
import uk.co.real_logic.artio.engine.FixEngine;
import uk.co.real_logic.artio.library.AcquiringSessionExistsHandler;
import uk.co.real_logic.artio.library.FixLibrary;
import uk.co.real_logic.artio.library.LibraryConfiguration;
import uk.co.real_logic.artio.library.SessionExistsHandler;
import uk.co.real_logic.artio.library.SessionHandler;
import uk.co.real_logic.artio.messages.SessionState;
import uk.co.real_logic.artio.server.SampleSessionHandler;
import uk.co.real_logic.artio.session.Session;
import uk.co.real_logic.artio.validation.AuthenticationStrategy;
import uk.co.real_logic.artio.validation.MessageValidationStrategy;

public final class SampleServer {
    public static final String ACCEPTOR_COMP_ID = "acceptor";
    public static final String INITIATOR_COMP_ID = "initiator";
    private static Session session;
    private static final String CONTROL_REQUEST_CHANNEL = "aeron:udp?endpoint=localhost:8010";
    private static final String CONTROL_RESPONSE_CHANNEL = "aeron:udp?endpoint=localhost:8020";
    private static final String REPLICATION_CHANNEL = "aeron:udp?endpoint=localhost:0";

    public static void main(String[] args) {
        MessageValidationStrategy validationStrategy = MessageValidationStrategy.targetCompId((String)ACCEPTOR_COMP_ID).and(MessageValidationStrategy.senderCompId(Collections.singletonList(INITIATOR_COMP_ID)));
        AuthenticationStrategy authenticationStrategy = AuthenticationStrategy.of((MessageValidationStrategy)validationStrategy);
        String aeronChannel = "aeron:udp?endpoint=localhost:10000";
        EngineConfiguration configuration = new EngineConfiguration().bindTo("localhost", 9999).libraryAeronChannel("aeron:udp?endpoint=localhost:10000");
        configuration.authenticationStrategy(authenticationStrategy);
        configuration.aeronArchiveContext().controlRequestChannel(CONTROL_REQUEST_CHANNEL).controlResponseChannel(CONTROL_RESPONSE_CHANNEL);
        SampleServer.cleanupOldLogFileDir(configuration);
        MediaDriver.Context context = new MediaDriver.Context().threadingMode(ThreadingMode.SHARED).dirDeleteOnStart(true);
        Archive.Context archiveContext = new Archive.Context().threadingMode(ArchiveThreadingMode.SHARED).controlChannel(CONTROL_REQUEST_CHANNEL).replicationChannel(REPLICATION_CHANNEL).deleteArchiveOnStart(true);
        try (ArchivingMediaDriver driver = ArchivingMediaDriver.launch((MediaDriver.Context)context, (Archive.Context)archiveContext);
             FixEngine gateway = FixEngine.launch((EngineConfiguration)configuration);){
            LibraryConfiguration libraryConfiguration = new LibraryConfiguration();
            libraryConfiguration.sessionAcquireHandler((session, acquiredInfo) -> SampleServer.onConnect(session)).sessionExistsHandler((SessionExistsHandler)new AcquiringSessionExistsHandler()).libraryAeronChannels(Collections.singletonList("aeron:udp?endpoint=localhost:10000"));
            IdleStrategy idleStrategy = CommonConfiguration.backoffIdleStrategy();
            try (FixLibrary library = SampleUtil.blockingConnect(libraryConfiguration);){
                AtomicBoolean running = new AtomicBoolean(true);
                SigInt.register(() -> running.set(false));
                while (running.get()) {
                    idleStrategy.idle(library.poll(1));
                    if (SampleServer.session == null || SampleServer.session.state() != SessionState.DISCONNECTED) continue;
                    break;
                }
            }
        }
        System.exit(0);
    }

    public static void cleanupOldLogFileDir(EngineConfiguration configuration) {
        IoUtil.delete((File)new File(configuration.logFileDir()), (boolean)true);
    }

    private static SessionHandler onConnect(Session session) {
        SampleServer.session = session;
        return new SampleSessionHandler(session);
    }
}

