/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.example_fixp_exchange;

import io.aeron.archive.Archive;
import io.aeron.archive.ArchiveThreadingMode;
import io.aeron.archive.ArchivingMediaDriver;
import io.aeron.driver.MediaDriver;
import io.aeron.driver.ThreadingMode;
import java.io.File;
import org.agrona.IoUtil;
import uk.co.real_logic.artio.CommonConfiguration;
import uk.co.real_logic.artio.SampleUtil;
import uk.co.real_logic.artio.engine.EngineConfiguration;
import uk.co.real_logic.artio.engine.FixEngine;
import uk.co.real_logic.artio.example_fixp_exchange.FixPExchangeAgent;
import uk.co.real_logic.artio.messages.FixPProtocolType;

public final class FixPExchangeApplication {
    public static void main(String[] args) throws Exception {
        System.setProperty("aeron.archive.control.channel", "aeron:udp?endpoint=localhost:10010");
        System.setProperty("aeron.archive.control.response.channel", "aeron:udp?endpoint=localhost:10020");
        System.setProperty("aeron.archive.replication.channel", "aeron:udp?endpoint=localhost:0");
        EngineConfiguration configuration = new EngineConfiguration().bindTo("localhost", 9999).libraryAeronChannel("aeron:ipc").logFileDir("exchange-application").acceptFixPProtocol(FixPProtocolType.BINARY_ENTRYPOINT).fixPAuthenticationStrategy((context, authProxy) -> {
            System.out.println("Request to authenticate: " + context);
            authProxy.accept();
        });
        FixPExchangeApplication.cleanupOldLogFileDir(configuration);
        MediaDriver.Context context2 = new MediaDriver.Context().threadingMode(ThreadingMode.SHARED).sharedIdleStrategy(CommonConfiguration.backoffIdleStrategy()).dirDeleteOnStart(true);
        Archive.Context archiveContext = new Archive.Context().threadingMode(ArchiveThreadingMode.SHARED).idleStrategySupplier(CommonConfiguration::backoffIdleStrategy).deleteArchiveOnStart(true);
        try (ArchivingMediaDriver driver = ArchivingMediaDriver.launch((MediaDriver.Context)context2, (Archive.Context)archiveContext);
             FixEngine gateway = FixEngine.launch((EngineConfiguration)configuration);){
            SampleUtil.runAgentUntilSignal(new FixPExchangeAgent(), driver.mediaDriver());
        }
        System.exit(0);
    }

    public static void cleanupOldLogFileDir(EngineConfiguration configuration) {
        IoUtil.delete((File)new File(configuration.logFileDir()), (boolean)true);
    }
}

