/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.engine.framer;

import java.io.File;
import uk.co.real_logic.artio.builder.Encoder;
import uk.co.real_logic.artio.builder.HeaderEncoder;
import uk.co.real_logic.artio.decoder.HeaderDecoder;
import uk.co.real_logic.artio.decoder.SessionHeaderDecoder;
import uk.co.real_logic.artio.dictionary.FixDictionary;
import uk.co.real_logic.artio.engine.MappedFile;
import uk.co.real_logic.artio.engine.framer.FixContexts;
import uk.co.real_logic.artio.engine.framer.SessionContext;
import uk.co.real_logic.artio.engine.framer.SessionContextDumper;
import uk.co.real_logic.artio.session.CompositeKey;
import uk.co.real_logic.artio.session.SessionIdStrategy;
import uk.co.real_logic.artio.util.AsciiBuffer;
import uk.co.real_logic.artio.util.MutableAsciiBuffer;

public class SessionContextCreator {
    public static void main(String[] args) {
        String[][] compids = new String[][]{};
        String fileName = args[0];
        File bufferFile = new File(fileName);
        if (bufferFile.exists()) {
            bufferFile.delete();
        }
        int bigBuffer = 0x400000;
        MappedFile mappedFile = MappedFile.map((File)bufferFile, (int)0x400000);
        SessionIdStrategy idStrategy = SessionIdStrategy.senderAndTarget();
        FixContexts contexts = new FixContexts(mappedFile, idStrategy, 1, throwable -> throwable.printStackTrace(System.out));
        FixDictionary dictionary = FixDictionary.of((Class)FixDictionary.findDefault());
        MutableAsciiBuffer buffer = new MutableAsciiBuffer(new byte[1024]);
        for (String[] compIdPair : compids) {
            String localCompId = compIdPair[0];
            String remoteCompId = compIdPair[1];
            System.out.println("localCompId = " + localCompId + ", remoteCompId = " + remoteCompId);
            HeaderEncoder encoder = new HeaderEncoder().senderCompID((CharSequence)remoteCompId).targetCompID((CharSequence)localCompId).msgType((CharSequence)"A").sendingTime(new byte[1]);
            long result = encoder.startMessage(buffer, 0);
            int length = Encoder.length((long)result);
            int offset = Encoder.offset((long)result);
            HeaderDecoder decoder = new HeaderDecoder();
            decoder.reset();
            decoder.decode((AsciiBuffer)buffer, offset, length);
            CompositeKey compositeKey = idStrategy.onAcceptLogon((SessionHeaderDecoder)decoder);
            SessionContext sessionContext = contexts.newSessionContext(compositeKey, dictionary);
            System.out.println("sessionContext = " + sessionContext.sessionId());
        }
        SessionContextDumper.main(new String[]{fileName});
    }
}

