/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.dictionary;

import java.io.File;
import java.util.Arrays;
import uk.co.real_logic.artio.dictionary.generation.CodecConfiguration;
import uk.co.real_logic.artio.dictionary.generation.CodecGenerator;
import uk.co.real_logic.artio.dictionary.generation.SharedCodecConfiguration;

public final class CodecSharingExample {
    public static void main(String[] args) throws Exception {
        String dictionaryDirectory = args[0];
        String outputPath = args[1];
        boolean shouldShare = Boolean.parseBoolean(args[2]);
        File dir = new File(dictionaryDirectory);
        Object[] dictionaryFiles = dir.listFiles((ignore, name) -> name.endsWith(".xml"));
        System.out.println("Found Input Dictionaries: " + Arrays.toString(dictionaryFiles));
        String[] dictNames = (String[])Arrays.stream(dictionaryFiles).map(file -> {
            String name = file.getName();
            return name.substring(0, name.length() - 4);
        }).toArray(String[]::new);
        if (shouldShare) {
            String[] fileNames = (String[])Arrays.stream(dictionaryFiles).map(File::getAbsolutePath).toArray(String[]::new);
            CodecConfiguration config = new CodecConfiguration().outputPath(outputPath);
            SharedCodecConfiguration sharedCodecs = config.sharedCodecsEnabled();
            for (int i = 0; i < dictionaryFiles.length; ++i) {
                String fileName = new File(fileNames[i]).getName();
                Object dictionaryFile = dictionaryFiles[i];
                sharedCodecs.withDictionary(fileName, new String[]{((File)dictionaryFile).getAbsolutePath()});
            }
            CodecGenerator.generate((CodecConfiguration)config);
        } else {
            for (int i = 0; i < dictionaryFiles.length; ++i) {
                System.out.println(dictNames[i]);
                String dictionaryOutputPath = outputPath + File.separator + dictNames[i];
                String dictionaryPath = ((File)dictionaryFiles[i]).getAbsolutePath();
                CodecConfiguration config = new CodecConfiguration().outputPath(dictionaryOutputPath).fileNames(new String[]{dictionaryPath});
                CodecGenerator.generate((CodecConfiguration)config);
            }
        }
    }
}

