/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.example_exchange;

import io.aeron.archive.Archive;
import io.aeron.archive.ArchiveThreadingMode;
import io.aeron.archive.ArchivingMediaDriver;
import io.aeron.driver.MediaDriver;
import io.aeron.driver.ThreadingMode;
import java.io.File;
import java.util.Collections;
import org.agrona.IoUtil;
import uk.co.real_logic.artio.CommonConfiguration;
import uk.co.real_logic.artio.SampleUtil;
import uk.co.real_logic.artio.engine.EngineConfiguration;
import uk.co.real_logic.artio.engine.FixEngine;
import uk.co.real_logic.artio.example_exchange.ExchangeAgent;
import uk.co.real_logic.artio.validation.AuthenticationStrategy;
import uk.co.real_logic.artio.validation.MessageValidationStrategy;

public final class ExchangeApplication {
    public static final String ACCEPTOR_COMP_ID = "exexchange";
    public static final String INITIATOR_COMP_ID = "extrader";

    public static void main(String[] args) throws Exception {
        MessageValidationStrategy validationStrategy = MessageValidationStrategy.targetCompId((String)ACCEPTOR_COMP_ID).and(MessageValidationStrategy.senderCompId(Collections.singletonList(INITIATOR_COMP_ID)));
        AuthenticationStrategy authenticationStrategy = AuthenticationStrategy.of((MessageValidationStrategy)validationStrategy);
        EngineConfiguration configuration = new EngineConfiguration().bindTo("localhost", 9999).libraryAeronChannel("aeron:ipc").logFileDir("exchange-application");
        configuration.authenticationStrategy(authenticationStrategy);
        ExchangeApplication.cleanupOldLogFileDir(configuration);
        MediaDriver.Context context = new MediaDriver.Context().threadingMode(ThreadingMode.SHARED).sharedIdleStrategy(CommonConfiguration.backoffIdleStrategy()).dirDeleteOnStart(true);
        Archive.Context archiveContext = new Archive.Context().threadingMode(ArchiveThreadingMode.SHARED).idleStrategySupplier(CommonConfiguration::backoffIdleStrategy).deleteArchiveOnStart(true);
        try (ArchivingMediaDriver driver = ArchivingMediaDriver.launch((MediaDriver.Context)context, (Archive.Context)archiveContext);
             FixEngine gateway = FixEngine.launch((EngineConfiguration)configuration);){
            SampleUtil.runAgentUntilSignal(new ExchangeAgent(), driver.mediaDriver());
        }
        System.exit(0);
    }

    public static void cleanupOldLogFileDir(EngineConfiguration configuration) {
        IoUtil.delete((File)new File(configuration.logFileDir()), (boolean)true);
    }
}

