/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio;

import io.aeron.driver.MediaDriver;
import java.util.concurrent.atomic.AtomicBoolean;
import org.agrona.concurrent.Agent;
import org.agrona.concurrent.AgentRunner;
import org.agrona.concurrent.SigInt;
import org.agrona.concurrent.status.AtomicCounter;
import uk.co.real_logic.artio.CommonConfiguration;
import uk.co.real_logic.artio.library.FixLibrary;
import uk.co.real_logic.artio.library.LibraryConfiguration;

public final class SampleUtil {
    public static FixLibrary blockingConnect(LibraryConfiguration configuration) {
        FixLibrary library = FixLibrary.connect((LibraryConfiguration)configuration);
        while (!library.isConnected()) {
            library.poll(1);
            Thread.yield();
        }
        return library;
    }

    public static void runAgentUntilSignal(Agent agent, MediaDriver mediaDriver) throws InterruptedException {
        AtomicCounter errorCounter = mediaDriver.context().countersManager().newCounter("exchange_agent_errors");
        AgentRunner runner = new AgentRunner(CommonConfiguration.backoffIdleStrategy(), Throwable::printStackTrace, errorCounter, agent);
        Thread thread = AgentRunner.startOnThread((AgentRunner)runner);
        AtomicBoolean running = new AtomicBoolean(true);
        SigInt.register(() -> running.set(false));
        while (running.get()) {
            Thread.sleep(100L);
        }
        thread.join();
    }
}

