/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.session;

import io.aeron.logbuffer.ControlledFragmentHandler;
import org.agrona.concurrent.EpochClock;
import org.agrona.concurrent.status.AtomicCounter;
import uk.co.real_logic.artio.decoder.LogonDecoder;
import uk.co.real_logic.artio.messages.SessionState;
import uk.co.real_logic.artio.protocol.GatewayPublication;
import uk.co.real_logic.artio.session.CompositeKey;
import uk.co.real_logic.artio.session.InternalSession;
import uk.co.real_logic.artio.session.SessionIdStrategy;
import uk.co.real_logic.artio.session.SessionProxy;
import uk.co.real_logic.artio.util.MutableAsciiBuffer;

public class InitiatorSession
extends InternalSession {
    private final boolean resetSeqNum;

    public InitiatorSession(int heartbeatInterval, long connectionId, EpochClock clock, SessionProxy proxy, GatewayPublication publication, SessionIdStrategy sessionIdStrategy, long sendingTimeWindow, AtomicCounter receivedMsgSeqNo, AtomicCounter sentMsgSeqNo, int libraryId, int initialSentSequenceNumber, int sequenceIndex, SessionState state, boolean resetSeqNum, long reasonableTransmissionTimeInMs, MutableAsciiBuffer asciiBuffer, boolean enableLastMsgSeqNumProcessed) {
        super(heartbeatInterval, connectionId, clock, state, proxy, publication, sessionIdStrategy, sendingTimeWindow, receivedMsgSeqNo, sentMsgSeqNo, libraryId, initialSentSequenceNumber, sequenceIndex, reasonableTransmissionTimeInMs, asciiBuffer, enableLastMsgSeqNumProcessed);
        this.resetSeqNum = resetSeqNum;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public ControlledFragmentHandler.Action onLogon(int heartbeatInterval, int msgSeqNo, long sessionId, CompositeKey sessionKey, long sendingTime, long origSendingTime, String username, String password, boolean isPossDupOrResend, boolean resetSeqNumFlag, boolean possDup) {
        ControlledFragmentHandler.Action action = this.validateOrRejectHeartbeat(heartbeatInterval);
        if (action != null) {
            return action;
        }
        action = this.validateOrRejectSendingTime(sendingTime);
        if (action != null) {
            return action;
        }
        long logonTime = this.sendingTime(sendingTime, origSendingTime);
        if (resetSeqNumFlag) {
            return this.onResetSeqNumLogon(heartbeatInterval, username, password, logonTime, msgSeqNo);
        }
        if (this.state() != SessionState.SENT_LOGON) return this.onMessage(msgSeqNo, LogonDecoder.MESSAGE_TYPE_BYTES, sendingTime, origSendingTime, isPossDupOrResend, possDup);
        int expectedSeqNo = this.expectedReceivedSeqNum();
        if (msgSeqNo == expectedSeqNo) {
            if (1 == msgSeqNo) {
                this.logonTime(logonTime);
            }
            this.setLogonState(heartbeatInterval, username, password);
            this.notifyLogonListener();
            action = this.onMessage(msgSeqNo, LogonDecoder.MESSAGE_TYPE_BYTES, sendingTime, origSendingTime, isPossDupOrResend, possDup);
            if (action != ControlledFragmentHandler.Action.ABORT) return ControlledFragmentHandler.Action.CONTINUE;
            return ControlledFragmentHandler.Action.ABORT;
        }
        if (expectedSeqNo >= msgSeqNo) return this.msgSeqNumTooLow(msgSeqNo, expectedSeqNo);
        this.setLogonState(heartbeatInterval, username, password);
        this.notifyLogonListener();
        return this.requestResend(expectedSeqNo, msgSeqNo);
    }

    @Override
    public int poll(long time) {
        int actions = 0;
        if (this.state() == SessionState.CONNECTED && this.id() != -1L) {
            this.state(SessionState.SENT_LOGON);
            int heartbeatIntervalInS = (int)(this.heartbeatIntervalInMs() / 1000L);
            int sentSeqNum = this.resetSeqNum ? 1 : this.newSentSeqNum();
            long position = this.proxy.logon(heartbeatIntervalInS, sentSeqNum, this.username(), this.password(), this.resetSeqNum, this.sequenceIndex(), this.lastMsgSeqNumProcessed());
            if (position >= 0L) {
                this.lastSentMsgSeqNum(sentSeqNum);
            }
            ++actions;
        }
        return actions + super.poll(time);
    }
}

