/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.protocol;

import io.aeron.ExclusivePublication;
import io.aeron.logbuffer.BufferClaim;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.agrona.concurrent.IdleStrategy;
import org.agrona.concurrent.status.AtomicCounter;
import uk.co.real_logic.artio.Clock;
import uk.co.real_logic.artio.DebugLogger;
import uk.co.real_logic.artio.LogTag;
import uk.co.real_logic.artio.engine.SessionInfo;
import uk.co.real_logic.artio.messages.ApplicationHeartbeatEncoder;
import uk.co.real_logic.artio.messages.AwaitingResend;
import uk.co.real_logic.artio.messages.Bool;
import uk.co.real_logic.artio.messages.ConnectEncoder;
import uk.co.real_logic.artio.messages.ConnectionType;
import uk.co.real_logic.artio.messages.ControlNotificationEncoder;
import uk.co.real_logic.artio.messages.DisconnectEncoder;
import uk.co.real_logic.artio.messages.DisconnectReason;
import uk.co.real_logic.artio.messages.ErrorDecoder;
import uk.co.real_logic.artio.messages.ErrorEncoder;
import uk.co.real_logic.artio.messages.FixMessageDecoder;
import uk.co.real_logic.artio.messages.FixMessageEncoder;
import uk.co.real_logic.artio.messages.GatewayError;
import uk.co.real_logic.artio.messages.InitiateConnectionDecoder;
import uk.co.real_logic.artio.messages.InitiateConnectionEncoder;
import uk.co.real_logic.artio.messages.LibraryConnectEncoder;
import uk.co.real_logic.artio.messages.LibraryTimeoutEncoder;
import uk.co.real_logic.artio.messages.ManageSessionEncoder;
import uk.co.real_logic.artio.messages.MessageStatus;
import uk.co.real_logic.artio.messages.NewSentPositionEncoder;
import uk.co.real_logic.artio.messages.NotLeaderEncoder;
import uk.co.real_logic.artio.messages.ReleaseSessionEncoder;
import uk.co.real_logic.artio.messages.ReleaseSessionReplyEncoder;
import uk.co.real_logic.artio.messages.RequestDisconnectEncoder;
import uk.co.real_logic.artio.messages.RequestSessionEncoder;
import uk.co.real_logic.artio.messages.RequestSessionReplyEncoder;
import uk.co.real_logic.artio.messages.ResetLibrarySequenceNumberEncoder;
import uk.co.real_logic.artio.messages.ResetSequenceNumber;
import uk.co.real_logic.artio.messages.ResetSequenceNumberEncoder;
import uk.co.real_logic.artio.messages.ResetSessionIdsEncoder;
import uk.co.real_logic.artio.messages.SequenceNumberType;
import uk.co.real_logic.artio.messages.SessionReplyStatus;
import uk.co.real_logic.artio.messages.SessionState;
import uk.co.real_logic.artio.messages.SessionStatus;
import uk.co.real_logic.artio.messages.SlowStatus;
import uk.co.real_logic.artio.messages.SlowStatusNotificationEncoder;
import uk.co.real_logic.artio.protocol.ClaimablePublication;

public class GatewayPublication
extends ClaimablePublication {
    public static final int FRAME_SIZE = 45 + FixMessageDecoder.bodyHeaderLength();
    private static final int FRAMED_MESSAGE_SIZE = 8 + FRAME_SIZE;
    private static final byte[] NO_BYTES = new byte[0];
    private static final int HEARTBEAT_LENGTH = 20;
    private static final int LIBRARY_CONNECT_LENGTH = 20 + LibraryConnectEncoder.libraryNameHeaderLength();
    private static final int DISCONNECT_LENGTH = 21;
    private static final int RELEASE_SESSION_LENGTH = 54 + ReleaseSessionEncoder.usernameHeaderLength() + ReleaseSessionEncoder.passwordHeaderLength();
    private static final int RELEASE_SESSION_REPLY_LENGTH = 21;
    private static final int REQUEST_SESSION_LENGTH = 36;
    private static final int REQUEST_SESSION_REPLY_LENGTH = 21;
    private static final int CONNECT_FIXED_LENGTH = 16 + ConnectEncoder.addressHeaderLength();
    private static final int NOT_LEADER_BLOCK_LENGTH = 20 + NotLeaderEncoder.libraryChannelHeaderLength();
    private static final int SLOW_STATUS_NOTIFICATION_LENGTH = 21;
    private static final byte MIDDLE_FLAG = 0;
    private static final int MANAGE_SESSION_BLOCK_LENGTH = 72 + ManageSessionEncoder.localCompIdHeaderLength() * 9;
    private static final int INITIATE_CONNECTION_LENGTH = 45 + InitiateConnectionDecoder.hostHeaderLength() * 9;
    private static final int CONTROL_NOTIFICATION_LENGTH = 15;
    private final ManageSessionEncoder manageSessionEncoder = new ManageSessionEncoder();
    private final InitiateConnectionEncoder initiateConnection = new InitiateConnectionEncoder();
    private final RequestDisconnectEncoder requestDisconnect = new RequestDisconnectEncoder();
    private final DisconnectEncoder disconnect = new DisconnectEncoder();
    private final FixMessageEncoder fixMessage = new FixMessageEncoder();
    private final ErrorEncoder error = new ErrorEncoder();
    private final ApplicationHeartbeatEncoder applicationHeartbeat = new ApplicationHeartbeatEncoder();
    private final LibraryConnectEncoder libraryConnect = new LibraryConnectEncoder();
    private final RequestSessionEncoder requestSession = new RequestSessionEncoder();
    private final RequestSessionReplyEncoder requestSessionReply = new RequestSessionReplyEncoder();
    private final ReleaseSessionEncoder releaseSession = new ReleaseSessionEncoder();
    private final ReleaseSessionReplyEncoder releaseSessionReply = new ReleaseSessionReplyEncoder();
    private final ConnectEncoder connect = new ConnectEncoder();
    private final NewSentPositionEncoder newSentPosition = new NewSentPositionEncoder();
    private final ResetSessionIdsEncoder resetSessionIds = new ResetSessionIdsEncoder();
    private final NotLeaderEncoder notLeader = new NotLeaderEncoder();
    private final ControlNotificationEncoder controlNotification = new ControlNotificationEncoder();
    private final LibraryTimeoutEncoder libraryTimeout = new LibraryTimeoutEncoder();
    private final ResetSequenceNumberEncoder resetSequenceNumber = new ResetSequenceNumberEncoder();
    private final ResetLibrarySequenceNumberEncoder resetLibrarySequenceNumber = new ResetLibrarySequenceNumberEncoder();
    private final SlowStatusNotificationEncoder slowStatusNotification = new SlowStatusNotificationEncoder();
    private final Clock clock;
    private final int maxPayloadLength;
    private final int maxInitialBodyLength;

    public GatewayPublication(ExclusivePublication dataPublication, AtomicCounter fails, IdleStrategy idleStrategy, Clock clock, int maxClaimAttempts) {
        super(maxClaimAttempts, idleStrategy, fails, dataPublication);
        this.clock = clock;
        this.maxPayloadLength = dataPublication.maxPayloadLength();
        this.maxInitialBodyLength = this.maxPayloadLength - FRAMED_MESSAGE_SIZE;
    }

    public long saveMessage(DirectBuffer srcBuffer, int srcOffset, int srcLength, int libraryId, int messageType, long sessionId, int sequenceIndex, long connectionId, MessageStatus status, int sequenceNumber) {
        BufferClaim bufferClaim = this.bufferClaim;
        long timestamp = this.clock.time();
        int framedLength = FRAMED_MESSAGE_SIZE + srcLength;
        boolean fragmented = framedLength > this.maxPayloadLength;
        int claimLength = fragmented ? this.maxPayloadLength : framedLength;
        int srcFragmentLength = fragmented ? this.maxInitialBodyLength : srcLength;
        int srcFragmentOffset = srcOffset;
        long position = this.claim(claimLength);
        if (position < 0L) {
            return position;
        }
        int offset = bufferClaim.offset();
        MutableDirectBuffer destBuffer = bufferClaim.buffer();
        this.header.wrap(destBuffer, offset).blockLength(this.fixMessage.sbeBlockLength()).templateId(this.fixMessage.sbeTemplateId()).schemaId(this.fixMessage.sbeSchemaId()).version(this.fixMessage.sbeSchemaVersion());
        this.fixMessage.wrap(destBuffer, offset += this.header.encodedLength()).libraryId(libraryId).messageType(messageType).session(sessionId).sequenceIndex(sequenceIndex).connection(connectionId).timestamp(timestamp).status(status).sequenceNumber(sequenceNumber).putBody(srcBuffer, srcFragmentOffset, srcFragmentLength);
        if (!fragmented) {
            bufferClaim.commit();
        } else {
            this.putBodyLength(srcLength, offset, destBuffer);
            bufferClaim.flags((byte)-128).commit();
            int remaining = srcLength - srcFragmentLength;
            while (remaining > 0) {
                srcFragmentOffset += srcFragmentLength;
                srcFragmentLength = Math.min(remaining, this.maxPayloadLength);
                position = this.claim(srcFragmentLength);
                if (position < 0L) {
                    return position;
                }
                bufferClaim.buffer().putBytes(bufferClaim.offset(), srcBuffer, srcFragmentOffset, srcFragmentLength);
                bufferClaim.flags((remaining -= srcFragmentLength) > 0 ? (byte)0 : 64).commit();
            }
        }
        DebugLogger.log(LogTag.FIX_MESSAGE_FLOW, "Enqueued %s%n", srcBuffer, srcOffset, srcLength);
        return position;
    }

    private void putBodyLength(int srcLength, int offset, MutableDirectBuffer destBuffer) {
        destBuffer.putShort(offset + 45, (short)srcLength, ByteOrder.LITTLE_ENDIAN);
    }

    public long saveManageSession(int libraryId, long connection, long session, int lastSentSequenceNumber, int lastReceivedSequenceNumber, long logonTime, SessionStatus sessionStatus, SlowStatus slowStatus, ConnectionType connectionType, SessionState sessionState, boolean awaitingResend, int heartbeatIntervalInS, boolean closedResendInterval, int resendRequestChunkSize, boolean sendRedundantResendRequests, boolean enableLastMsgSeqNumProcessed, long replyToId, int sequenceIndex, String localCompId, String localSubId, String localLocationId, String remoteCompId, String remoteSubId, String remoteLocationId, String address, String username, String password) {
        byte[] passwordBytes;
        byte[] usernameBytes;
        byte[] addressBytes;
        byte[] remoteLocationIdBytes;
        byte[] remoteSubIdBytes;
        byte[] remoteCompIdBytes;
        byte[] localLocationIdBytes;
        byte[] localSubIdBytes;
        byte[] localCompIdBytes = this.bytes(localCompId);
        long position = this.claim(MANAGE_SESSION_BLOCK_LENGTH + localCompIdBytes.length + (localSubIdBytes = this.bytes(localSubId)).length + (localLocationIdBytes = this.bytes(localLocationId)).length + (remoteCompIdBytes = this.bytes(remoteCompId)).length + (remoteSubIdBytes = this.bytes(remoteSubId)).length + (remoteLocationIdBytes = this.bytes(remoteLocationId)).length + (addressBytes = this.bytes(address)).length + (usernameBytes = this.bytes(username)).length + (passwordBytes = this.bytes(password)).length);
        if (position < 0L) {
            return position;
        }
        MutableDirectBuffer buffer = this.bufferClaim.buffer();
        int offset = this.bufferClaim.offset();
        this.manageSessionEncoder.wrapAndApplyHeader(buffer, offset, this.header).libraryId(libraryId).connection(connection).session(session).lastSentSequenceNumber(lastSentSequenceNumber).lastReceivedSequenceNumber(lastReceivedSequenceNumber).logonTime(logonTime).sessionStatus(sessionStatus).slowStatus(slowStatus).connectionType(connectionType).sessionState(sessionState).awaitingResend(this.encodeAwaitingResend(awaitingResend)).heartbeatIntervalInS(heartbeatIntervalInS).closedResendInterval(this.toBool(closedResendInterval)).resendRequestChunkSize(resendRequestChunkSize).sendRedundantResendRequests(this.toBool(sendRedundantResendRequests)).enableLastMsgSeqNumProcessed(this.toBool(enableLastMsgSeqNumProcessed)).replyToId(replyToId).sequenceIndex(sequenceIndex).putLocalCompId(localCompIdBytes, 0, localCompIdBytes.length).putLocalSubId(localSubIdBytes, 0, localSubIdBytes.length).putLocalLocationId(localLocationIdBytes, 0, localLocationIdBytes.length).putRemoteCompId(remoteCompIdBytes, 0, remoteCompIdBytes.length).putRemoteSubId(remoteSubIdBytes, 0, remoteSubIdBytes.length).putRemoteLocationId(remoteLocationIdBytes, 0, remoteLocationIdBytes.length).putAddress(addressBytes, 0, addressBytes.length).putUsername(usernameBytes, 0, usernameBytes.length).putPassword(passwordBytes, 0, passwordBytes.length);
        this.bufferClaim.commit();
        DebugLogger.logSbeMessage(LogTag.GATEWAY_MESSAGE, this.manageSessionEncoder);
        return position;
    }

    public long saveDisconnect(int libraryId, long connectionId, DisconnectReason reason) {
        long position = this.claim(21);
        if (position < 0L) {
            return position;
        }
        MutableDirectBuffer buffer = this.bufferClaim.buffer();
        int offset = this.bufferClaim.offset();
        this.disconnect.wrapAndApplyHeader(buffer, offset, this.header).libraryId(libraryId).connection(connectionId).reason(reason);
        this.bufferClaim.commit();
        DebugLogger.logSbeMessage(LogTag.GATEWAY_MESSAGE, this.disconnect);
        return position;
    }

    public long saveConnect(long connectionId, String address) {
        byte[] addressBytes = this.bytes(address);
        long position = this.claim(CONNECT_FIXED_LENGTH + addressBytes.length);
        if (position < 0L) {
            return position;
        }
        MutableDirectBuffer buffer = this.bufferClaim.buffer();
        int offset = this.bufferClaim.offset();
        this.connect.wrapAndApplyHeader(buffer, offset, this.header).connection(connectionId).putAddress(addressBytes, 0, addressBytes.length);
        this.bufferClaim.commit();
        DebugLogger.logSbeMessage(LogTag.GATEWAY_MESSAGE, this.connect);
        return position;
    }

    public long saveResetSessionIds() {
        long position = this.claim(8);
        if (position < 0L) {
            return position;
        }
        MutableDirectBuffer buffer = this.bufferClaim.buffer();
        int offset = this.bufferClaim.offset();
        this.resetSessionIds.wrapAndApplyHeader(buffer, offset, this.header);
        this.bufferClaim.commit();
        DebugLogger.logSbeMessage(LogTag.GATEWAY_MESSAGE, this.resetSessionIds);
        return position;
    }

    public long saveResetSequenceNumber(long sessionId) {
        long position = this.claim(16);
        if (position < 0L) {
            return position;
        }
        MutableDirectBuffer buffer = this.bufferClaim.buffer();
        int offset = this.bufferClaim.offset();
        this.resetSequenceNumber.wrapAndApplyHeader(buffer, offset, this.header).session(sessionId);
        this.bufferClaim.commit();
        DebugLogger.logSbeMessage(LogTag.GATEWAY_MESSAGE, this.resetSequenceNumber);
        return position;
    }

    public long saveResetLibrarySequenceNumber(int libraryId, long sessionId) {
        long position = this.claim(20);
        if (position < 0L) {
            return position;
        }
        MutableDirectBuffer buffer = this.bufferClaim.buffer();
        int offset = this.bufferClaim.offset();
        this.resetLibrarySequenceNumber.wrapAndApplyHeader(buffer, offset, this.header).libraryId(libraryId).session(sessionId);
        this.bufferClaim.commit();
        DebugLogger.logSbeMessage(LogTag.GATEWAY_MESSAGE, this.resetLibrarySequenceNumber);
        return position;
    }

    public long saveRequestDisconnect(int libraryId, long connectionId, DisconnectReason reason) {
        long position = this.claim(this.header.encodedLength() + 21);
        if (position < 0L) {
            return position;
        }
        MutableDirectBuffer buffer = this.bufferClaim.buffer();
        int offset = this.bufferClaim.offset();
        this.requestDisconnect.wrapAndApplyHeader(buffer, offset, this.header).libraryId(libraryId).connection(connectionId).reason(reason);
        this.bufferClaim.commit();
        DebugLogger.logSbeMessage(LogTag.GATEWAY_MESSAGE, this.requestDisconnect);
        return position;
    }

    public long saveInitiateConnection(int libraryId, String host, int port, String senderCompId, String senderSubId, String senderLocationId, String targetCompId, String targetSubId, String targetLocationId, SequenceNumberType sequenceNumberType, boolean resetSequenceNumber, int requestedInitialReceivedSequenceNumber, int requestedInitialSentSequenceNumber, boolean closedResendInterval, int resendRequestChunkSize, boolean sendRedundantResendRequests, boolean enableLastMsgSeqNumProcessed, String username, String password, int heartbeatIntervalInS, long correlationId) {
        byte[] passwordBytes;
        byte[] usernameBytes;
        byte[] targetLocationIdBytes;
        byte[] targetSubIdBytes;
        byte[] targetCompIdBytes;
        byte[] senderLocationIdBytes;
        byte[] senderSubIdBytes;
        byte[] senderCompIdBytes;
        byte[] hostBytes = this.bytes(host);
        long position = this.claim(INITIATE_CONNECTION_LENGTH + hostBytes.length + (senderCompIdBytes = this.bytes(senderCompId)).length + (senderSubIdBytes = this.bytes(senderSubId)).length + (senderLocationIdBytes = this.bytes(senderLocationId)).length + (targetCompIdBytes = this.bytes(targetCompId)).length + (targetSubIdBytes = this.bytes(targetSubId)).length + (targetLocationIdBytes = this.bytes(targetLocationId)).length + (usernameBytes = this.bytes(username)).length + (passwordBytes = this.bytes(password)).length);
        if (position < 0L) {
            return position;
        }
        MutableDirectBuffer buffer = this.bufferClaim.buffer();
        int offset = this.bufferClaim.offset();
        this.initiateConnection.wrapAndApplyHeader(buffer, offset, this.header).libraryId(libraryId).port(port).requestedInitialReceivedSequenceNumber(requestedInitialReceivedSequenceNumber).requestedInitialSentSequenceNumber(requestedInitialSentSequenceNumber).sequenceNumberType(sequenceNumberType).heartbeatIntervalInS(heartbeatIntervalInS).resetSequenceNumber(resetSequenceNumber ? ResetSequenceNumber.YES : ResetSequenceNumber.NO).correlationId(correlationId).closedResendInterval(this.toBool(closedResendInterval)).resendRequestChunkSize(resendRequestChunkSize).sendRedundantResendRequests(this.toBool(sendRedundantResendRequests)).enableLastMsgSeqNumProcessed(this.toBool(enableLastMsgSeqNumProcessed)).putHost(hostBytes, 0, hostBytes.length).putSenderCompId(senderCompIdBytes, 0, senderCompIdBytes.length).putSenderSubId(senderSubIdBytes, 0, senderSubIdBytes.length).putSenderLocationId(senderLocationIdBytes, 0, senderLocationIdBytes.length).putTargetCompId(targetCompIdBytes, 0, targetCompIdBytes.length).putTargetSubId(targetSubIdBytes, 0, targetSubIdBytes.length).putTargetLocationId(targetLocationIdBytes, 0, targetLocationIdBytes.length).putUsername(usernameBytes, 0, usernameBytes.length).putPassword(passwordBytes, 0, passwordBytes.length);
        this.bufferClaim.commit();
        DebugLogger.logSbeMessage(LogTag.GATEWAY_MESSAGE, this.initiateConnection);
        return position;
    }

    private Bool toBool(boolean value) {
        return value ? Bool.TRUE : Bool.FALSE;
    }

    public long saveError(GatewayError errorType, int libraryId, long replyToId, String message) {
        byte[] messageBytes = this.bytes(message);
        int length = this.header.encodedLength() + 14 + ErrorDecoder.messageHeaderLength() + messageBytes.length;
        long position = this.claim(length);
        if (position < 0L) {
            return position;
        }
        MutableDirectBuffer buffer = this.bufferClaim.buffer();
        int offset = this.bufferClaim.offset();
        this.error.wrapAndApplyHeader(buffer, offset, this.header).errorType(errorType).libraryId(libraryId).replyToId(replyToId).putMessage(messageBytes, 0, messageBytes.length);
        this.bufferClaim.commit();
        DebugLogger.logSbeMessage(LogTag.GATEWAY_MESSAGE, this.error);
        return position;
    }

    public long saveApplicationHeartbeat(int libraryId) {
        long position = this.claim(20);
        if (position < 0L) {
            return position;
        }
        MutableDirectBuffer buffer = this.bufferClaim.buffer();
        int offset = this.bufferClaim.offset();
        this.applicationHeartbeat.wrapAndApplyHeader(buffer, offset, this.header).libraryId(libraryId);
        this.bufferClaim.commit();
        DebugLogger.logSbeMessage(LogTag.APPLICATION_HEARTBEAT, this.applicationHeartbeat);
        return position;
    }

    public long saveLibraryConnect(int libraryId, String libraryName, long correlationId) {
        byte[] libraryNameBytes = this.bytes(libraryName);
        long position = this.claim(LIBRARY_CONNECT_LENGTH + libraryNameBytes.length);
        if (position < 0L) {
            return position;
        }
        MutableDirectBuffer buffer = this.bufferClaim.buffer();
        int offset = this.bufferClaim.offset();
        this.libraryConnect.wrapAndApplyHeader(buffer, offset, this.header).libraryId(libraryId).putLibraryName(libraryNameBytes, 0, libraryNameBytes.length).correlationId(correlationId);
        this.bufferClaim.commit();
        DebugLogger.logSbeMessage(LogTag.GATEWAY_MESSAGE, this.libraryConnect);
        return position;
    }

    public long saveReleaseSession(int libraryId, long connectionId, long sessionId, long correlationId, SessionState state, boolean awaitingResend, long heartbeatIntervalInMs, int lastSentSequenceNumber, int lastReceivedSequenceNumber, String username, String password) {
        byte[] passwordBytes;
        byte[] usernameBytes = this.bytes(username);
        long position = this.claim(RELEASE_SESSION_LENGTH + usernameBytes.length + (passwordBytes = this.bytes(password)).length);
        if (position < 0L) {
            return position;
        }
        MutableDirectBuffer buffer = this.bufferClaim.buffer();
        int offset = this.bufferClaim.offset();
        this.releaseSession.wrapAndApplyHeader(buffer, offset, this.header).libraryId(libraryId).connection(connectionId).sessionId(sessionId).correlationId(correlationId).heartbeatIntervalInMs(heartbeatIntervalInMs).state(state).awaitingResend(this.encodeAwaitingResend(awaitingResend)).lastSentSequenceNumber(lastSentSequenceNumber).lastReceivedSequenceNumber(lastReceivedSequenceNumber).putUsername(usernameBytes, 0, usernameBytes.length).putPassword(passwordBytes, 0, passwordBytes.length);
        this.bufferClaim.commit();
        DebugLogger.logSbeMessage(LogTag.GATEWAY_MESSAGE, this.releaseSession);
        return position;
    }

    private AwaitingResend encodeAwaitingResend(boolean awaitingResend) {
        return awaitingResend ? AwaitingResend.YES : AwaitingResend.NO;
    }

    public long saveReleaseSessionReply(int libraryId, SessionReplyStatus status, long replyToId) {
        long position = this.claim(21);
        if (position < 0L) {
            return position;
        }
        MutableDirectBuffer buffer = this.bufferClaim.buffer();
        int offset = this.bufferClaim.offset();
        this.releaseSessionReply.wrapAndApplyHeader(buffer, offset, this.header).replyToId(replyToId).status(status);
        this.bufferClaim.commit();
        DebugLogger.logSbeMessage(LogTag.GATEWAY_MESSAGE, this.releaseSessionReply);
        return position;
    }

    public long saveRequestSession(int libraryId, long sessionId, long correlationId, int lastReceivedSequenceNumber, int sequenceIndex) {
        long position = this.claim(36);
        if (position < 0L) {
            return position;
        }
        MutableDirectBuffer buffer = this.bufferClaim.buffer();
        int offset = this.bufferClaim.offset();
        this.requestSession.wrapAndApplyHeader(buffer, offset, this.header).libraryId(libraryId).sessionId(sessionId).correlationId(correlationId).lastReceivedSequenceNumber(lastReceivedSequenceNumber).sequenceIndex(sequenceIndex);
        this.bufferClaim.commit();
        DebugLogger.logSbeMessage(LogTag.GATEWAY_MESSAGE, this.requestSession);
        return position;
    }

    public long saveRequestSessionReply(int libraryId, SessionReplyStatus status, long replyToId) {
        long position = this.claim(21);
        if (position < 0L) {
            return position;
        }
        MutableDirectBuffer buffer = this.bufferClaim.buffer();
        int offset = this.bufferClaim.offset();
        this.requestSessionReply.wrapAndApplyHeader(buffer, offset, this.header).replyToId(replyToId).status(status);
        this.bufferClaim.commit();
        DebugLogger.logSbeMessage(LogTag.GATEWAY_MESSAGE, this.requestSessionReply);
        return position;
    }

    public long saveNotLeader(int libraryId, long replyToId, DirectBuffer channel) {
        int channelLength = channel == null ? 0 : channel.capacity();
        long position = this.claim(NOT_LEADER_BLOCK_LENGTH + channelLength);
        if (position < 0L) {
            return position;
        }
        MutableDirectBuffer buffer = this.bufferClaim.buffer();
        int offset = this.bufferClaim.offset();
        this.notLeader.wrapAndApplyHeader(buffer, offset, this.header).libraryId(libraryId).replyToId(replyToId);
        if (channel != null) {
            this.notLeader.putLibraryChannel(channel, 0, channelLength);
        }
        this.bufferClaim.commit();
        DebugLogger.logSbeMessage(LogTag.GATEWAY_MESSAGE, this.notLeader);
        return position;
    }

    public long saveNewSentPosition(int libraryId, long sentPosition) {
        long position = this.claim(20);
        if (position < 0L) {
            return position;
        }
        MutableDirectBuffer buffer = this.bufferClaim.buffer();
        int offset = this.bufferClaim.offset();
        this.newSentPosition.wrapAndApplyHeader(buffer, offset, this.header).libraryId(libraryId).position(sentPosition);
        this.bufferClaim.commit();
        DebugLogger.logSbeMessage(LogTag.GATEWAY_MESSAGE, this.newSentPosition);
        return position;
    }

    public long saveLibraryTimeout(int libraryId, long connectCorrelationId) {
        long position = this.claim(20);
        if (position < 0L) {
            return position;
        }
        MutableDirectBuffer buffer = this.bufferClaim.buffer();
        int offset = this.bufferClaim.offset();
        this.libraryTimeout.wrapAndApplyHeader(buffer, offset, this.header).libraryId(libraryId).connectCorrelationId(connectCorrelationId);
        this.bufferClaim.commit();
        DebugLogger.logSbeMessage(LogTag.GATEWAY_MESSAGE, this.libraryTimeout);
        return position;
    }

    public long saveControlNotification(int libraryId, List<SessionInfo> sessions) {
        int sessionsCount = sessions.size();
        long position = this.claim(15 + sessionsCount * ControlNotificationEncoder.SessionsEncoder.sbeBlockLength());
        if (position < 0L) {
            return position;
        }
        MutableDirectBuffer buffer = this.bufferClaim.buffer();
        int offset = this.bufferClaim.offset();
        this.controlNotification.wrapAndApplyHeader(buffer, offset, this.header).libraryId(libraryId);
        ControlNotificationEncoder.SessionsEncoder sessionsEncoder = this.controlNotification.sessionsCount(sessionsCount);
        for (int i = 0; i < sessionsCount; ++i) {
            long sessionId = sessions.get(i).sessionId();
            sessionsEncoder.next().sessionId(sessionId);
        }
        this.bufferClaim.commit();
        DebugLogger.logSbeMessage(LogTag.GATEWAY_MESSAGE, this.controlNotification);
        return position;
    }

    public long saveSlowStatusNotification(int libraryId, long connectionId, SlowStatus status) {
        long position = this.claim(21);
        if (position < 0L) {
            return position;
        }
        MutableDirectBuffer buffer = this.bufferClaim.buffer();
        int offset = this.bufferClaim.offset();
        this.slowStatusNotification.wrapAndApplyHeader(buffer, offset, this.header).libraryId(libraryId).connectionId(connectionId).status(status);
        this.bufferClaim.commit();
        DebugLogger.logSbeMessage(LogTag.GATEWAY_MESSAGE, this.slowStatusNotification);
        return position;
    }

    public int id() {
        return this.dataPublication.sessionId();
    }

    public long position() {
        return this.dataPublication.position();
    }

    private byte[] bytes(String host) {
        if (host == null) {
            return NO_BYTES;
        }
        return host.getBytes(StandardCharsets.UTF_8);
    }

    public int maxPayloadLength() {
        return this.maxPayloadLength;
    }
}

