/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.library;

import uk.co.real_logic.artio.library.LibraryPoller;
import uk.co.real_logic.artio.library.LibraryReply;
import uk.co.real_logic.artio.messages.GatewayError;
import uk.co.real_logic.artio.messages.SessionReplyStatus;

class RequestSessionReply
extends LibraryReply<SessionReplyStatus> {
    private final long sessionId;
    private final int resendFromSequenceNumber;
    private final int resendFromSequenceIndex;
    private boolean requiresResend;

    RequestSessionReply(LibraryPoller libraryPoller, long latestReplyArrivalTime, long sessionId, int resendFromSequenceNumber, int resendFromSequenceIndex) {
        super(libraryPoller, latestReplyArrivalTime);
        this.sessionId = sessionId;
        this.resendFromSequenceNumber = resendFromSequenceNumber;
        this.resendFromSequenceIndex = resendFromSequenceIndex;
        if (libraryPoller.isConnected()) {
            this.sendMessage();
        }
    }

    private void sendMessage() {
        long position = this.libraryPoller.saveRequestSession(this.sessionId, this.correlationId, this.resendFromSequenceNumber, this.resendFromSequenceIndex);
        this.requiresResend = position < 0L;
    }

    @Override
    void onComplete(SessionReplyStatus result) {
        super.onComplete(result);
    }

    @Override
    void onError(GatewayError errorType, String errorMessage) {
    }

    @Override
    boolean poll(long timeInMs) {
        if (this.requiresResend) {
            this.sendMessage();
        }
        return super.poll(timeInMs);
    }
}

