/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.engine.logger;

import java.io.File;
import org.agrona.DirectBuffer;
import org.agrona.concurrent.AtomicBuffer;
import org.agrona.concurrent.UnsafeBuffer;
import uk.co.real_logic.artio.engine.SectorFramer;

final class SequenceNumberIndexDescriptor {
    static final int HEADER_SIZE = 8;
    static final int RECORD_SIZE = 16;
    static final double SEQUENCE_NUMBER_RATIO = 0.9;

    SequenceNumberIndexDescriptor() {
    }

    static AtomicBuffer positionsBuffer(AtomicBuffer buffer, int positionsOffset) {
        return new UnsafeBuffer((DirectBuffer)buffer, positionsOffset, buffer.capacity() - positionsOffset);
    }

    static int positionTableOffset(int fileCapacity) {
        int proposedCapacity = SectorFramer.nextSectorStart((int)((double)fileCapacity * 0.9));
        if (proposedCapacity == fileCapacity) {
            return fileCapacity - 4096;
        }
        return proposedCapacity;
    }

    public static File passingPath(String indexFilePath) {
        return new File(indexFilePath + "-passing");
    }

    public static File writablePath(String indexFilePath) {
        return new File(indexFilePath + "-writable");
    }
}

