/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.engine.logger;

import uk.co.real_logic.artio.DebugLogger;
import uk.co.real_logic.artio.LogTag;

public final class RecordingRange {
    final long recordingId;
    long position = Long.MIN_VALUE;
    int length;
    int count;

    RecordingRange(long recordingId) {
        this.recordingId = recordingId;
        this.count = 0;
    }

    void add(long addPosition, int addLength) {
        long currentPosition = this.position;
        if (currentPosition == Long.MIN_VALUE) {
            this.position = addPosition;
            this.length = addLength;
            return;
        }
        long currentEnd = currentPosition + (long)this.length;
        long addEnd = addPosition + (long)addLength;
        long newEnd = Math.max(currentEnd, addEnd);
        if (currentPosition < addPosition) {
            this.length = (int)(newEnd - currentPosition);
        } else if (addPosition < currentPosition) {
            this.position = addPosition;
            this.length = (int)(newEnd - addPosition);
        } else {
            DebugLogger.log(LogTag.INDEX, "currentPosition == addPosition, %d", currentPosition);
        }
    }

    public String toString() {
        return "RecordingRange{recordingId=" + this.recordingId + ", position=" + this.position + ", length=" + this.length + ", count=" + this.count + '}';
    }
}

