/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.engine.logger;

import io.aeron.archive.status.RecordingPos;
import org.agrona.collections.Long2LongHashMap;
import org.agrona.concurrent.IdleStrategy;
import org.agrona.concurrent.status.CountersReader;

public class RecordingIdLookup {
    private final Long2LongHashMap aeronSessionIdToRecordingId = new Long2LongHashMap(-1L);
    private final IdleStrategy archiverIdleStrategy;
    private final CountersReader counters;

    public RecordingIdLookup(IdleStrategy archiverIdleStrategy, CountersReader counters) {
        this.archiverIdleStrategy = archiverIdleStrategy;
        this.counters = counters;
    }

    long getRecordingId(int aeronSessionId) {
        long recordingId = this.aeronSessionIdToRecordingId.get((long)aeronSessionId);
        while (recordingId == -1L) {
            int counterId = RecordingPos.findCounterIdBySession((CountersReader)this.counters, (int)aeronSessionId);
            if (counterId != -1 && (recordingId = RecordingPos.getRecordingId((CountersReader)this.counters, (int)counterId)) != -1L) {
                this.aeronSessionIdToRecordingId.put((long)aeronSessionId, recordingId);
            }
            this.archiverIdleStrategy.idle();
        }
        this.archiverIdleStrategy.reset();
        return recordingId;
    }
}

