/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.engine.logger;

import org.agrona.DirectBuffer;
import org.agrona.ErrorHandler;
import org.agrona.MutableDirectBuffer;
import org.agrona.collections.Int2IntHashMap;
import org.agrona.concurrent.AtomicBuffer;
import uk.co.real_logic.artio.engine.ChecksumFramer;
import uk.co.real_logic.artio.messages.MessageHeaderDecoder;
import uk.co.real_logic.artio.messages.MessageHeaderEncoder;
import uk.co.real_logic.artio.storage.messages.IndexedPositionDecoder;
import uk.co.real_logic.artio.storage.messages.IndexedPositionEncoder;

class IndexedPositionWriter {
    static final int HEADER_LENGTH = 8;
    static final int RECORD_LENGTH = 24;
    static final int POSITION_OFFSET = IndexedPositionEncoder.positionEncodingOffset();
    private static final int MISSING_RECORD = -1;
    private final IndexedPositionEncoder encoder = new IndexedPositionEncoder();
    private final int actingBlockLength = this.encoder.sbeBlockLength();
    private final int actingVersion = this.encoder.sbeSchemaVersion();
    private final IndexedPositionDecoder decoder = new IndexedPositionDecoder();
    private final Int2IntHashMap recordOffsets = new Int2IntHashMap(-1);
    private final AtomicBuffer buffer;
    private final ErrorHandler errorHandler;
    private final ChecksumFramer checksumFramer;

    IndexedPositionWriter(AtomicBuffer buffer, ErrorHandler errorHandler, int errorReportingOffset, String fileName) {
        this.buffer = buffer;
        this.errorHandler = errorHandler;
        this.checksumFramer = new ChecksumFramer(buffer, buffer.capacity(), errorHandler, errorReportingOffset, fileName);
        this.setupHeader();
    }

    private void setupHeader() {
        MessageHeaderEncoder messageHeaderEncoder = new MessageHeaderEncoder();
        MessageHeaderDecoder messageHeaderDecoder = new MessageHeaderDecoder();
        messageHeaderDecoder.wrap((DirectBuffer)this.buffer, 0);
        if (messageHeaderDecoder.blockLength() == 0) {
            messageHeaderEncoder.wrap((MutableDirectBuffer)this.buffer, 0).templateId(this.encoder.sbeTemplateId()).schemaId(this.encoder.sbeSchemaId()).blockLength(this.actingBlockLength).version(this.actingVersion);
            this.checksumFramer.updateChecksums();
        } else {
            this.checksumFramer.validateCheckSums();
        }
    }

    void indexedUpTo(int aeronSessionId, long recordingId, long position) {
        Int2IntHashMap recordOffsets = this.recordOffsets;
        int offset = recordOffsets.get(aeronSessionId);
        if (offset == -1) {
            IndexedPositionDecoder decoder = this.decoder;
            int actingBlockLength = this.actingBlockLength;
            int actingVersion = this.actingVersion;
            AtomicBuffer buffer = this.buffer;
            offset = 8;
            while (true) {
                offset = this.checksumFramer.claim(offset, 24);
                if (position == -1L) {
                    this.errorHandler.onError((Throwable)new IllegalStateException(String.format("Unable to record new session (%d), indexed position buffer full", aeronSessionId)));
                    return;
                }
                decoder.wrap((DirectBuffer)buffer, offset, actingBlockLength, actingVersion);
                if (decoder.position() == 0L) {
                    this.encoder.wrap((MutableDirectBuffer)buffer, offset).sessionId(aeronSessionId).recordingId(recordingId);
                    recordOffsets.put(aeronSessionId, offset);
                    this.putPosition(position, buffer, offset);
                    return;
                }
                offset += 24;
            }
        }
        this.putPosition(position, this.buffer, offset);
    }

    void close() {
        this.updateChecksums();
    }

    void updateChecksums() {
        this.checksumFramer.updateChecksums();
    }

    AtomicBuffer buffer() {
        return this.buffer;
    }

    private void putPosition(long position, AtomicBuffer buffer, int offset) {
        buffer.putLongVolatile(offset + POSITION_OFFSET, position);
    }
}

