/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.engine.framer;

import io.aeron.Image;
import io.aeron.logbuffer.ControlledFragmentHandler;
import uk.co.real_logic.artio.engine.framer.BlockablePosition;

class SlowPeeker
extends BlockablePosition {
    final Image normalImage;
    final Image peekImage;
    private final int peekImageTermLengthMask;

    SlowPeeker(Image peekImage, Image normalImage) {
        this.peekImage = peekImage;
        this.normalImage = normalImage;
        this.peekImageTermLengthMask = peekImage.termBufferLength() - 1;
    }

    int peek(ControlledFragmentHandler handler) {
        this.blockPosition = 0L;
        long initialPosition = this.peekImage.position();
        long peekImageLimitPosition = this.peekImageLimitPosition(initialPosition);
        long limitPosition = Math.min(this.normalImage.position(), peekImageLimitPosition);
        long resultingPosition = this.peekImage.controlledPeek(initialPosition, handler, limitPosition);
        long delta = resultingPosition - initialPosition;
        if (!this.peekImage.isClosed()) {
            if (this.blockPosition != 0L) {
                long newLimitPosition = this.peekImage.position() + (long)this.peekImage.termBufferLength();
                this.peekImage.position(Math.min(newLimitPosition, this.blockPosition));
            } else {
                this.peekImage.position(resultingPosition);
            }
            return (int)delta;
        }
        return 0;
    }

    private long peekImageLimitPosition(long currentPosition) {
        return currentPosition - (currentPosition & (long)this.peekImageTermLengthMask) + (long)this.peekImageTermLengthMask + 1L;
    }
}

