/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.engine.framer;

import java.io.IOException;
import java.nio.channels.SelectionKey;
import java.util.stream.Stream;
import org.agrona.LangUtil;
import org.agrona.collections.ArrayUtil;
import org.agrona.nio.TransportPoller;
import uk.co.real_logic.artio.engine.framer.ReceiverEndPoint;
import uk.co.real_logic.artio.messages.DisconnectReason;

class ReceiverEndPoints
extends TransportPoller {
    private ReceiverEndPoint[] endPoints = new ReceiverEndPoint[0];

    ReceiverEndPoints() {
    }

    void add(ReceiverEndPoint endPoint) {
        try {
            this.endPoints = (ReceiverEndPoint[])ArrayUtil.add((Object[])this.endPoints, (Object)endPoint);
            endPoint.register(this.selector);
        }
        catch (IOException ex) {
            LangUtil.rethrowUnchecked((Throwable)ex);
        }
    }

    void removeConnection(long connectionId, DisconnectReason reason) {
        Object[] endPoints = this.endPoints;
        int length = endPoints.length;
        int index = -1;
        for (int i = 0; i < length; ++i) {
            ReceiverEndPoint endPoint = endPoints[i];
            if (endPoint.connectionId() != connectionId) continue;
            index = i;
            endPoint.close(reason);
        }
        this.endPoints = (ReceiverEndPoint[])ArrayUtil.remove((Object[])endPoints, (int)index);
        this.selectNowToForceProcessing();
    }

    private void selectNowToForceProcessing() {
        try {
            this.selector.selectNow();
        }
        catch (IOException ex) {
            LangUtil.rethrowUnchecked((Throwable)ex);
        }
    }

    int pollEndPoints() {
        int bytesReceived = 0;
        try {
            ReceiverEndPoint[] endPoints = this.endPoints;
            int numEndPoints = endPoints.length;
            if (numEndPoints <= 5) {
                for (int i = numEndPoints - 1; i >= 0; --i) {
                    bytesReceived += endPoints[i].poll();
                }
            } else {
                this.selector.selectNow();
                SelectionKey[] keys = this.selectedKeySet.keys();
                for (int i = this.selectedKeySet.size() - 1; i >= 0; --i) {
                    bytesReceived += ((ReceiverEndPoint)keys[i].attachment()).poll();
                }
                this.selectedKeySet.reset();
            }
        }
        catch (IOException ex) {
            LangUtil.rethrowUnchecked((Throwable)ex);
        }
        return bytesReceived;
    }

    public void close() {
        Stream.of(this.endPoints).forEach(receiverEndPoint -> receiverEndPoint.close(DisconnectReason.ENGINE_SHUTDOWN));
        super.close();
    }
}

