/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.engine.framer;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import uk.co.real_logic.artio.LivenessDetector;
import uk.co.real_logic.artio.engine.SessionInfo;
import uk.co.real_logic.artio.engine.framer.GatewaySession;
import uk.co.real_logic.artio.engine.framer.GatewaySessions;
import uk.co.real_logic.artio.engine.framer.LibraryInfo;
import uk.co.real_logic.artio.engine.framer.SubscriptionSlowPeeker;

final class LiveLibraryInfo
implements LibraryInfo {
    private final int libraryId;
    private final String libraryName;
    private final LivenessDetector livenessDetector;
    private final int aeronSessionId;
    private final SubscriptionSlowPeeker.LibrarySlowPeeker librarySlowPeeker;
    private final List<GatewaySession> allSessions = new CopyOnWriteArrayList<GatewaySession>();
    private final List<SessionInfo> unmodifiableAllSessions = Collections.unmodifiableList(this.allSessions);
    private long acquireAtPosition;

    LiveLibraryInfo(int libraryId, String libraryName, LivenessDetector livenessDetector, int aeronSessionId, SubscriptionSlowPeeker.LibrarySlowPeeker librarySlowPeeker) {
        this.libraryId = libraryId;
        this.libraryName = libraryName;
        this.livenessDetector = livenessDetector;
        this.aeronSessionId = aeronSessionId;
        this.librarySlowPeeker = librarySlowPeeker;
    }

    @Override
    public int libraryId() {
        return this.libraryId;
    }

    @Override
    public String libraryName() {
        return this.libraryName;
    }

    @Override
    public List<SessionInfo> sessions() {
        return this.unmodifiableAllSessions;
    }

    public String toString() {
        return "LibraryInfo{libraryId=" + this.libraryId + ", allSessions=" + this.allSessions + '}';
    }

    int aeronSessionId() {
        return this.aeronSessionId;
    }

    List<GatewaySession> gatewaySessions() {
        return this.allSessions;
    }

    void onHeartbeat(long timeInMs) {
        this.livenessDetector.onHeartbeat(timeInMs);
    }

    int poll(long timeInMs) {
        return this.livenessDetector.poll(timeInMs);
    }

    boolean isConnected() {
        return this.livenessDetector.isConnected();
    }

    void addSession(GatewaySession session) {
        this.allSessions.add(session);
    }

    GatewaySession removeSession(long connectionId) {
        return GatewaySessions.removeSessionByConnectionId(connectionId, this.allSessions);
    }

    void acquireAtPosition(long libraryPosition) {
        this.acquireAtPosition = libraryPosition;
    }

    long acquireAtPosition() {
        return this.acquireAtPosition;
    }

    SubscriptionSlowPeeker.LibrarySlowPeeker librarySlowPeeker() {
        return this.librarySlowPeeker;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LiveLibraryInfo that = (LiveLibraryInfo)o;
        return this.libraryId == that.libraryId;
    }

    public int hashCode() {
        return this.libraryId;
    }

    void releaseSlowPeeker() {
        this.librarySlowPeeker.removeLibrary();
    }
}

