/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.engine.framer;

import io.aeron.Image;
import io.aeron.UnavailableImageHandler;
import java.util.Hashtable;
import java.util.Map;
import java.util.function.BiFunction;

class FinalImagePositions
implements UnavailableImageHandler {
    static final long UNKNOWN_POSITION = -1L;
    private static final Long LEAK_WITNESS = -1L;
    private final Map<Integer, Long> sessionIdToPosition = new Hashtable<Integer, Long>();
    private final BiFunction<Integer, Long, Long> removeOrSetWitness = (key, oldValue) -> oldValue == null ? LEAK_WITNESS : null;

    FinalImagePositions() {
    }

    public void onUnavailableImage(Image image) {
        Integer sessionId = image.sessionId();
        long position = image.position();
        Long old = this.sessionIdToPosition.remove(sessionId);
        if (old != LEAK_WITNESS) {
            this.sessionIdToPosition.put(sessionId, position);
        }
    }

    long lookupPosition(int aeronSessionId) {
        Long position = this.sessionIdToPosition.get(aeronSessionId);
        return position == null ? -1L : position;
    }

    void removePosition(int aeronSessionId) {
        Integer boxedAeronSessionId = aeronSessionId;
        this.sessionIdToPosition.compute(boxedAeronSessionId, this.removeOrSetWitness);
    }
}

