/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.engine.framer;

import uk.co.real_logic.artio.engine.framer.GatewaySession;
import uk.co.real_logic.artio.messages.DisconnectReason;

final class AuthenticationResult {
    private static final long NO_REQUIRED_POSITION = -1L;
    static final AuthenticationResult DUPLICATE_SESSION = new AuthenticationResult(DisconnectReason.DUPLICATE_SESSION);
    static final AuthenticationResult FAILED_AUTHENTICATION = new AuthenticationResult(DisconnectReason.FAILED_AUTHENTICATION);
    static final AuthenticationResult INVALID_CONFIGURATION_NOT_LOGGING_MESSAGES = new AuthenticationResult(DisconnectReason.INVALID_CONFIGURATION_NOT_LOGGING_MESSAGES);
    private final GatewaySession session;
    private final DisconnectReason reason;
    private final long requiredPosition;

    private AuthenticationResult(DisconnectReason reason) {
        this.reason = reason;
        this.session = null;
        this.requiredPosition = -1L;
    }

    AuthenticationResult(GatewaySession session) {
        this.session = session;
        this.reason = null;
        this.requiredPosition = -1L;
    }

    AuthenticationResult(GatewaySession session, long requiredPosition) {
        this.session = session;
        this.reason = null;
        this.requiredPosition = requiredPosition;
    }

    boolean isValid() {
        return this.session != null;
    }

    boolean isBackPressured() {
        return this.requiredPosition != -1L;
    }

    public long requiredPosition() {
        return this.requiredPosition;
    }

    DisconnectReason reason() {
        return this.reason;
    }
}

