/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.engine;

import uk.co.real_logic.artio.ValidationError;
import uk.co.real_logic.artio.fields.AsciiFieldFlyweight;
import uk.co.real_logic.artio.otf.MessageControl;
import uk.co.real_logic.artio.otf.OtfMessageAcceptor;
import uk.co.real_logic.artio.util.AsciiBuffer;

class PossDupFinder
implements OtfMessageAcceptor {
    static final int NO_ENTRY = -1;
    private int possDupOffset;
    private int sendingTimeOffset;
    private int sendingTimeLength;
    private int bodyLength;
    private int bodyLengthOffset;
    private int lengthOfBodyLength;
    private int origSendingTimeOffset;
    private int origSendingTimeLength;

    PossDupFinder() {
    }

    public MessageControl onNext() {
        this.possDupOffset = -1;
        this.sendingTimeOffset = -1;
        this.sendingTimeLength = -1;
        this.origSendingTimeOffset = -1;
        this.bodyLength = -1;
        this.bodyLengthOffset = -1;
        this.lengthOfBodyLength = -1;
        return MessageControl.CONTINUE;
    }

    public MessageControl onField(int tag, AsciiBuffer buffer, int offset, int length) {
        switch (tag) {
            case 43: {
                this.possDupOffset = offset;
                break;
            }
            case 52: {
                this.sendingTimeOffset = offset;
                this.sendingTimeLength = length;
                break;
            }
            case 122: {
                this.origSendingTimeOffset = offset;
                this.origSendingTimeLength = length;
                break;
            }
            case 9: {
                this.bodyLengthOffset = offset;
                this.lengthOfBodyLength = length;
                this.bodyLength = buffer.getInt(offset, offset + length);
            }
        }
        return MessageControl.CONTINUE;
    }

    public MessageControl onGroupHeader(int tag, int numInGroup) {
        return MessageControl.CONTINUE;
    }

    public MessageControl onGroupBegin(int tag, int numInGroup, int index) {
        return MessageControl.CONTINUE;
    }

    public MessageControl onGroupEnd(int tag, int numInGroup, int index) {
        return MessageControl.CONTINUE;
    }

    public MessageControl onComplete() {
        return MessageControl.CONTINUE;
    }

    public boolean onError(ValidationError error, int messageType, int tagNumber, AsciiFieldFlyweight value) {
        return false;
    }

    int possDupOffset() {
        return this.possDupOffset;
    }

    int sendingTimeEnd() {
        return this.sendingTimeOffset + this.sendingTimeLength + 1;
    }

    int sendingTimeOffset() {
        return this.sendingTimeOffset;
    }

    int sendingTimeLength() {
        return this.sendingTimeLength;
    }

    int origSendingTimeOffset() {
        return this.origSendingTimeOffset;
    }

    public int origSendingTimeLength() {
        return this.origSendingTimeLength;
    }

    int bodyLength() {
        return this.bodyLength;
    }

    int bodyLengthOffset() {
        return this.bodyLengthOffset;
    }

    int lengthOfBodyLength() {
        return this.lengthOfBodyLength;
    }
}

