/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.engine;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.StandardOpenOption;
import org.agrona.CloseHelper;
import org.agrona.IoUtil;
import org.agrona.LangUtil;
import org.agrona.concurrent.AtomicBuffer;
import org.agrona.concurrent.UnsafeBuffer;
import uk.co.real_logic.artio.CommonConfiguration;

public class MappedFile
implements AutoCloseable {
    private final File file;
    private FileChannel fileChannel;
    private AtomicBuffer buffer;

    public static MappedFile map(File bufferFile, int size) {
        try {
            FileChannel fileChannel = bufferFile.exists() ? new RandomAccessFile(bufferFile, "rw").getChannel() : IoUtil.createEmptyFile((File)bufferFile, (long)size);
            MappedByteBuffer mappedBuffer = fileChannel.map(FileChannel.MapMode.READ_WRITE, 0L, fileChannel.size());
            return new MappedFile(bufferFile, fileChannel, (AtomicBuffer)new UnsafeBuffer((ByteBuffer)mappedBuffer));
        }
        catch (IOException ex) {
            LangUtil.rethrowUnchecked((Throwable)ex);
            return null;
        }
    }

    public static MappedFile map(String bufferPath, int size) {
        return MappedFile.map(new File(bufferPath), size);
    }

    public MappedFile(File file, FileChannel fileChannel, AtomicBuffer buffer) {
        this.file = file;
        this.fileChannel = fileChannel;
        this.buffer = buffer;
    }

    public AtomicBuffer buffer() {
        return this.buffer;
    }

    public File file() {
        return this.file;
    }

    public void force() {
        this.force(this.fileChannel);
    }

    public void transferTo(File backupLocation) {
        try (FileChannel backupChannel = FileChannel.open(backupLocation.toPath(), StandardOpenOption.WRITE);){
            this.fileChannel.transferTo(0L, this.fileChannel.size(), backupChannel);
            this.force(backupChannel);
        }
        catch (Exception ex) {
            LangUtil.rethrowUnchecked((Throwable)ex);
        }
    }

    public void remap() {
        this.close();
        this.map();
    }

    public void map() {
        MappedFile remappedFile = MappedFile.map(this.file, this.buffer.capacity());
        this.fileChannel = remappedFile.fileChannel;
        this.buffer = remappedFile.buffer;
    }

    @Override
    public void close() {
        IoUtil.unmap((ByteBuffer)this.buffer.byteBuffer());
        CloseHelper.close((AutoCloseable)this.fileChannel);
    }

    public boolean isOpen() {
        return this.fileChannel.isOpen();
    }

    private void force(FileChannel fileChannel) {
        if (CommonConfiguration.FORCE_WRITES) {
            try {
                fileChannel.force(true);
            }
            catch (IOException ex) {
                LangUtil.rethrowUnchecked((Throwable)ex);
            }
        }
    }
}

