/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio;

import org.agrona.concurrent.Agent;
import org.agrona.concurrent.AgentRunner;
import org.agrona.concurrent.AtomicBuffer;
import org.agrona.concurrent.BackoffIdleStrategy;
import org.agrona.concurrent.IdleStrategy;
import org.agrona.concurrent.errors.ErrorConsumer;
import org.agrona.concurrent.errors.ErrorLogReader;
import uk.co.real_logic.artio.MonitoringFile;
import uk.co.real_logic.artio.engine.EngineConfiguration;

public class ErrorPrinter
implements Agent {
    private final ErrorConsumer errorConsumer = (observationCount, firstObservationTimestampInMs, lastObservationTimestampInMs, encodedException) -> {
        System.err.println(encodedException);
        System.err.printf("count=%d,firstTime=%d,lastTime=%d%n%n", observationCount, firstObservationTimestampInMs, lastObservationTimestampInMs);
    };
    private final AtomicBuffer errorBuffer;
    private final String agentNamePrefix;
    private long lastSeenErrorTimeInMs;

    public static void main(String[] args) {
        EngineConfiguration configuration = new EngineConfiguration();
        configuration.libraryAeronChannel("").conclude();
        MonitoringFile monitoringFile = new MonitoringFile(false, configuration);
        ErrorPrinter printer = new ErrorPrinter(monitoringFile.errorBuffer(), "", 0L);
        BackoffIdleStrategy idleStrategy = new BackoffIdleStrategy(1L, 1L, 1000L, 1000000L);
        AgentRunner runner = new AgentRunner((IdleStrategy)idleStrategy, Throwable::printStackTrace, null, (Agent)printer);
        runner.run();
    }

    public ErrorPrinter(AtomicBuffer errorBuffer, String agentNamePrefix, long startTimeInMs) {
        this.errorBuffer = errorBuffer;
        this.agentNamePrefix = agentNamePrefix;
        this.lastSeenErrorTimeInMs = startTimeInMs;
    }

    public int doWork() {
        long timeInMs = System.currentTimeMillis();
        if (timeInMs > this.lastSeenErrorTimeInMs) {
            int errors = ErrorLogReader.read((AtomicBuffer)this.errorBuffer, (ErrorConsumer)this.errorConsumer, (long)this.lastSeenErrorTimeInMs);
            if (errors > 0) {
                this.lastSeenErrorTimeInMs = timeInMs;
            }
            return errors;
        }
        return 0;
    }

    public String roleName() {
        return this.agentNamePrefix + "Error Printer";
    }
}

