/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.messages;

import java.nio.ByteOrder;
import org.agrona.DirectBuffer;

public final class Utf8StringDecoder {
    public static final int SCHEMA_ID = 666;
    public static final int SCHEMA_VERSION = 19;
    public static final int ENCODED_LENGTH = -1;
    public static final ByteOrder BYTE_ORDER = ByteOrder.LITTLE_ENDIAN;
    private int offset;
    private DirectBuffer buffer;

    public Utf8StringDecoder wrap(DirectBuffer buffer, int offset) {
        if (buffer != this.buffer) {
            this.buffer = buffer;
        }
        this.offset = offset;
        return this;
    }

    public DirectBuffer buffer() {
        return this.buffer;
    }

    public int offset() {
        return this.offset;
    }

    public int encodedLength() {
        return -1;
    }

    public int sbeSchemaId() {
        return 666;
    }

    public int sbeSchemaVersion() {
        return 19;
    }

    public static int lengthEncodingOffset() {
        return 0;
    }

    public static int lengthEncodingLength() {
        return 2;
    }

    public static int lengthSinceVersion() {
        return 0;
    }

    public static int lengthNullValue() {
        return 65535;
    }

    public static int lengthMinValue() {
        return 0;
    }

    public static int lengthMaxValue() {
        return 65534;
    }

    public int length() {
        return this.buffer.getShort(this.offset + 0, ByteOrder.LITTLE_ENDIAN) & 0xFFFF;
    }

    public static int varDataEncodingOffset() {
        return 2;
    }

    public static int varDataEncodingLength() {
        return -1;
    }

    public static int varDataSinceVersion() {
        return 0;
    }

    public static short varDataNullValue() {
        return 255;
    }

    public static short varDataMinValue() {
        return 0;
    }

    public static short varDataMaxValue() {
        return 254;
    }

    public String toString() {
        if (null == this.buffer) {
            return "";
        }
        return this.appendTo(new StringBuilder()).toString();
    }

    public StringBuilder appendTo(StringBuilder builder) {
        if (null == this.buffer) {
            return builder;
        }
        builder.append('(');
        builder.append("length=");
        builder.append(this.length());
        builder.append('|');
        builder.append(')');
        return builder;
    }
}

