/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.messages;

import java.nio.ByteOrder;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import uk.co.real_logic.artio.messages.MessageHeaderEncoder;
import uk.co.real_logic.artio.messages.MetaAttribute;
import uk.co.real_logic.artio.messages.ThrottleConfigurationDecoder;

public final class ThrottleConfigurationEncoder {
    public static final int BLOCK_LENGTH = 28;
    public static final int TEMPLATE_ID = 72;
    public static final int SCHEMA_ID = 666;
    public static final int SCHEMA_VERSION = 18;
    public static final ByteOrder BYTE_ORDER = ByteOrder.LITTLE_ENDIAN;
    private final ThrottleConfigurationEncoder parentMessage = this;
    private MutableDirectBuffer buffer;
    private int initialOffset;
    private int offset;
    private int limit;

    public int sbeBlockLength() {
        return 28;
    }

    public int sbeTemplateId() {
        return 72;
    }

    public int sbeSchemaId() {
        return 666;
    }

    public int sbeSchemaVersion() {
        return 18;
    }

    public String sbeSemanticType() {
        return "";
    }

    public MutableDirectBuffer buffer() {
        return this.buffer;
    }

    public int initialOffset() {
        return this.initialOffset;
    }

    public int offset() {
        return this.offset;
    }

    public ThrottleConfigurationEncoder wrap(MutableDirectBuffer buffer, int offset) {
        if (buffer != this.buffer) {
            this.buffer = buffer;
        }
        this.initialOffset = offset;
        this.offset = offset;
        this.limit(offset + 28);
        return this;
    }

    public ThrottleConfigurationEncoder wrapAndApplyHeader(MutableDirectBuffer buffer, int offset, MessageHeaderEncoder headerEncoder) {
        headerEncoder.wrap(buffer, offset).blockLength(28).templateId(72).schemaId(666).version(18);
        return this.wrap(buffer, offset + 8);
    }

    public int encodedLength() {
        return this.limit - this.offset;
    }

    public int limit() {
        return this.limit;
    }

    public void limit(int limit) {
        this.limit = limit;
    }

    public static int libraryIdId() {
        return 1;
    }

    public static int libraryIdSinceVersion() {
        return 0;
    }

    public static int libraryIdEncodingOffset() {
        return 0;
    }

    public static int libraryIdEncodingLength() {
        return 4;
    }

    public static String libraryIdMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static int libraryIdNullValue() {
        return Integer.MIN_VALUE;
    }

    public static int libraryIdMinValue() {
        return -2147483647;
    }

    public static int libraryIdMaxValue() {
        return Integer.MAX_VALUE;
    }

    public ThrottleConfigurationEncoder libraryId(int value) {
        this.buffer.putInt(this.offset + 0, value, ByteOrder.LITTLE_ENDIAN);
        return this;
    }

    public static int correlationIdId() {
        return 2;
    }

    public static int correlationIdSinceVersion() {
        return 0;
    }

    public static int correlationIdEncodingOffset() {
        return 4;
    }

    public static int correlationIdEncodingLength() {
        return 8;
    }

    public static String correlationIdMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static long correlationIdNullValue() {
        return Long.MIN_VALUE;
    }

    public static long correlationIdMinValue() {
        return -9223372036854775807L;
    }

    public static long correlationIdMaxValue() {
        return Long.MAX_VALUE;
    }

    public ThrottleConfigurationEncoder correlationId(long value) {
        this.buffer.putLong(this.offset + 4, value, ByteOrder.LITTLE_ENDIAN);
        return this;
    }

    public static int sessionId() {
        return 3;
    }

    public static int sessionSinceVersion() {
        return 0;
    }

    public static int sessionEncodingOffset() {
        return 12;
    }

    public static int sessionEncodingLength() {
        return 8;
    }

    public static String sessionMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static long sessionNullValue() {
        return Long.MIN_VALUE;
    }

    public static long sessionMinValue() {
        return -9223372036854775807L;
    }

    public static long sessionMaxValue() {
        return Long.MAX_VALUE;
    }

    public ThrottleConfigurationEncoder session(long value) {
        this.buffer.putLong(this.offset + 12, value, ByteOrder.LITTLE_ENDIAN);
        return this;
    }

    public static int throttleWindowInMsId() {
        return 4;
    }

    public static int throttleWindowInMsSinceVersion() {
        return 0;
    }

    public static int throttleWindowInMsEncodingOffset() {
        return 20;
    }

    public static int throttleWindowInMsEncodingLength() {
        return 4;
    }

    public static String throttleWindowInMsMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static int throttleWindowInMsNullValue() {
        return Integer.MIN_VALUE;
    }

    public static int throttleWindowInMsMinValue() {
        return -2147483647;
    }

    public static int throttleWindowInMsMaxValue() {
        return Integer.MAX_VALUE;
    }

    public ThrottleConfigurationEncoder throttleWindowInMs(int value) {
        this.buffer.putInt(this.offset + 20, value, ByteOrder.LITTLE_ENDIAN);
        return this;
    }

    public static int throttleLimitOfMessagesId() {
        return 5;
    }

    public static int throttleLimitOfMessagesSinceVersion() {
        return 0;
    }

    public static int throttleLimitOfMessagesEncodingOffset() {
        return 24;
    }

    public static int throttleLimitOfMessagesEncodingLength() {
        return 4;
    }

    public static String throttleLimitOfMessagesMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static int throttleLimitOfMessagesNullValue() {
        return Integer.MIN_VALUE;
    }

    public static int throttleLimitOfMessagesMinValue() {
        return -2147483647;
    }

    public static int throttleLimitOfMessagesMaxValue() {
        return Integer.MAX_VALUE;
    }

    public ThrottleConfigurationEncoder throttleLimitOfMessages(int value) {
        this.buffer.putInt(this.offset + 24, value, ByteOrder.LITTLE_ENDIAN);
        return this;
    }

    public String toString() {
        if (null == this.buffer) {
            return "";
        }
        return this.appendTo(new StringBuilder()).toString();
    }

    public StringBuilder appendTo(StringBuilder builder) {
        if (null == this.buffer) {
            return builder;
        }
        ThrottleConfigurationDecoder decoder = new ThrottleConfigurationDecoder();
        decoder.wrap((DirectBuffer)this.buffer, this.initialOffset, 28, 18);
        return decoder.appendTo(builder);
    }
}

