/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.messages;

import java.nio.ByteOrder;
import org.agrona.DirectBuffer;
import uk.co.real_logic.artio.messages.FixPProtocolType;
import uk.co.real_logic.artio.messages.MetaAttribute;

public final class InboundFixPConnectDecoder {
    public static final int BLOCK_LENGTH = 20;
    public static final int TEMPLATE_ID = 67;
    public static final int SCHEMA_ID = 666;
    public static final int SCHEMA_VERSION = 17;
    public static final ByteOrder BYTE_ORDER = ByteOrder.LITTLE_ENDIAN;
    private final InboundFixPConnectDecoder parentMessage = this;
    private DirectBuffer buffer;
    private int initialOffset;
    private int offset;
    private int limit;
    int actingBlockLength;
    int actingVersion;

    public int sbeBlockLength() {
        return 20;
    }

    public int sbeTemplateId() {
        return 67;
    }

    public int sbeSchemaId() {
        return 666;
    }

    public int sbeSchemaVersion() {
        return 17;
    }

    public String sbeSemanticType() {
        return "";
    }

    public DirectBuffer buffer() {
        return this.buffer;
    }

    public int initialOffset() {
        return this.initialOffset;
    }

    public int offset() {
        return this.offset;
    }

    public InboundFixPConnectDecoder wrap(DirectBuffer buffer, int offset, int actingBlockLength, int actingVersion) {
        if (buffer != this.buffer) {
            this.buffer = buffer;
        }
        this.initialOffset = offset;
        this.offset = offset;
        this.actingBlockLength = actingBlockLength;
        this.actingVersion = actingVersion;
        this.limit(offset + actingBlockLength);
        return this;
    }

    public int encodedLength() {
        return this.limit - this.offset;
    }

    public int limit() {
        return this.limit;
    }

    public void limit(int limit) {
        this.limit = limit;
    }

    public static int connectionId() {
        return 1;
    }

    public static int connectionSinceVersion() {
        return 0;
    }

    public static int connectionEncodingOffset() {
        return 0;
    }

    public static int connectionEncodingLength() {
        return 8;
    }

    public static String connectionMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static long connectionNullValue() {
        return Long.MIN_VALUE;
    }

    public static long connectionMinValue() {
        return -9223372036854775807L;
    }

    public static long connectionMaxValue() {
        return Long.MAX_VALUE;
    }

    public long connection() {
        return this.buffer.getLong(this.offset + 0, ByteOrder.LITTLE_ENDIAN);
    }

    public static int sessionIdId() {
        return 2;
    }

    public static int sessionIdSinceVersion() {
        return 0;
    }

    public static int sessionIdEncodingOffset() {
        return 8;
    }

    public static int sessionIdEncodingLength() {
        return 8;
    }

    public static String sessionIdMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static long sessionIdNullValue() {
        return -1L;
    }

    public static long sessionIdMinValue() {
        return 0L;
    }

    public static long sessionIdMaxValue() {
        return -2L;
    }

    public long sessionId() {
        return this.buffer.getLong(this.offset + 8, ByteOrder.LITTLE_ENDIAN);
    }

    public static int protocolTypeId() {
        return 3;
    }

    public static int protocolTypeSinceVersion() {
        return 16;
    }

    public static int protocolTypeEncodingOffset() {
        return 16;
    }

    public static int protocolTypeEncodingLength() {
        return 2;
    }

    public static String protocolTypeMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public int protocolTypeRaw() {
        if (this.parentMessage.actingVersion < 16) {
            return 65535;
        }
        return this.buffer.getShort(this.offset + 16, ByteOrder.LITTLE_ENDIAN) & 0xFFFF;
    }

    public FixPProtocolType protocolType() {
        if (this.parentMessage.actingVersion < 16) {
            return FixPProtocolType.NULL_VAL;
        }
        return FixPProtocolType.get(this.buffer.getShort(this.offset + 16, ByteOrder.LITTLE_ENDIAN) & 0xFFFF);
    }

    public static int messageLengthId() {
        return 7;
    }

    public static int messageLengthSinceVersion() {
        return 0;
    }

    public static int messageLengthEncodingOffset() {
        return 18;
    }

    public static int messageLengthEncodingLength() {
        return 2;
    }

    public static String messageLengthMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static int messageLengthNullValue() {
        return 65535;
    }

    public static int messageLengthMinValue() {
        return 0;
    }

    public static int messageLengthMaxValue() {
        return 65534;
    }

    public int messageLength() {
        return this.buffer.getShort(this.offset + 18, ByteOrder.LITTLE_ENDIAN) & 0xFFFF;
    }

    public String toString() {
        if (null == this.buffer) {
            return "";
        }
        InboundFixPConnectDecoder decoder = new InboundFixPConnectDecoder();
        decoder.wrap(this.buffer, this.initialOffset, this.actingBlockLength, this.actingVersion);
        return decoder.appendTo(new StringBuilder()).toString();
    }

    public StringBuilder appendTo(StringBuilder builder) {
        if (null == this.buffer) {
            return builder;
        }
        int originalLimit = this.limit();
        this.limit(this.initialOffset + this.actingBlockLength);
        builder.append("[InboundFixPConnect](sbeTemplateId=");
        builder.append(67);
        builder.append("|sbeSchemaId=");
        builder.append(666);
        builder.append("|sbeSchemaVersion=");
        if (this.parentMessage.actingVersion != 17) {
            builder.append(this.parentMessage.actingVersion);
            builder.append('/');
        }
        builder.append(17);
        builder.append("|sbeBlockLength=");
        if (this.actingBlockLength != 20) {
            builder.append(this.actingBlockLength);
            builder.append('/');
        }
        builder.append(20);
        builder.append("):");
        builder.append("connection=");
        builder.append(this.connection());
        builder.append('|');
        builder.append("sessionId=");
        builder.append(this.sessionId());
        builder.append('|');
        builder.append("protocolType=");
        builder.append((Object)this.protocolType());
        builder.append('|');
        builder.append("messageLength=");
        builder.append(this.messageLength());
        this.limit(originalLimit);
        return builder;
    }
}

