/*
 * Decompiled with CFR 0.152.
 */
package uk.co.real_logic.artio.ilink;

import java.util.Properties;
import java.util.function.Consumer;
import java.util.function.LongConsumer;
import org.agrona.Verify;
import uk.co.real_logic.artio.ilink.ILink3ConnectionHandler;

public final class ILink3ConnectionConfiguration {
    public static final int DEFAULT_MAX_RETRANSMIT_QUEUE_SIZE = 0x8000000;
    public static final int DEFAULT_REQUESTED_KEEP_ALIVE_INTERVAL = 10000;
    public static final int DEFAULT_RETRANSMIT_TIMEOUT_IN_MS = 30000;
    public static final int KEEP_ALIVE_INTERVAL_MAX_VALUE = 65534;
    public static final long AUTOMATIC_INITIAL_SEQUENCE_NUMBER = -1L;
    public static final String HOST_PROP_NAME = "host";
    public static final String PORT_PROP_NAME = "port";
    public static final String SESSION_ID_PROP_NAME = "session_id";
    public static final String FIRM_ID_PROP_NAME = "firm_id";
    public static final String USER_KEY_PROP_NAME = "user_key";
    public static final String ACCESS_KEY_ID_PROP_NAME = "access_key_id";
    public static final String HOST_2 = "host_2";
    public static final String REQUESTED_KEEP_ALIVE_INTERVAL_IN_MS_PROP_NAME = "requestedKeepAliveIntervalInMs";
    public static final String INITIAL_SENT_SEQUENCE_NUMBER_PROP_NAME = "initialSentSequenceNumber";
    public static final String INITIAL_RECEIVED_SEQUENCE_NUMBER_PROP_NAME = "initialReceivedSequenceNumber";
    public static final String RE_ESTABLISH_LAST_SESSION_PROP_NAME = "re_establish_last_session";
    private final String host;
    private final int port;
    private final String sessionId;
    private final String firmId;
    private final String tradingSystemName;
    private final String tradingSystemVersion;
    private final String tradingSystemVendor;
    private final int requestedKeepAliveIntervalInMs;
    private final String userKey;
    private final long initialSentSequenceNumber;
    private final long initialReceivedSequenceNumber;
    private final String accessKeyId;
    private final boolean reEstablishLastConnection;
    private final ILink3ConnectionHandler handler;
    private final boolean useBackupHost;
    private final String backupHost;
    private final int maxRetransmitQueueSize;
    private final int retransmitNotificationTimeoutInMs;

    public static Builder fromProperties(Properties properties) {
        Builder builder = ILink3ConnectionConfiguration.builder().host(properties.getProperty(HOST_PROP_NAME)).port(Integer.parseInt(properties.getProperty(PORT_PROP_NAME))).sessionId(properties.getProperty(SESSION_ID_PROP_NAME)).firmId(properties.getProperty(FIRM_ID_PROP_NAME)).userKey(properties.getProperty(USER_KEY_PROP_NAME)).accessKeyId(properties.getProperty(ACCESS_KEY_ID_PROP_NAME)).backupHost(properties.getProperty(HOST_2));
        ILink3ConnectionConfiguration.getIfPresent(properties, v -> builder.requestedKeepAliveIntervalInMs(Integer.parseInt(v)), REQUESTED_KEEP_ALIVE_INTERVAL_IN_MS_PROP_NAME);
        ILink3ConnectionConfiguration.getLongIfPresent(properties, builder::initialSentSequenceNumber, INITIAL_SENT_SEQUENCE_NUMBER_PROP_NAME);
        ILink3ConnectionConfiguration.getLongIfPresent(properties, builder::initialReceivedSequenceNumber, INITIAL_RECEIVED_SEQUENCE_NUMBER_PROP_NAME);
        ILink3ConnectionConfiguration.getIfPresent(properties, v -> builder.reEstablishLastConnection(Boolean.parseBoolean(v)), RE_ESTABLISH_LAST_SESSION_PROP_NAME);
        return builder;
    }

    public static Builder builder() {
        return new Builder();
    }

    private static void getIfPresent(Properties properties, Consumer<String> setter, String propName) {
        String value = properties.getProperty(propName);
        if (value != null) {
            setter.accept(value);
        }
    }

    private static void getLongIfPresent(Properties properties, LongConsumer setter, String propName) {
        String value = properties.getProperty(propName);
        if (value != null) {
            setter.accept(Long.parseLong(value));
        }
    }

    public String host() {
        return this.host;
    }

    public int port() {
        return this.port;
    }

    public String sessionId() {
        return this.sessionId;
    }

    public String firmId() {
        return this.firmId;
    }

    public String tradingSystemName() {
        return this.tradingSystemName;
    }

    public String tradingSystemVersion() {
        return this.tradingSystemVersion;
    }

    public String tradingSystemVendor() {
        return this.tradingSystemVendor;
    }

    public int requestedKeepAliveIntervalInMs() {
        return this.requestedKeepAliveIntervalInMs;
    }

    public String userKey() {
        return this.userKey;
    }

    public long initialSentSequenceNumber() {
        return this.initialSentSequenceNumber;
    }

    public long initialReceivedSequenceNumber() {
        return this.initialReceivedSequenceNumber;
    }

    public boolean reEstablishLastConnection() {
        return this.reEstablishLastConnection;
    }

    public ILink3ConnectionHandler handler() {
        return this.handler;
    }

    public String accessKeyId() {
        return this.accessKeyId;
    }

    public String backupHost() {
        return this.backupHost;
    }

    public boolean useBackupHost() {
        return this.useBackupHost;
    }

    public int maxRetransmitQueueSize() {
        return this.maxRetransmitQueueSize;
    }

    public int retransmitNotificationTimeoutInMs() {
        return this.retransmitNotificationTimeoutInMs;
    }

    public int retransmitRequestMessageLimit() {
        return 2500;
    }

    private void validate() {
        Verify.notNull((Object)this.host, (String)HOST_PROP_NAME);
        Verify.notNull((Object)this.sessionId, (String)"sessionId");
        Verify.notNull((Object)this.firmId, (String)"firmId");
        Verify.notNull((Object)this.userKey, (String)"userKey");
        Verify.notNull((Object)this.accessKeyId, (String)"accessKeyId");
        Verify.notNull((Object)this.handler, (String)"handler");
        if (this.useBackupHost) {
            Verify.notNull((Object)this.backupHost, (String)"backupHost");
        }
        if (this.requestedKeepAliveIntervalInMs <= 0) {
            throw new IllegalArgumentException("requestedKeepAliveInterval must be positive, but is: " + this.requestedKeepAliveIntervalInMs);
        }
        if (this.port <= 0) {
            throw new IllegalArgumentException("port must be positive, but is: " + this.port);
        }
        if (this.maxRetransmitQueueSize <= 0) {
            throw new IllegalArgumentException("maxRetransmitQueueSize must be positive, but is: " + this.maxRetransmitQueueSize);
        }
        if (this.retransmitNotificationTimeoutInMs <= 0) {
            throw new IllegalArgumentException("retransmitNotificationTimeoutInMs must be positive, but is: " + this.retransmitNotificationTimeoutInMs);
        }
    }

    public String toString() {
        return "ILink3SessionConfiguration{host='" + this.host + '\'' + ", port=" + this.port + ", sessionId='" + this.sessionId + '\'' + ", firmId='" + this.firmId + '\'' + ", tradingSystemName='" + this.tradingSystemName + '\'' + ", tradingSystemVersion='" + this.tradingSystemVersion + '\'' + ", tradingSystemVendor='" + this.tradingSystemVendor + '\'' + ", keepAliveInterval=" + this.requestedKeepAliveIntervalInMs + ", initialSentSequenceNumber=" + this.initialSentSequenceNumber + ", accessKeyId=" + this.accessKeyId + ", handler=" + this.handler + ", maxRetransmitQueueSize=" + this.maxRetransmitQueueSize + ", retransmitNotificationTimeoutInMs=" + this.retransmitNotificationTimeoutInMs + '}';
    }

    private ILink3ConnectionConfiguration(String host, int port, String sessionId, String firmId, String tradingSystemName, String tradingSystemVersion, String tradingSystemVendor, int requestedKeepAliveIntervalInMs, String userKey, long initialSentSequenceNumber, long initialReceivedSequenceNumber, String accessKeyId, boolean reEstablishLastConnection, ILink3ConnectionHandler handler, boolean useBackupHost, String backupHost, int maxRetransmitQueueSize, int retransmitNotificationTimeoutInMs) {
        this.host = host;
        this.port = port;
        this.sessionId = sessionId;
        this.firmId = firmId;
        this.tradingSystemName = tradingSystemName;
        this.tradingSystemVersion = tradingSystemVersion;
        this.tradingSystemVendor = tradingSystemVendor;
        this.requestedKeepAliveIntervalInMs = requestedKeepAliveIntervalInMs;
        this.userKey = userKey;
        this.initialSentSequenceNumber = initialSentSequenceNumber;
        this.initialReceivedSequenceNumber = initialReceivedSequenceNumber;
        this.accessKeyId = accessKeyId;
        this.reEstablishLastConnection = reEstablishLastConnection;
        this.handler = handler;
        this.useBackupHost = useBackupHost;
        this.backupHost = backupHost;
        this.maxRetransmitQueueSize = maxRetransmitQueueSize;
        this.retransmitNotificationTimeoutInMs = retransmitNotificationTimeoutInMs;
        this.validate();
    }

    public static final class Builder {
        private String host;
        private int port;
        private String sessionId;
        private String firmId;
        private String tradingSystemName = "Artio";
        private String tradingSystemVersion = "1.0";
        private String tradingSystemVendor = "Monotonic";
        private int requestedKeepAliveIntervalInMs = 10000;
        private String userKey;
        private long initialSentSequenceNumber = -1L;
        private long initialReceivedSequenceNumber = -1L;
        private String accessKeyId;
        private boolean reEstablishLastConnection = false;
        private ILink3ConnectionHandler handler;
        private boolean useBackupHost;
        private String backupHost;
        private int maxRetransmitQueueSize = 0x8000000;
        private int retransmitNotificationTimeoutInMs = 30000;

        public ILink3ConnectionConfiguration build() {
            return new ILink3ConnectionConfiguration(this.host, this.port, this.sessionId, this.firmId, this.tradingSystemName, this.tradingSystemVersion, this.tradingSystemVendor, this.requestedKeepAliveIntervalInMs, this.userKey, this.initialSentSequenceNumber, this.initialReceivedSequenceNumber, this.accessKeyId, this.reEstablishLastConnection, this.handler, this.useBackupHost, this.backupHost, this.maxRetransmitQueueSize, this.retransmitNotificationTimeoutInMs);
        }

        public Builder host(String host) {
            this.host = host;
            return this;
        }

        public Builder port(int port) {
            this.port = port;
            return this;
        }

        public Builder sessionId(String sessionId) {
            this.sessionId = sessionId;
            return this;
        }

        public Builder firmId(String firmId) {
            this.firmId = firmId;
            return this;
        }

        public Builder tradingSystemName(String tradingSystemName) {
            this.tradingSystemName = tradingSystemName;
            return this;
        }

        public Builder tradingSystemVersion(String tradingSystemVersion) {
            this.tradingSystemVersion = tradingSystemVersion;
            return this;
        }

        public Builder tradingSystemVendor(String tradingSystemVendor) {
            this.tradingSystemVendor = tradingSystemVendor;
            return this;
        }

        public Builder requestedKeepAliveIntervalInMs(int requestedKeepAliveIntervalInMs) {
            if (requestedKeepAliveIntervalInMs > 65534) {
                throw new IllegalArgumentException("Invalid requestedKeepAliveIntervalInMs: " + requestedKeepAliveIntervalInMs + " cannot be larger than " + 65534);
            }
            this.requestedKeepAliveIntervalInMs = requestedKeepAliveIntervalInMs;
            return this;
        }

        public Builder accessKeyId(String accessKeyId) {
            this.accessKeyId = accessKeyId;
            return this;
        }

        public Builder userKey(String userKey) {
            this.userKey = userKey;
            return this;
        }

        public Builder initialSentSequenceNumber(long initialSentSequenceNumber) {
            this.initialSentSequenceNumber = initialSentSequenceNumber;
            return this;
        }

        public Builder initialReceivedSequenceNumber(long initialReceivedSequenceNumber) {
            this.initialReceivedSequenceNumber = initialReceivedSequenceNumber;
            return this;
        }

        public Builder reEstablishLastConnection(boolean reEstablishLastConnection) {
            this.reEstablishLastConnection = reEstablishLastConnection;
            return this;
        }

        public Builder handler(ILink3ConnectionHandler handler) {
            this.handler = handler;
            return this;
        }

        public Builder useBackupHost(boolean useBackupHost) {
            this.useBackupHost = useBackupHost;
            return this;
        }

        public Builder backupHost(String backupHost) {
            this.backupHost = backupHost;
            return this;
        }

        public Builder maxRetransmitQueueSizeInBytes(int maxRetransmitQueueSize) {
            this.maxRetransmitQueueSize = maxRetransmitQueueSize;
            return this;
        }

        public Builder retransmitNotificationTimeoutInMs(int retransmitNotificationTimeoutInMs) {
            this.retransmitNotificationTimeoutInMs = retransmitNotificationTimeoutInMs;
            return this;
        }
    }
}

